/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.lazy;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.lazy.DefaultModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLearner
extends AbstractLearner {
    public static final String PARAMETER_METHOD = "method";
    public static final String PARAMETER_CONSTANT = "constant";
    private static final String[] METHODS = new String[]{"median", "average", "mode", "constant"};
    public static final int MEDIAN = 0;
    public static final int AVERAGE = 1;
    public static final int MODE = 2;
    public static final int CONSTANT = 3;

    public DefaultLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        double value = 0.0;
        double[] confidences = null;
        int method = this.getParameterAsInt(PARAMETER_METHOD);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal() && (method == 0 || method == 1)) {
            this.logWarning("Cannot use method '" + METHODS[method] + "' for nominal labels: changing to 'mode'!");
            method = 2;
        } else if (!label.isNominal() && method == 2) {
            this.logWarning("Cannot use method '" + METHODS[method] + "' for numerical labels: changing to 'average'!");
            method = 1;
        }
        switch (method) {
            case 0: {
                double[] labels = new double[exampleSet.size()];
                Iterator r = exampleSet.iterator();
                int counter = 0;
                while (r.hasNext()) {
                    Example example = (Example)r.next();
                    labels[counter++] = example.getValue(example.getAttributes().getLabel());
                }
                Arrays.sort(labels);
                value = labels[exampleSet.size() / 2];
                break;
            }
            case 1: {
                exampleSet.recalculateAttributeStatistics(label);
                value = exampleSet.getStatistics(label, "average");
                break;
            }
            case 2: {
                exampleSet.recalculateAttributeStatistics(label);
                value = exampleSet.getStatistics(label, "mode");
                confidences = new double[label.getMapping().size()];
                int i = 0;
                while (i < confidences.length) {
                    confidences[i] = exampleSet.getStatistics(label, "count", label.getMapping().mapIndex(i)) / (double)exampleSet.size();
                    ++i;
                }
                break;
            }
            case 3: {
                value = this.getParameterAsDouble(PARAMETER_CONSTANT);
                break;
            }
            default: {
                throw new OperatorException("DefaultLearner: Unknown default method '" + method + "'!");
            }
        }
        this.log("Default value is '" + (label.isNominal() ? label.getMapping().mapIndex((int)value) : String.valueOf(value)) + "'.");
        return new DefaultModel(exampleSet, value, confidences);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_METHOD, "The method to compute the default.", METHODS, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_CONSTANT, "Value returned when method = constant.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        return types;
    }
}

