/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.tree.SplitPreprocessing;
import com.rapidminer.tools.RandomGenerator;
import java.util.Iterator;

public class RandomSubsetPreprocessing
implements SplitPreprocessing {
    private RandomGenerator random;
    private double subsetRatio = 0.2;

    public RandomSubsetPreprocessing(double subsetRatio, RandomGenerator random) {
        this.subsetRatio = subsetRatio;
        this.random = random;
    }

    public ExampleSet preprocess(ExampleSet inputSet) {
        ExampleSet exampleSet = (ExampleSet)inputSet.clone();
        double usedSubsetRatio = this.subsetRatio;
        if (usedSubsetRatio < 0.0) {
            double desiredNumber = Math.floor(Math.log(exampleSet.getAttributes().size()) / Math.log(2.0) + 1.0);
            usedSubsetRatio = desiredNumber / (double)exampleSet.getAttributes().size();
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        while (i.hasNext()) {
            i.next();
            if (!(this.random.nextDouble() > usedSubsetRatio)) continue;
            i.remove();
        }
        if (exampleSet.getAttributes().size() == 0) {
            int index = this.random.nextInt(inputSet.getAttributes().size());
            int counter = 0;
            for (Attribute attribute : inputSet.getAttributes()) {
                if (counter == index) {
                    exampleSet.getAttributes().addRegular(attribute);
                    break;
                }
                ++counter;
            }
        }
        return exampleSet;
    }
}

