/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomOptimizationChain
extends OperatorChain {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_TIMEOUT = "timeout";
    private int iteration;
    private double currentBestPerformance = Double.NaN;
    private double avgPerformance = 0.0;

    public RandomOptimizationChain(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return RandomOptimizationChain.this.iteration;
            }
        });
        this.addValue(new ValueDouble("performance", "The current best performance"){

            public double getDoubleValue() {
                return RandomOptimizationChain.this.currentBestPerformance;
            }
        });
        this.addValue(new ValueDouble("avg_performance", "The average performance"){

            public double getDoubleValue() {
                return RandomOptimizationChain.this.avgPerformance;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numCycles = this.getParameterAsInt(PARAMETER_ITERATIONS);
        this.iteration = 0;
        double maxValue = Double.NEGATIVE_INFINITY;
        double perfSum = 0.0;
        IOContainer bestResult = null;
        int timeout = this.getParameterAsInt(PARAMETER_TIMEOUT);
        long stoptime = timeout == -1 ? Long.MAX_VALUE : System.currentTimeMillis() + 60000L * (long)timeout;
        int i = 0;
        while (i < numCycles) {
            IOContainer io = this.applyInnerLoop();
            PerformanceVector perf = io.get(PerformanceVector.class);
            perfSum += perf.getMainCriterion().getAverage();
            if (perf.getMainCriterion().getFitness() > maxValue) {
                maxValue = perf.getMainCriterion().getFitness();
                bestResult = io;
            }
            this.currentBestPerformance = maxValue;
            ++this.iteration;
            this.avgPerformance = perfSum / (double)this.iteration;
            if (System.currentTimeMillis() > stoptime) {
                this.log("Runtime exceeded in iteration " + this.iteration + ".");
                break;
            }
            this.inApplyLoop();
            ++i;
        }
        return bestResult.getIOObjects();
    }

    private IOContainer applyInnerLoop() throws OperatorException {
        IOContainer container = this.getInput().copy();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            container = this.getOperator(i).apply(container);
            ++i;
        }
        return container;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public boolean shouldAddNonConsumedInput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_ITERATIONS, "The number of iterations to perform", 1, Integer.MAX_VALUE, false));
        types.add(new ParameterTypeInt(PARAMETER_TIMEOUT, "Timeout in minutes (-1 = no timeout)", 1, Integer.MAX_VALUE, -1));
        return types;
    }
}

