/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueSplit
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_APPLY_TO_SPECIAL_FEATURES = "apply_to_special_features";
    public static final String PARAMETER_SPLIT_PATTERN = "split_pattern";
    public static final String PARAMETER_SPLIT_MODE = "split_mode";
    public static final String[] SPLIT_MODES = new String[]{"ordered_split", "unordered_split"};
    public static final int SPLIT_MODE_ORDERED = 0;
    public static final int SPLIT_MODE_UNORDERED = 1;

    public AttributeValueSplit(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeNameRegex = this.getParameterAsString(PARAMETER_ATTRIBUTES);
        Pattern attributeNamePattern = null;
        try {
            attributeNamePattern = Pattern.compile(attributeNameRegex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, attributeNameRegex, e.getMessage());
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        if (this.getParameterAsBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES)) {
            i = exampleSet.getAttributes().allAttributes();
        }
        LinkedList<Attribute> matchingAttributes = new LinkedList<Attribute>();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            Matcher matcher = attributeNamePattern.matcher(attribute.getName());
            if (matcher.matches()) {
                if (attribute.isNominal()) {
                    matchingAttributes.add(attribute);
                } else {
                    this.logWarning("Cannot create substring for non-nominal attribute '" + attribute.getName() + "', skipping...");
                }
            }
            this.checkForStop();
        }
        String splittingRegex = this.getParameterAsString(PARAMETER_SPLIT_PATTERN);
        Pattern splittingPattern = null;
        try {
            splittingPattern = Pattern.compile(splittingRegex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, splittingRegex, e.getMessage());
        }
        int type = this.getParameterAsInt(PARAMETER_SPLIT_MODE);
        for (Attribute attribute : matchingAttributes) {
            switch (type) {
                case 0: {
                    this.orderedSplit(exampleSet, attribute, splittingPattern);
                    break;
                }
                default: {
                    this.unorderedSplit(exampleSet, attribute, splittingPattern);
                }
            }
        }
        return exampleSet;
    }

    private void orderedSplit(ExampleSet exampleSet, Attribute attribute, Pattern splittingPattern) {
        int maxNumber = 0;
        for (Example example : exampleSet) {
            String value = example.getNominalValue(attribute);
            String[] parts = splittingPattern.split(value);
            maxNumber = Math.max(maxNumber, parts.length);
        }
        if (maxNumber >= 2) {
            Attribute[] newAttributes = new Attribute[maxNumber];
            int a = 0;
            while (a < maxNumber) {
                newAttributes[a] = AttributeFactory.createAttribute(String.valueOf(attribute.getName()) + "_" + (a + 1), 1);
                exampleSet.getExampleTable().addAttribute(newAttributes[a]);
                exampleSet.getAttributes().addRegular(newAttributes[a]);
                ++a;
            }
            for (Example example : exampleSet) {
                String value = example.getNominalValue(attribute);
                String[] parts = splittingPattern.split(value);
                int p = 0;
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    example.setValue(newAttributes[p], newAttributes[p].getMapping().mapString(part));
                    ++p;
                    ++n2;
                }
                while (p < maxNumber) {
                    example.setValue(newAttributes[p], Double.NaN);
                    ++p;
                }
            }
            exampleSet.getAttributes().remove(attribute);
        }
    }

    private void unorderedSplit(ExampleSet exampleSet, Attribute attribute, Pattern splittingPattern) {
        TreeSet<String> allValues = new TreeSet<String>();
        boolean splitFound = false;
        for (Example example : exampleSet) {
            String[] parts;
            String value = example.getNominalValue(attribute);
            String[] stringArray = parts = splittingPattern.split(value);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                allValues.add(part);
                ++n2;
            }
            if (parts.length <= 1) continue;
            splitFound = true;
        }
        if (splitFound) {
            Attribute[] newAttributes = new Attribute[allValues.size()];
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            int a = 0;
            for (String value : allValues) {
                newAttributes[a] = AttributeFactory.createAttribute(String.valueOf(attribute.getName()) + "_" + value, 6);
                newAttributes[a].getMapping().mapString("false");
                newAttributes[a].getMapping().mapString("true");
                exampleSet.getExampleTable().addAttribute(newAttributes[a]);
                exampleSet.getAttributes().addRegular(newAttributes[a]);
                indexMap.put(value, a);
                ++a;
            }
            for (Example example : exampleSet) {
                Attribute[] attributeArray = newAttributes;
                int n = newAttributes.length;
                int n3 = 0;
                while (n3 < n) {
                    Attribute newAttribute = attributeArray[n3];
                    example.setValue(newAttribute, newAttribute.getMapping().mapString("false"));
                    ++n3;
                }
                String value = example.getNominalValue(attribute);
                String[] parts = splittingPattern.split(value);
                int p = 0;
                String[] stringArray = parts;
                int n4 = parts.length;
                int n5 = 0;
                while (n5 < n4) {
                    String part = stringArray[n5];
                    Attribute newAttribute = newAttributes[(Integer)indexMap.get(part)];
                    example.setValue(newAttribute, newAttribute.getMapping().mapString("true"));
                    ++p;
                    ++n5;
                }
            }
            exampleSet.getAttributes().remove(attribute);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTES, "Dividing of values will be applied to the attributes that match the given regular expression.", false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES, "Filter also special attributes (label, id...)", false));
        type = new ParameterTypeString(PARAMETER_SPLIT_PATTERN, "The pattern which is used for dividing the nominal values into different parts.", ",");
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SPLIT_MODE, "The split mode of this operator, either ordered splits (keeping the original order) or unordered (keeping basket-like information).", SPLIT_MODES, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

