/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueReplenishment
extends AbstractDataProcessing {
    public static final String PARAMETER_DEFAULT = "default";
    public static final String PARAMETER_COLUMNS = "columns";
    public static final String PARAMETER_REPLENISHMENT_VALUE = "replenishment_value";

    public ValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public abstract boolean replenishValue(double var1);

    public abstract double getReplenishmentValue(int var1, ExampleSet var2, Attribute var3, double var4, String var6);

    public abstract String[] getFunctionNames();

    public abstract int getDefaultFunction();

    public abstract int getDefaultColumnFunction();

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        eSet.recalculateAllAttributeStatistics();
        int[] replenishmentFunctions = new int[eSet.getAttributes().size()];
        int j = 0;
        while (j < replenishmentFunctions.length) {
            replenishmentFunctions[j] = this.getParameterAsInt(PARAMETER_DEFAULT);
            ++j;
        }
        for (String[] pair : this.getParameterList(PARAMETER_COLUMNS)) {
            String name = pair[0];
            int replenishmentFunctionIndex = ((ParameterTypeCategory)((ParameterTypeList)this.getParameters().getParameterType(PARAMETER_COLUMNS)).getValueType()).getIndex(pair[1]);
            int j2 = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                if (attribute.getName().equals(name)) {
                    replenishmentFunctions[j2] = replenishmentFunctionIndex;
                }
                ++j2;
            }
        }
        for (Example example : eSet) {
            int j3 = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                double value = example.getValue(attribute);
                if (this.replenishValue(value)) {
                    example.setValue(attribute, this.getReplenishmentValue(replenishmentFunctions[j3], eSet, attribute, value, this.getParameterAsString(PARAMETER_REPLENISHMENT_VALUE)));
                }
                ++j3;
            }
            this.checkForStop();
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_DEFAULT, "Function to apply to all columns that are not explicitly specified by parameter 'columns'.", this.getFunctionNames(), this.getDefaultFunction());
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeList(PARAMETER_COLUMNS, "List of replacement functions for each column.", new ParameterTypeCategory("replace_with", "The key is the attribute name. The value is the name of function used to replace the missing value.", this.getFunctionNames(), this.getDefaultColumnFunction())));
        types.add(new ParameterTypeString(PARAMETER_REPLENISHMENT_VALUE, "This value is used for some of the replenishment types.", true));
        return types;
    }
}

