/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetSuperset
extends Operator {
    public ExampleSetSuperset(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet1 = this.getInput(ExampleSet.class);
        ExampleSet exampleSet2 = this.getInput(ExampleSet.class);
        LinkedList<Attribute> newAttributesForES1 = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet2.getAttributes()) {
            if (exampleSet1.getAttributes().get(attribute.getName()) != null) continue;
            newAttributesForES1.add(AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType()));
        }
        LinkedList<Attribute> newAttributesForES2 = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet1.getAttributes()) {
            if (exampleSet2.getAttributes().get(attribute.getName()) != null) continue;
            newAttributesForES2.add(AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType()));
        }
        for (Attribute attribute : newAttributesForES1) {
            exampleSet1.getExampleTable().addAttribute(attribute);
            exampleSet1.getAttributes().addRegular(attribute);
        }
        for (Attribute attribute : newAttributesForES2) {
            exampleSet2.getExampleTable().addAttribute(attribute);
            exampleSet2.getAttributes().addRegular(attribute);
        }
        for (Example example : exampleSet1) {
            for (Attribute attribute : newAttributesForES1) {
                example.setValue(attribute, Double.NaN);
            }
        }
        for (Example example : exampleSet2) {
            for (Attribute attribute : newAttributesForES2) {
                example.setValue(attribute, Double.NaN);
            }
        }
        return new IOObject[]{exampleSet1, exampleSet2};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, ExampleSet.class};
    }
}

