/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBootstrapping
extends AbstractSamplingOperator {
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public AbstractBootstrapping(OperatorDescription description) {
        super(description);
    }

    public abstract int[] createMapping(ExampleSet var1, int var2, Random var3) throws OperatorException;

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        int[] mapping = this.createMapping(exampleSet, (int)Math.round((double)exampleSet.size() * this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO)), random);
        MappedExampleSet bootstrappedExampleSet = new MappedExampleSet(exampleSet, mapping, true);
        return bootstrappedExampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "This ratio determines the size of the new example set.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Local random seed for this operator (-1: use global random seed).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

