/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.text;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.text.TextObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextObject2ExampleSet
extends Operator {
    private static final String PARAMETER_TEXT_ATTRIBUTE = "text_attribute";
    private static final String PARAMETER_LABEL_ATTRIBUTE = "label_attribute";

    public TextObject2ExampleSet(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        TextObject text = this.getInput(TextObject.class);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Attribute textAttribute = AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_TEXT_ATTRIBUTE), 5);
        attributes.add(textAttribute);
        Attribute labelAttribute = null;
        if (!this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE).equals("") && text.isLabeled()) {
            labelAttribute = text.getLabelType() == 2 ? AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE), 7) : AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE), 2);
            attributes.add(labelAttribute);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DoubleArrayDataRow row = !this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE).equals("") && text.isLabeled() ? (text.getLabelType() == 2 ? new DoubleArrayDataRow(new double[]{textAttribute.getMapping().mapString(text.getText()), labelAttribute.getMapping().mapString(text.getClassificationLabel())}) : new DoubleArrayDataRow(new double[]{textAttribute.getMapping().mapString(text.getText()), text.getRegressionLabel()})) : new DoubleArrayDataRow(new double[]{textAttribute.getMapping().mapString(text.getText())});
        table.addDataRow(row);
        SimpleExampleSet set = new SimpleExampleSet(table);
        return new IOObject[]{set};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{TextObject.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public InputDescription getInputDescription(Class cls) {
        if (TextObject.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_TEXT_ATTRIBUTE, "The name of the text attribute.", true));
        types.add(new ParameterTypeString(PARAMETER_LABEL_ATTRIBUTE, "The name of the label attribute."));
        return types;
    }
}

