/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeValue;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessLogOperator
extends Operator {
    public static final String PARAMETER_COLUMN_NAME = "column_name";
    public static final String PARAMETER_FILENAME = "filename";
    public static final String PARAMETER_LOG = "log";
    public static final String PARAMETER_PERSISTENT = "persistent";
    public static final String PARAMETER_SORTING_TYPE = "sorting_type";
    public static final String PARAMETER_SORTING_DIMENSION = "sorting_dimension";
    public static final String PARAMETER_SORTING_K = "sorting_k";
    public static final String[] SORTING_TYPES = new String[]{"none", "top-k", "bottom-k"};
    public static final int SORTING_TYPE_NONE = 0;
    public static final int SORTING_TYPE_TOP_K = 1;
    public static final int SORTING_TYPE_BOTTOM_K = 2;

    public ProcessLogOperator(OperatorDescription description) {
        super(description);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double fetchValue(String name, int column) throws UndefinedParameterError {
        StringTokenizer reader = new StringTokenizer(name, ".");
        String type = reader.nextToken();
        if (!type.equals("operator")) {
            this.logWarning("Unknown token '" + type + "' in '" + name + "'");
            return Double.NaN;
        }
        String opName = reader.nextToken();
        Operator operator = this.getProcess().getOperator(opName);
        if (operator == null) {
            this.logWarning("Unknown operator '" + opName + "' in '" + name + "'");
            return Double.NaN;
        }
        type = reader.nextToken();
        if (type.equals("value")) {
            String valueName = reader.nextToken();
            Value value = operator.getValue(valueName);
            if (value == null) {
                this.logWarning("No such value in '" + name + "'");
                return Double.NaN;
            }
            if (!value.isNominal()) return (Double)value.getValue();
            Object actualValue = value.getValue();
            if (actualValue == null) return Double.NaN;
            String valueString = value.getValue().toString();
            SimpleDataTable table = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
            return table.mapString(column, valueString);
        }
        if (!type.equals("parameter")) {
            this.logWarning("Unknown token '" + type + "' in '" + name + "'");
            return Double.NaN;
        }
        String parameterName = reader.nextToken();
        ParameterType parameterType = operator.getParameterType(parameterName);
        if (parameterType == null) {
            this.logWarning("No such parameter in '" + name + "'");
            return Double.NaN;
        }
        if (!parameterType.isNumerical()) {
            String value = parameterType.toString(operator.getParameter(parameterName));
            SimpleDataTable table = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
            return table.mapString(column, value);
        }
        try {
            return Double.parseDouble(operator.getParameter(parameterName).toString());
        }
        catch (NumberFormatException e) {
            this.logWarning("Cannot parse parameter value of '" + name + "'");
            return Double.NaN;
        }
    }

    private String[] getValueNames() throws UndefinedParameterError {
        List<String[]> parameters = this.getParameterList(PARAMETER_LOG);
        String[] valueNames = new String[parameters.size()];
        Iterator<String[]> i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            String[] parameter = i.next();
            valueNames[j] = parameter[1];
            ++j;
        }
        return valueNames;
    }

    public void createDataTable() throws OperatorException {
        List<String[]> parameters = this.getParameterList(PARAMETER_LOG);
        String[] columnNames = new String[parameters.size()];
        Iterator<String[]> i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            String[] parameter = i.next();
            columnNames[j] = parameter[0];
            ++j;
        }
        this.getProcess().addDataTable(new SimpleDataTable(this.getName(), columnNames));
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        SimpleDataTable dataTable = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
        if (dataTable == null) {
            this.createDataTable();
        }
        DataTableRow row = this.fetchAllValues();
        if (this.getParameterAsInt(PARAMETER_SORTING_TYPE) == 0 && this.getParameterAsBoolean(PARAMETER_PERSISTENT)) {
            this.writeOnline(row);
        }
        return new IOObject[0];
    }

    private void writeOnline(DataTableRow row) throws UserError {
        DataTable table = this.getProcess().getDataTable(this.getName());
        File outputFile = this.getParameterAsFile(PARAMETER_FILENAME, true);
        try {
            int j;
            PrintWriter out;
            if (!outputFile.exists() || this.getApplyCount() == 1) {
                out = new PrintWriter(new FileWriter(outputFile));
                out.println("# Generated by " + this.getName() + "[" + this.getClass().getName() + "]");
                j = 0;
                while (j < table.getNumberOfColumns()) {
                    out.print(String.valueOf(j != 0 ? "\t" : "# ") + table.getColumnName(j));
                    ++j;
                }
                out.println();
                out.close();
            }
            out = new PrintWriter(new FileWriter(outputFile, true));
            j = 0;
            while (j < row.getNumberOfValues()) {
                out.print(String.valueOf(j != 0 ? "\t" : "") + table.getValueAsString(row, j));
                ++j;
            }
            out.println();
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 303, outputFile, e.getMessage());
        }
    }

    private DataTableRow fetchAllValues() throws UndefinedParameterError {
        String[] valueNames = this.getValueNames();
        double[] row = new double[valueNames.length];
        int i = 0;
        while (i < valueNames.length) {
            double value;
            row[i] = value = this.fetchValue(valueNames[i], i);
            ++i;
        }
        SimpleDataTableRow dataRow = new SimpleDataTableRow(row, null);
        SimpleDataTable dataTable = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
        int sortingType = this.getParameterAsInt(PARAMETER_SORTING_TYPE);
        if (sortingType == 0 || dataTable.getNumberOfRows() < this.getParameterAsInt(PARAMETER_SORTING_K)) {
            dataTable.add(dataRow);
        } else {
            String sortingDimension = this.getParameterAsString(PARAMETER_SORTING_DIMENSION);
            int sortingDimensionIndex = dataTable.getColumnIndex(sortingDimension);
            if (dataTable.isNominal(sortingDimensionIndex)) {
                String currentWorst = null;
                int currentWorstIndex = -1;
                int r = 0;
                while (r < dataTable.getNumberOfRows()) {
                    double currentValue = dataTable.getRow(r).getValue(sortingDimensionIndex);
                    String currentNominalValue = dataTable.mapIndex(sortingDimensionIndex, (int)currentValue);
                    if (currentWorst == null || sortingType == 1 && currentNominalValue.compareTo(currentWorst) < 0 || sortingType == 2 && currentNominalValue.compareTo(currentWorst) > 0) {
                        currentWorst = currentNominalValue;
                        currentWorstIndex = r;
                    }
                    ++r;
                }
                double candidateValue = dataRow.getValue(sortingDimensionIndex);
                String candidateNominalValue = dataTable.mapIndex(sortingDimensionIndex, (int)candidateValue);
                if (currentWorstIndex >= 0 && sortingType == 1 && candidateNominalValue.compareTo(currentWorst) > 0 || sortingType == 2 && candidateNominalValue.compareTo(currentWorst) < 0) {
                    dataTable.remove(dataTable.getRow(currentWorstIndex));
                    dataTable.add(dataRow);
                    dataTable.cleanMappingTables();
                }
            } else {
                double currentWorst = Double.NaN;
                int currentWorstIndex = -1;
                int r = 0;
                while (r < dataTable.getNumberOfRows()) {
                    double currentValue = dataTable.getRow(r).getValue(sortingDimensionIndex);
                    if (Double.isNaN(currentWorst) || sortingType == 1 && currentValue < currentWorst || sortingType == 2 && currentValue > currentWorst) {
                        currentWorst = currentValue;
                        currentWorstIndex = r;
                    }
                    ++r;
                }
                double candidateValue = dataRow.getValue(sortingDimensionIndex);
                if (currentWorstIndex >= 0 && sortingType == 1 && candidateValue > currentWorst || sortingType == 2 && candidateValue < currentWorst) {
                    dataTable.remove(dataTable.getRow(currentWorstIndex));
                    dataTable.add(dataRow);
                    dataTable.cleanMappingTables();
                }
            }
        }
        return dataRow;
    }

    @Override
    public void processFinished() throws OperatorException {
        DataTable table;
        super.processFinished();
        if (!this.getParameterAsBoolean(PARAMETER_PERSISTENT) && (table = this.getProcess().getDataTable(this.getName())) != null) {
            File file = null;
            try {
                file = this.getParameterAsFile(PARAMETER_FILENAME, true);
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            if (file != null) {
                this.log("Writing data to '" + file.getName() + "'");
                PrintWriter out = null;
                try {
                    try {
                        out = new PrintWriter(new FileWriter(file));
                        table.write(out);
                    }
                    catch (IOException e) {
                        throw new UserError((Operator)this, 303, file.getName(), e.getMessage());
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeFile(PARAMETER_FILENAME, "File to save the data to.", PARAMETER_LOG, true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_LOG, "List of key value pairs where the key is the column name and the value specifies the process value to log.", new ParameterTypeValue(PARAMETER_COLUMN_NAME, "operator.OPERATORNAME.[value|parameter].VALUE_NAME"));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SORTING_TYPE, "Indicates if the logged values should be sorted according to the specified dimension.", SORTING_TYPES, 0));
        type = new ParameterTypeString(PARAMETER_SORTING_DIMENSION, "If the sorting type is set to top-k or bottom-k, this dimension is used for sorting.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, true, 1, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SORTING_K, "If the sorting type is set to top-k or bottom-k, this number of results will be kept.", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, false, 1, 2));
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_PERSISTENT, "Indicates if results should be written to file immediately", false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, false, 0));
        types.add(type);
        return types;
    }
}

