/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.WekaInstancesAdaptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaTools {
    public static final String WEKA_OPERATOR_PREFIX = "W-";

    public static ExampleSet toRapidMinerExampleSet(Instances instances) {
        return WekaTools.toRapidMinerExampleSet(instances, null, 0);
    }

    public static ExampleSet toRapidMinerExampleSet(Instances instances, String attributeNamePrefix) {
        return WekaTools.toRapidMinerExampleSet(instances, attributeNamePrefix, 0);
    }

    public static ExampleSet toRapidMinerExampleSet(Instances instances, String attributeNamePrefix, int datamanagement) {
        int classIndex = instances.classIndex();
        ArrayList<com.rapidminer.example.Attribute> attributes = new ArrayList<com.rapidminer.example.Attribute>();
        int number = 1;
        int i = 0;
        while (i < instances.numAttributes()) {
            Attribute wekaAttribute = instances.attribute(i);
            int rapidMinerAttributeValueType = 4;
            if (wekaAttribute.isNominal()) {
                rapidMinerAttributeValueType = 1;
            } else if (wekaAttribute.isString()) {
                rapidMinerAttributeValueType = 5;
            }
            com.rapidminer.example.Attribute attribute = AttributeFactory.createAttribute(wekaAttribute.name(), rapidMinerAttributeValueType);
            if (i != classIndex && attributeNamePrefix != null && attributeNamePrefix.length() > 0) {
                attribute.setName(String.valueOf(attributeNamePrefix) + "_" + number++);
            }
            if (wekaAttribute.isNominal()) {
                int a = 0;
                while (a < wekaAttribute.numValues()) {
                    String nominalValue = wekaAttribute.value(a);
                    attribute.getMapping().mapString(nominalValue);
                    ++a;
                }
            }
            attributes.add(attribute);
            ++i;
        }
        com.rapidminer.example.Attribute label = null;
        if (classIndex >= 0) {
            label = (com.rapidminer.example.Attribute)attributes.get(classIndex);
            label.setName("label");
        }
        int j = 0;
        while (j < attributes.size()) {
            com.rapidminer.example.Attribute attribute = (com.rapidminer.example.Attribute)attributes.get(j);
            if (attribute.isNominal()) {
                attribute.getMapping().sortMappings();
            }
            ++j;
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory factory = new DataRowFactory(datamanagement, '.');
        LinkedList<DataRow> dataList = new LinkedList<DataRow>();
        int numberOfRapidMinerAttributes = instances.numAttributes();
        int i2 = 0;
        while (i2 < instances.numInstances()) {
            Instance instance = instances.instance(i2);
            DataRow dataRow = factory.create(numberOfRapidMinerAttributes);
            int a = 0;
            while (a < instances.numAttributes()) {
                com.rapidminer.example.Attribute attribute = table.getAttribute(a);
                double wekaValue = instance.value(a);
                if (attribute.isNominal()) {
                    String nominalValue = instances.attribute(a).value((int)wekaValue);
                    dataRow.set(attribute, attribute.getMapping().mapString(nominalValue));
                } else {
                    dataRow.set(attribute, wekaValue);
                }
                ++a;
            }
            dataRow.trim();
            dataList.add(dataRow);
            ++i2;
        }
        table.readExamples(new ListDataRowReader(dataList.iterator()));
        return table.createExampleSet(label);
    }

    public static Instances toWekaInstances(ExampleSet exampleSet, String name, int taskType) throws OperatorException {
        return new WekaInstancesAdaptor(name, exampleSet, taskType);
    }

    public static String[] getWekaParametersFromList(List rapidMinerParameters) {
        String[] parameters = new String[rapidMinerParameters.size() * 2];
        Iterator i = rapidMinerParameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object[] parameter = (Object[])i.next();
            parameters[j++] = "-" + (String)parameter[0];
            parameters[j++] = (String)parameter[1];
        }
        return parameters;
    }

    public static String[] getWekaParametersFromTypes(Operator operator, List parameterTypes) {
        LinkedList<String> parameterStrings = new LinkedList<String>();
        for (ParameterType type : parameterTypes) {
            try {
                String defaultValue;
                if (type instanceof ParameterTypeBoolean) {
                    if (Boolean.valueOf(operator.getParameterAsBoolean(type.getKey())).equals(type.getDefaultValue())) continue;
                    parameterStrings.add("-" + type.getKey());
                    continue;
                }
                if (type instanceof ParameterTypeDouble) {
                    double defaultValue2;
                    double value = operator.getParameterAsDouble(type.getKey());
                    if (Double.isNaN(value) || !Double.isNaN(defaultValue2 = ((Double)type.getDefaultValue()).doubleValue()) && defaultValue2 == value) continue;
                    parameterStrings.add("-" + type.getKey());
                    String valueString = Tools.formatIntegerIfPossible(value);
                    parameterStrings.add(valueString);
                    continue;
                }
                String value = operator.getParameterAsString(type.getKey());
                if (value == null || (defaultValue = (String)type.getDefaultValue()) != null && defaultValue.equals(value)) continue;
                parameterStrings.add("-" + type.getKey());
                if (value.indexOf("--") >= 0) {
                    StringTokenizer tokenizer = new StringTokenizer(value);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        parameterStrings.add(token);
                    }
                    continue;
                }
                parameterStrings.add(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot use parameter " + type.getKey() + ": " + e.getMessage());
            }
        }
        String[] result = new String[parameterStrings.size()];
        parameterStrings.toArray(result);
        return result;
    }

    public static ParameterType guessParameterType(Option option, String[] options) {
        if (option.numArguments() == 0) {
            String defaultString = WekaTools.getStringDefault(option.name(), options);
            if (defaultString == null) {
                return new ParameterTypeBoolean(option.name(), option.description(), WekaTools.getBooleanDefault(option.name(), options));
            }
            return new ParameterTypeString(option.name(), option.description(), defaultString);
        }
        String defaultString = WekaTools.getStringDefault(option.name(), options);
        if (defaultString == null) {
            return new ParameterTypeString(option.name(), option.description());
        }
        try {
            double defaultValue = Double.parseDouble(defaultString);
            return new ParameterTypeDouble(option.name(), option.description(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, defaultValue);
        }
        catch (NumberFormatException e) {
            return new ParameterTypeString(option.name(), option.description(), defaultString);
        }
    }

    private static boolean getBooleanDefault(String key, String[] options) {
        int i = 0;
        while (i < options.length) {
            if (options[i].equals("-" + key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getStringDefault(String key, String[] options) {
        int i = 0;
        while (i < options.length) {
            if (options[i].equals("-" + key) && i + 1 < options.length) {
                return options[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static void addParameterTypes(OptionHandler handler, List<ParameterType> types, List<ParameterType> wekaParameters, boolean meta, String metaParameter) {
        String[] defaultOptions = handler.getOptions();
        Enumeration options = handler.listOptions();
        while (options.hasMoreElements()) {
            Option option = (Option)options.nextElement();
            if (option.name().trim().length() == 0) break;
            if (meta && option.name().trim().toLowerCase().equals(metaParameter.toLowerCase())) continue;
            ParameterType type = WekaTools.guessParameterType(option, defaultOptions);
            type.setShowRange(false);
            type.setExpert(false);
            types.add(type);
            wekaParameters.add(type);
        }
    }

    public static File getWekaJarAsFile() throws IOException {
        String wekaJar = System.getProperty("rapidminer.weka.jar");
        if (wekaJar != null) {
            return new File(wekaJar);
        }
        return ParameterService.getLibraryFile("weka.jar");
    }

    public static JarFile getWekaJar() throws IOException {
        return new JarFile(WekaTools.getWekaJarAsFile());
    }

    public static String[] getWekaClasses(Class superclass) {
        return WekaTools.getWekaClasses(superclass, null, true);
    }

    public static String[] getWekaClasses(Class superclass, String seachConstraint, boolean includeConstraint) {
        if (seachConstraint != null) {
            return WekaTools.getWekaClasses(superclass, new String[]{seachConstraint}, includeConstraint);
        }
        return WekaTools.getWekaClasses(superclass, null, includeConstraint);
    }

    public static String[] getWekaClasses(Class superclass, String[] searchConstraints, boolean positive) {
        if (positive) {
            return WekaTools.getWekaClasses(superclass, searchConstraints, null);
        }
        return WekaTools.getWekaClasses(superclass, null, searchConstraints);
    }

    public static String[] getWekaClasses(Class superclass, String[] positiveSearchConstraints, String[] negativeSearchConstraints) {
        JarFile jar = null;
        try {
            jar = WekaTools.getWekaJar();
        }
        catch (IOException e) {
            return new String[0];
        }
        if (jar == null) {
            return new String[0];
        }
        LinkedList<String> classes = new LinkedList<String>();
        Tools.findImplementationsInJar(jar, superclass, classes);
        Iterator i = classes.iterator();
        block2: while (i.hasNext()) {
            int n;
            String name = (String)i.next();
            boolean removed = false;
            if (positiveSearchConstraints != null) {
                boolean shouldRemove = true;
                String[] stringArray = positiveSearchConstraints;
                int n2 = positiveSearchConstraints.length;
                n = 0;
                while (n < n2) {
                    String constraint = stringArray[n];
                    if (name.indexOf(constraint) != -1) {
                        shouldRemove = false;
                        break;
                    }
                    ++n;
                }
                if (shouldRemove) {
                    i.remove();
                    removed = true;
                }
            }
            if (removed || negativeSearchConstraints == null) continue;
            String[] stringArray = negativeSearchConstraints;
            n = negativeSearchConstraints.length;
            int n3 = 0;
            while (n3 < n) {
                String constraint = stringArray[n3];
                if (name.indexOf(constraint) != -1) {
                    i.remove();
                    continue block2;
                }
                ++n3;
            }
        }
        String[] names = new String[classes.size()];
        classes.toArray(names);
        return names;
    }

    public static void registerWekaOperators(ClassLoader classLoader, String[] classNames, String operatorClass, String firstDescription, String firstGroup, String icon) {
        WekaTools.registerWekaOperators(classLoader, classNames, new HashMap<String, String>(), operatorClass, firstDescription, firstGroup, icon);
    }

    public static void registerWekaOperators(ClassLoader classLoader, String[] classNames, Map<String, String> deprecationInfos, String operatorClass, String firstDescription, String firstGroup, String icon) {
        int i = 0;
        while (i < classNames.length) {
            String infoString = null;
            try {
                Class<?> clazz = Class.forName(classNames[i], true, classLoader);
                Object wekaObject = clazz.newInstance();
                Method method = clazz.getMethod("globalInfo", new Class[0]);
                infoString = (String)method.invoke(wekaObject, new Object[0]);
                if (infoString != null) {
                    infoString = WekaTools.htmlEscape(infoString, "&", "and");
                    infoString = WekaTools.htmlEscape(infoString, "_", "");
                    infoString = WekaTools.htmlEscape(infoString, "#", "number");
                    infoString = WekaTools.htmlEscape(infoString, "<i>", "");
                    infoString = WekaTools.htmlEscape(infoString, "</i>", "");
                    infoString = WekaTools.htmlEscape(infoString, "<b>", "");
                    infoString = WekaTools.htmlEscape(infoString, "</b>", "");
                    infoString = WekaTools.htmlEscape(infoString, "<tt>", "");
                    infoString = WekaTools.htmlEscape(infoString, "</tt>", "");
                    infoString = WekaTools.htmlEscape(infoString, "<num>", "");
                    if ((infoString = WekaTools.htmlEscape(infoString, "</num>", "")).indexOf("^") >= 0) {
                        infoString = infoString.substring(0, infoString.indexOf(".") + 1).trim();
                    }
                    if (infoString.indexOf("^") >= 0) {
                        infoString = null;
                    }
                } else {
                    LogService.getGlobal().log("Delivered infoString from Weka is empty for '" + classNames[i] + "': using default short description.", 5);
                }
            }
            catch (ClassNotFoundException e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            catch (InstantiationException e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            catch (ExceptionInInitializerError e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            catch (NoClassDefFoundError e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            catch (SecurityException e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            catch (InvocationTargetException e) {
                LogService.getGlobal().log("Cannot retrieve operator information from Weka for '" + classNames[i] + "': " + e, 5);
            }
            int lastIndex = classNames[i].lastIndexOf(".");
            String name = WEKA_OPERATOR_PREFIX + classNames[i].substring(lastIndex + 1);
            String packageName = classNames[i].substring(0, lastIndex);
            String group = packageName.substring(packageName.lastIndexOf(".") + 1);
            String groupStart = group.substring(0, 1);
            String groupEnd = group.substring(1);
            group = String.valueOf(groupStart.toUpperCase()) + groupEnd.toLowerCase();
            try {
                String deprecationInfo = null;
                if (deprecationInfos != null) {
                    deprecationInfo = deprecationInfos.get(classNames[i]);
                }
                String shortDescription = null;
                String longDescription = null;
                if (infoString != null) {
                    int pointIndex = infoString.indexOf(46);
                    if (pointIndex >= 0) {
                        String shortCandidate = infoString.substring(0, pointIndex + 1);
                        if (shortCandidate.length() > 10) {
                            shortDescription = shortCandidate;
                            longDescription = infoString;
                        } else {
                            shortDescription = String.valueOf(firstDescription.trim()) + " " + name;
                            longDescription = infoString;
                        }
                    } else {
                        shortDescription = String.valueOf(firstDescription.trim()) + " " + name;
                        longDescription = infoString;
                    }
                } else {
                    shortDescription = String.valueOf(firstDescription.trim()) + " " + name;
                    longDescription = String.valueOf(firstDescription.trim()) + " " + name;
                }
                OperatorDescription description = new OperatorDescription(classLoader, name, operatorClass, shortDescription, longDescription, firstGroup.endsWith(".") ? String.valueOf(firstGroup) + group : firstGroup, icon, deprecationInfo);
                OperatorService.registerOperator(description);
            }
            catch (OperatorCreationException e) {
                LogService.getGlobal().logWarning("Cannot construct operator '" + name + "', error: " + e.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
    }

    private static String htmlEscape(String toEscape, String what, String by) {
        String result = toEscape;
        int index = 0;
        int generalIndex = 0;
        while ((index = result.indexOf(what, generalIndex)) >= 0) {
            String first = result.substring(0, index);
            String last = result.substring(index + what.length());
            result = String.valueOf(first) + by + last;
            generalIndex = index + by.length();
        }
        return result;
    }
}

