/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.distribution;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.distribution.EmpiricalDistribution;
import com.rapidminer.tools.math.distribution.NormalDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmpiricalNormalDistribution
extends NormalDistribution
implements EmpiricalDistribution,
Comparable<EmpiricalNormalDistribution> {
    private static final long serialVersionUID = -1819042904676198636L;
    protected boolean recentlyUpdated = true;
    protected double sum = 0.0;
    protected double squaredSum = 0.0;
    protected double totalWeightSum = 0.0;

    public EmpiricalNormalDistribution() {
        super(Double.NaN, Double.MIN_VALUE);
        this.updateDistributionProperties();
    }

    @Override
    public void update(double value, double weight) {
        this.sum += weight * value;
        this.squaredSum += weight * value * value;
        this.totalWeightSum += weight;
        this.recentlyUpdated = true;
    }

    @Override
    public void update(double value) {
        this.sum += value;
        this.squaredSum += value * value;
        this.totalWeightSum += 1.0;
        this.recentlyUpdated = true;
    }

    public void update(EmpiricalNormalDistribution distribution) {
        this.sum += distribution.sum;
        this.squaredSum += distribution.squaredSum;
        this.totalWeightSum += distribution.totalWeightSum;
        this.recentlyUpdated = true;
    }

    @Override
    public String getAttributeName() {
        return null;
    }

    protected void updateDistributionProperties() {
        if (this.recentlyUpdated) {
            this.mean = this.sum / this.totalWeightSum;
            this.standardDeviation = this.totalWeightSum > 1.0 ? Math.sqrt((this.squaredSum - this.sum * this.sum / this.totalWeightSum) / (this.totalWeightSum - 1.0)) : Double.MIN_VALUE;
            this.recentlyUpdated = false;
        }
    }

    @Override
    public double getProbability(double value) {
        this.updateDistributionProperties();
        return EmpiricalNormalDistribution.getProbability(this.mean, this.standardDeviation, value);
    }

    @Override
    public double getMean() {
        this.updateDistributionProperties();
        return this.mean;
    }

    @Override
    public double getStandardDeviation() {
        this.updateDistributionProperties();
        return this.standardDeviation;
    }

    @Override
    public double getVariance() {
        this.updateDistributionProperties();
        return this.standardDeviation * this.standardDeviation;
    }

    @Override
    public double getLowerBound() {
        this.updateDistributionProperties();
        return EmpiricalNormalDistribution.getLowerBound(this.mean, this.standardDeviation);
    }

    @Override
    public double getUpperBound() {
        this.updateDistributionProperties();
        return EmpiricalNormalDistribution.getUpperBound(this.mean, this.standardDeviation);
    }

    @Override
    public double getTotalWeight() {
        return this.totalWeightSum;
    }

    @Override
    public String toString() {
        this.updateDistributionProperties();
        return "Normal distribution --> mean: " + Tools.formatNumber(this.mean) + ", standard deviation: " + Tools.formatNumber(this.standardDeviation);
    }

    @Override
    public int getNumberOfParameters() {
        return 2;
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "mean";
        }
        return "standard deviation";
    }

    @Override
    public double getParameterValue(int index) {
        this.updateDistributionProperties();
        if (index == 0) {
            return this.mean;
        }
        return this.standardDeviation;
    }

    @Override
    public int compareTo(EmpiricalNormalDistribution otherDistribution) {
        return Double.compare(this.getMean(), otherDistribution.getMean());
    }
}

