/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.math.kernels.Kernel;
import com.rapidminer.tools.math.kernels.KernelCache;
import java.util.Iterator;

public class FullCache
implements KernelCache {
    private double[][] distances;

    public FullCache(ExampleSet exampleSet, Kernel kernel) {
        int size = exampleSet.size();
        this.distances = new double[size][size];
        Iterator reader = exampleSet.iterator();
        int i = 0;
        while (reader.hasNext()) {
            Example example1 = (Example)reader.next();
            double[] x1 = new double[exampleSet.getAttributes().size()];
            int x = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                x1[x++] = example1.getValue(attribute);
            }
            Iterator innerReader = exampleSet.iterator();
            int j = 0;
            while (innerReader.hasNext()) {
                double distance;
                Example example2 = (Example)innerReader.next();
                double[] x2 = new double[exampleSet.getAttributes().size()];
                x = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    x2[x++] = example2.getValue(attribute);
                }
                this.distances[i][j] = distance = kernel.calculateDistance(x1, x2);
                this.distances[j][i] = distance;
                ++j;
            }
            ++i;
        }
    }

    public double get(int i, int j) {
        return this.distances[i][j];
    }

    public void store(int i, int j, double value) {
        this.distances[i][j] = value;
    }
}

