/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.sampling;

import com.rapidminer.tools.RandomGenerator;

public class OrderedSamplingWithoutReplacement {
    private RandomGenerator randomGenerator;
    private int populationCounter;
    private int notRequiredElementsCounter;
    private double probability;
    private double randomValue;

    public OrderedSamplingWithoutReplacement(RandomGenerator randomGenerator, int populationSize, int sampleSize) {
        this.randomGenerator = randomGenerator;
        this.populationCounter = populationSize;
        this.notRequiredElementsCounter = populationSize - sampleSize;
        this.probability = 1.0;
        this.randomValue = 1.0 - randomGenerator.nextDouble();
    }

    public OrderedSamplingWithoutReplacement(RandomGenerator randomGenerator, int populationSize, double sampleRatio) {
        this(randomGenerator, populationSize, (int)Math.round((double)populationSize * sampleRatio));
    }

    public static int[] getSampledIndices(RandomGenerator randomGenerator, int populationSize, int sampleSize) {
        OrderedSamplingWithoutReplacement sampling = new OrderedSamplingWithoutReplacement(randomGenerator, populationSize, sampleSize);
        int[] result = new int[sampleSize];
        int rCounter = 0;
        int i = 0;
        while (i < populationSize) {
            if (sampling.acceptElement()) {
                result[rCounter++] = i;
            }
            ++i;
        }
        return result;
    }

    public boolean acceptElement() {
        this.probability *= (double)this.notRequiredElementsCounter / (double)this.populationCounter;
        if (this.probability > this.randomValue) {
            --this.populationCounter;
            --this.notRequiredElementsCounter;
            return false;
        }
        --this.populationCounter;
        this.probability = 1.0;
        this.randomValue = 1.0 - this.randomGenerator.nextDouble();
        return true;
    }
}

