/*
 * Decompiled with CFR 0.152.
 */
package liblinear;

import java.io.Serializable;
import java.util.Arrays;
import liblinear.Linear;
import liblinear.SolverType;

public final class Model
implements Serializable {
    private static final long serialVersionUID = -6456047576741854834L;
    public double bias;
    public int[] label;
    public int nr_class;
    public int nr_feature;
    public SolverType solverType;
    public double[] w;

    public int getNrClass() {
        return this.nr_class;
    }

    public int getNrFeature() {
        return this.nr_feature;
    }

    public int[] getLabels() {
        return Linear.copyOf(this.label, this.nr_class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model");
        sb.append(" bias=").append(this.bias);
        sb.append(" nr_class=").append(this.nr_class);
        sb.append(" nr_feature=").append(this.nr_feature);
        sb.append(" solverType=").append((Object)this.solverType);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.bias);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.label);
        result = 31 * result + this.nr_class;
        result = 31 * result + this.nr_feature;
        result = 31 * result + (this.solverType == null ? 0 : this.solverType.hashCode());
        result = 31 * result + Arrays.hashCode(this.w);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        if (Double.doubleToLongBits(this.bias) != Double.doubleToLongBits(other.bias)) {
            return false;
        }
        if (!Arrays.equals(this.label, other.label)) {
            return false;
        }
        if (this.nr_class != other.nr_class) {
            return false;
        }
        if (this.nr_feature != other.nr_feature) {
            return false;
        }
        if (this.solverType == null ? other.solverType != null : !this.solverType.equals((Object)other.solverType)) {
            return false;
        }
        return Arrays.equals(this.w, other.w);
    }
}

