/*
 * Decompiled with CFR 0.152.
 */
package liblinear;

import liblinear.Function;
import liblinear.Linear;
import org.netlib.blas.DAXPY;
import org.netlib.blas.DDOT;
import org.netlib.blas.DNRM2;
import org.netlib.blas.DSCAL;

class Tron {
    private final Function fun_obj;
    private final double eps;
    private final int max_iter;

    public Tron(Function fun_obj) {
        this(fun_obj, 0.1);
    }

    public Tron(Function fun_obj, double eps) {
        this(fun_obj, eps, 1000);
    }

    public Tron(Function fun_obj, double eps, int max_iter) {
        this.fun_obj = fun_obj;
        this.eps = eps;
        this.max_iter = max_iter;
    }

    void tron(double[] w) {
        double delta;
        double gnorm1;
        double eta0 = 1.0E-4;
        double eta1 = 0.25;
        double eta2 = 0.75;
        double sigma1 = 0.25;
        double sigma2 = 0.5;
        double sigma3 = 4.0;
        int n = this.fun_obj.get_nr_variable();
        double one = 1.0;
        boolean search = true;
        int iter = 1;
        int inc = 1;
        double[] s = new double[n];
        double[] r = new double[n];
        double[] w_new = new double[n];
        double[] g = new double[n];
        int i = 0;
        while (i < n) {
            w[i] = 0.0;
            ++i;
        }
        double f = this.fun_obj.fun(w);
        this.fun_obj.grad(w, g);
        double gnorm = gnorm1 = (delta = DNRM2.DNRM2((int)n, (double[])g, (int)inc));
        if (gnorm <= this.eps * gnorm1) {
            search = false;
        }
        iter = 1;
        while (iter <= this.max_iter && search) {
            int cg_iter = this.trcg(delta, g, s, r);
            System.arraycopy(w, 0, w_new, 0, n);
            DAXPY.DAXPY((int)n, (double)one, (double[])s, (int)inc, (double[])w_new, (int)inc);
            double gs = DDOT.DDOT((int)n, (double[])g, (int)inc, (double[])s, (int)inc);
            double prered = -0.5 * (gs - DDOT.DDOT((int)n, (double[])s, (int)inc, (double[])r, (int)inc));
            double fnew = this.fun_obj.fun(w_new);
            double actred = f - fnew;
            double snorm = DNRM2.DNRM2((int)n, (double[])s, (int)inc);
            if (iter == 1) {
                delta = Math.min(delta, snorm);
            }
            double alpha = fnew - f - gs <= 0.0 ? sigma3 : Math.max(sigma1, -0.5 * (gs / (fnew - f - gs)));
            delta = actred < eta0 * prered ? Math.min(Math.max(alpha, sigma1) * snorm, sigma2 * delta) : (actred < eta1 * prered ? Math.max(sigma1 * delta, Math.min(alpha * snorm, sigma2 * delta)) : (actred < eta2 * prered ? Math.max(sigma1 * delta, Math.min(alpha * snorm, sigma3 * delta)) : Math.max(delta, Math.min(alpha * snorm, sigma3 * delta))));
            Linear.info("iter %2d act %5.3e pre %5.3e delta %5.3e f %5.3e |g| %5.3e CG %3d" + Linear.NL, iter, actred, prered, delta, f, gnorm, cg_iter);
            if (actred > eta0 * prered) {
                ++iter;
                System.arraycopy(w_new, 0, w, 0, n);
                f = fnew;
                this.fun_obj.grad(w, g);
                gnorm = DNRM2.DNRM2((int)n, (double[])g, (int)inc);
                if (gnorm <= this.eps * gnorm1) break;
            }
            if (f < -1.0E32) {
                Linear.info("warning: f < -1.0e+32" + Linear.NL);
                break;
            }
            if (Math.abs(actred) <= 0.0 && prered <= 0.0) {
                Linear.info("warning: actred and prered <= 0" + Linear.NL);
                break;
            }
            if (!(Math.abs(actred) <= 1.0E-12 * Math.abs(f)) || !(Math.abs(prered) <= 1.0E-12 * Math.abs(f))) continue;
            Linear.info("warning: actred and prered too small" + Linear.NL);
            break;
        }
    }

    int trcg(double delta, double[] g, double[] s, double[] r) {
        int inc = 1;
        int n = this.fun_obj.get_nr_variable();
        double one = 1.0;
        double[] d = new double[n];
        double[] Hd = new double[n];
        int i = 0;
        while (i < n) {
            s[i] = 0.0;
            r[i] = -g[i];
            d[i] = r[i];
            ++i;
        }
        double cgtol = 0.1 * DNRM2.DNRM2((int)n, (double[])g, (int)inc);
        int cg_iter = 0;
        double rTr = DDOT.DDOT((int)n, (double[])r, (int)inc, (double[])r, (int)inc);
        while (!(DNRM2.DNRM2((int)n, (double[])r, (int)inc) <= cgtol)) {
            ++cg_iter;
            this.fun_obj.Hv(d, Hd);
            double alpha = rTr / DDOT.DDOT((int)n, (double[])d, (int)inc, (double[])Hd, (int)inc);
            DAXPY.DAXPY((int)n, (double)alpha, (double[])d, (int)inc, (double[])s, (int)inc);
            if (DNRM2.DNRM2((int)n, (double[])s, (int)inc) > delta) {
                Linear.info("cg reaches trust region boundary\n");
                alpha = -alpha;
                DAXPY.DAXPY((int)n, (double)alpha, (double[])d, (int)inc, (double[])s, (int)inc);
                double std = DDOT.DDOT((int)n, (double[])s, (int)inc, (double[])d, (int)inc);
                double sts = DDOT.DDOT((int)n, (double[])s, (int)inc, (double[])s, (int)inc);
                double dtd = DDOT.DDOT((int)n, (double[])d, (int)inc, (double[])d, (int)inc);
                double dsq = delta * delta;
                double rad = Math.sqrt(std * std + dtd * (dsq - sts));
                alpha = std >= 0.0 ? (dsq - sts) / (std + rad) : (rad - std) / dtd;
                DAXPY.DAXPY((int)n, (double)alpha, (double[])d, (int)inc, (double[])s, (int)inc);
                alpha = -alpha;
                DAXPY.DAXPY((int)n, (double)alpha, (double[])Hd, (int)inc, (double[])r, (int)inc);
                break;
            }
            alpha = -alpha;
            DAXPY.DAXPY((int)n, (double)alpha, (double[])Hd, (int)inc, (double[])r, (int)inc);
            double rnewTrnew = DDOT.DDOT((int)n, (double[])r, (int)inc, (double[])r, (int)inc);
            double beta = rnewTrnew / rTr;
            DSCAL.DSCAL((int)n, (double)beta, (double[])d, (int)inc);
            DAXPY.DAXPY((int)n, (double)one, (double[])r, (int)inc, (double[])d, (int)inc);
            rTr = rnewTrnew;
        }
        return cg_iter;
    }

    double norm_inf(int n, double[] x) {
        double dmax = Math.abs(x[0]);
        int i = 1;
        while (i < n) {
            if (Math.abs(x[i]) >= dmax) {
                dmax = Math.abs(x[i]);
            }
            ++i;
        }
        return dmax;
    }
}

