/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.BaselinePostprocessor;
import marytts.signalproc.adaptation.BaselinePreprocessor;
import marytts.signalproc.adaptation.BaselineTransformer;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTransformerParams;
import marytts.util.io.BasenameList;
import marytts.util.string.StringUtils;

public class WeightedCodebookTransformer
extends BaselineTransformer {
    public WeightedCodebookTransformerParams params;

    public WeightedCodebookTransformer(BaselinePreprocessor pp, BaselineFeatureExtractor fe, BaselinePostprocessor po, WeightedCodebookTransformerParams pa) {
        super(pp, fe, po, pa);
        this.params = new WeightedCodebookTransformerParams(pa);
    }

    @Override
    public boolean checkParams() throws IOException {
        return super.checkParams();
    }

    public void run() throws IOException, UnsupportedAudioFileException {
        if (this.checkParams()) {
            BaselineAdaptationSet inputSet = this.getInputSet(this.params.inputFolder);
            if (inputSet == null) {
                System.out.println("No input files found in " + this.params.inputFolder);
            } else {
                BaselineAdaptationSet outputSet = this.getOutputSet(inputSet, this.params.outputFolder);
                this.transform(inputSet, outputSet);
            }
        }
    }

    public BaselineAdaptationSet getInputSet(String inputFolder) {
        BasenameList b = new BasenameList(inputFolder, ".wav");
        BaselineAdaptationSet inputSet = new BaselineAdaptationSet(b.getListAsVector().size());
        for (int i = 0; i < inputSet.items.length; ++i) {
            inputSet.items[i].setFromWavFilename(inputFolder + b.getName(i) + ".wav");
        }
        return inputSet;
    }

    public BaselineAdaptationSet getOutputSet(BaselineAdaptationSet inputSet, String outputFolder) {
        BaselineAdaptationSet outputSet = null;
        outputFolder = StringUtils.checkLastSlash(outputFolder);
        if (inputSet != null && inputSet.items != null) {
            outputSet = new BaselineAdaptationSet(inputSet.items.length);
            for (int i = 0; i < inputSet.items.length; ++i) {
                outputSet.items[i].audioFile = outputFolder + StringUtils.getFileName(inputSet.items[i].audioFile) + "_output" + ".wav";
            }
        }
        return outputSet;
    }
}

