/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.Defaults;
import marytts.signalproc.analysis.CepstrumLPCAnalyser;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.LsfAnalyser;
import marytts.signalproc.analysis.ReflectionCoefficients;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.SignalGraph;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.window.Window;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexArray;
import marytts.util.math.ComplexNumber;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class LpcAnalyser
extends FrameBasedAnalyser {
    public static int lpOrder = 0;
    public static float preemphasisCoefficient = 0.0f;

    public LpcAnalyser(DoubleDataSource signal, int framelength, int samplingRate) {
        this(signal, Window.get(Defaults.getWindowType(), framelength), framelength, samplingRate);
    }

    public LpcAnalyser(DoubleDataSource signal, int framelength, int frameShift, int samplingRate) {
        this(signal, Window.get(Defaults.getWindowType(), framelength), frameShift, samplingRate);
    }

    public LpcAnalyser(DoubleDataSource signal, int framelength, int frameShift, int samplingRate, int order, int windowType) {
        this(signal, Window.get(windowType, framelength), frameShift, samplingRate, order);
    }

    public LpcAnalyser(DoubleDataSource signal, int framelength, int frameShift, int samplingRate, int order, int windowType, float preCoef) {
        this(signal, Window.get(windowType, framelength), frameShift, samplingRate, order, preCoef);
    }

    public LpcAnalyser(DoubleDataSource signal, Window window, int frameShift, int samplingRate) {
        this(signal, window, frameShift, samplingRate, SignalProcUtils.getLPOrder(samplingRate));
    }

    public LpcAnalyser(DoubleDataSource signal, Window window, int frameShift, int samplingRate, int order) {
        this(signal, window, frameShift, samplingRate, order, 0.0f);
    }

    public LpcAnalyser(DoubleDataSource signal, Window window, int frameShift, int samplingRate, int order, float preCoef) {
        super(signal, window, frameShift, samplingRate);
        lpOrder = order;
        preemphasisCoefficient = preCoef;
    }

    public Object analyse(double[] frame) {
        if (frame.length != this.getFrameLengthSamples()) {
            throw new IllegalArgumentException("Expected frame of length " + this.getFrameLengthSamples() + ", got " + frame.length);
        }
        return LpcAnalyser.calcLPC(frame, lpOrder, preemphasisCoefficient);
    }

    public static LpCoeffs calcLPC(double[] x, int p) {
        return LpcAnalyser.calcLPC(x, p, 0.0f);
    }

    public static LpCoeffs calcLPC(double[] x, int p, float preCoef) {
        double[] r;
        double[] autocorr;
        if (p <= 0) {
            p = Integer.getInteger("signalproc.lpcorder", 24);
        }
        if ((double)preCoef > 0.0) {
            x = SignalProcUtils.applyPreemphasis(x, preCoef);
        }
        if (MathUtils.allZeros(x)) {
            int i = 0;
            while (i < x.length) {
                int n = i++;
                x[n] = x[n] + Math.random() * 1.0E-100;
            }
        }
        if (2 * (p + 1) < (autocorr = FFT.autoCorrelateWithZeroPadding(x)).length) {
            r = ArrayUtils.subarray(autocorr, autocorr.length / 2, p + 1);
        } else {
            r = new double[p + 1];
            System.arraycopy(autocorr, autocorr.length / 2, r, 0, autocorr.length - autocorr.length / 2);
        }
        double[] coeffs = MathUtils.levinson(r, p);
        double g = Math.sqrt(MathUtils.sum(MathUtils.multiply(coeffs, r)));
        return new LpCoeffs(coeffs, g);
    }

    public static double[] calcSpecFrameLinear(double[] windowedFrame, int p) {
        return LpcAnalyser.calcSpecFrameLinear(windowedFrame, p, windowedFrame.length);
    }

    public static double[] calcSpecFrameLinear(double[] windowedFrame, int p, int fftSize) {
        return LpcAnalyser.calcSpecFrameLinear(windowedFrame, p, fftSize, null);
    }

    public static double[] calcSpecFrameLinear(double[] windowedFrame, int p, int fftSize, ComplexArray expTerm) {
        LpCoeffs c = LpcAnalyser.calcLPC(windowedFrame, p);
        if (expTerm == null || expTerm.real == null) {
            return LpcAnalyser.calcSpecLinear(c.getA(), c.getGain(), fftSize, null);
        }
        return LpcAnalyser.calcSpecLinear(c.getA(), c.getGain(), fftSize, expTerm);
    }

    public static double[] calcSpecLinearFromOneMinusA(double[] oneMinusA, float gain, int fftSize, ComplexArray expTerm) {
        double[] alpha = new double[oneMinusA.length - 1];
        for (int i = 1; i < oneMinusA.length; ++i) {
            alpha[i - 1] = -1.0 * oneMinusA[i];
        }
        return LpcAnalyser.calcSpecLinear(alpha, gain, fftSize, expTerm);
    }

    public static double[] calcSpec(double[] alpha, int fftSize) {
        return LpcAnalyser.calcSpecLinear(alpha, 1.0, fftSize, null);
    }

    public static double[] calcSpec(double[] alpha, int fftSize, ComplexArray expTerm) {
        return LpcAnalyser.calcSpecLinear(alpha, 1.0, fftSize, expTerm);
    }

    public static double[] calcSpecLinear(double[] alpha, double sqrtGain, int fftSize) {
        return LpcAnalyser.calcSpecLinear(alpha, sqrtGain, fftSize, null);
    }

    public static double[] calcSpecLinearf(float[] alpha, double sqrtGain, int fftSize, ComplexArray expTerm) {
        double[] alphaDouble = ArrayUtils.copyFloat2Double(alpha);
        return LpcAnalyser.calcSpecLinear(alphaDouble, sqrtGain, fftSize, expTerm);
    }

    public static double[] calcSpecLinear(double[] alpha, double sqrtGain, int fftSize, ComplexArray expTerm) {
        int p = alpha.length;
        int maxFreq = SignalProcUtils.halfSpectrumSize(fftSize);
        double[] vtSpectrum = new double[maxFreq];
        if (expTerm == null || expTerm.real == null || expTerm.real.length != p * maxFreq) {
            expTerm = LpcAnalyser.calcExpTerm(fftSize, p);
        }
        ComplexArray tmp = new ComplexArray(1);
        for (int w = 0; w <= maxFreq - 1; ++w) {
            tmp.real[0] = 1.0;
            tmp.imag[0] = 0.0;
            for (int i = 0; i <= p - 1; ++i) {
                int fInd = i * maxFreq + w;
                tmp.real[0] = tmp.real[0] - alpha[i] * expTerm.real[fInd];
                tmp.imag[0] = tmp.imag[0] - alpha[i] * expTerm.imag[fInd];
            }
            vtSpectrum[w] = sqrtGain / Math.sqrt(tmp.real[0] * tmp.real[0] + tmp.imag[0] * tmp.imag[0]);
        }
        return vtSpectrum;
    }

    public static double calcSpecValLinear(double[] alpha, double sqrtGain, double freqInHz, int samplingRateInHz) {
        ComplexNumber denum = new ComplexNumber(1.0f, 0.0f);
        for (int k = 1; k <= alpha.length; ++k) {
            double w = SignalProcUtils.hz2radian(freqInHz, samplingRateInHz);
            denum = MathUtils.subtractComplex(denum, alpha[k - 1] * Math.cos(w * (double)k), -1.0 * alpha[k - 1] * Math.sin(w * (double)k));
        }
        double specValLinear = sqrtGain / MathUtils.magnitudeComplex(denum);
        return specValLinear;
    }

    public static ComplexArray calcExpTerm(int fftSize, int p) {
        int maxFreq = SignalProcUtils.halfSpectrumSize(fftSize);
        ComplexArray expTerm = new ComplexArray(p * maxFreq);
        for (int w = 0; w <= maxFreq - 1; ++w) {
            double r = Math.PI * 2 / (double)fftSize * (double)w;
            for (int i = 0; i <= p - 1; ++i) {
                expTerm.real[i * maxFreq + w] = Math.cos(r * (double)(i + 1));
                expTerm.imag[i * maxFreq + w] = -1.0 * Math.sin(r * (double)(i + 1));
            }
        }
        return expTerm;
    }

    public static double[][] wavFile2lpCoeffs(String wavFile, int windowType, double windowSizeInSeconds, double frameShiftInSeconds, int lpcOrder, float preCoef) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(wavFile));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        return LpcAnalyser.signal2lpCoeffs(x, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRate, lpcOrder, preCoef);
    }

    public static LpCoeffs[] wavFile2lpCoeffsWithGain(String wavFile, int windowType, double windowSizeInSeconds, double frameShiftInSeconds, int lpcOrder, float preCoef) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(wavFile));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        return LpcAnalyser.signal2lpCoeffsWithGain(x, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRate, lpcOrder, preCoef);
    }

    public static double[][] signal2lpCoeffs(double[] x, int windowType, double windowSizeInSeconds, double frameShiftInSeconds, int samplingRateInHz, int lpcOrder, float preCoef) {
        LpCoeffs[] lpAnaResults = LpcAnalyser.signal2lpCoeffsWithGain(x, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRateInHz, lpcOrder, preCoef);
        Object lpCoeffs = null;
        if (lpAnaResults != null) {
            lpCoeffs = new double[lpAnaResults.length][];
            for (int i = 0; i < lpAnaResults.length; ++i) {
                lpCoeffs[i] = ArrayUtils.copy(lpAnaResults[i].getA());
            }
        }
        return lpCoeffs;
    }

    public static float[][] signal2lpCoeffsf(double[] x, int windowType, double windowSizeInSeconds, double frameShiftInSeconds, int samplingRateInHz, int lpcOrder, float preCoef) {
        LpCoeffs[] lpAnaResults = LpcAnalyser.signal2lpCoeffsWithGain(x, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRateInHz, lpcOrder, preCoef);
        Object lpCoeffs = null;
        if (lpAnaResults != null) {
            lpCoeffs = new float[lpAnaResults.length][];
            for (int i = 0; i < lpAnaResults.length; ++i) {
                lpCoeffs[i] = ArrayUtils.copyDouble2Float(lpAnaResults[i].getA());
            }
        }
        return lpCoeffs;
    }

    public static double[][] signal2lpCoeffs(double[] x, int windowType, float[] tAnalysisInSeconds, double windowSizeInSeconds, int samplingRateInHz, int lpcOrder, float preCoef) {
        LpCoeffs[] lpAnaResults = LpcAnalyser.signal2lpCoeffsWithGain(x, windowType, tAnalysisInSeconds, windowSizeInSeconds, samplingRateInHz, lpcOrder, preCoef);
        Object lpCoeffs = null;
        if (lpAnaResults != null) {
            lpCoeffs = new double[lpAnaResults.length][];
            for (int i = 0; i < lpAnaResults.length; ++i) {
                lpCoeffs[i] = ArrayUtils.copy(lpAnaResults[i].getA());
            }
        }
        return lpCoeffs;
    }

    public static float[][] signal2lpCoeffsf(double[] x, int windowType, float[] tAnalysisInSeconds, double windowSizeInSeconds, int samplingRateInHz, int lpcOrder, float preCoef) {
        LpCoeffs[] lpAnaResults = LpcAnalyser.signal2lpCoeffsWithGain(x, windowType, tAnalysisInSeconds, windowSizeInSeconds, samplingRateInHz, lpcOrder, preCoef);
        Object lpCoeffs = null;
        if (lpAnaResults != null) {
            lpCoeffs = new float[lpAnaResults.length][];
            for (int i = 0; i < lpAnaResults.length; ++i) {
                lpCoeffs[i] = ArrayUtils.copyDouble2Float(lpAnaResults[i].getA());
            }
        }
        return lpCoeffs;
    }

    public static LpCoeffs[] signal2lpCoeffsWithGain(double[] x, int windowType, double windowSizeInSeconds, double frameShiftInSeconds, int samplingRateInHz, int lpcOrder, float preCoef) {
        int ws = SignalProcUtils.time2sample(windowSizeInSeconds, samplingRateInHz);
        int ss = SignalProcUtils.time2sample(frameShiftInSeconds, samplingRateInHz);
        int numfrm = SignalProcUtils.getTotalFrames(SignalProcUtils.sample2time(x.length, samplingRateInHz), windowSizeInSeconds, frameShiftInSeconds);
        float[] tAnalysisInSeconds = SignalProcUtils.getAnalysisTimes(numfrm, windowSizeInSeconds, frameShiftInSeconds);
        return LpcAnalyser.signal2lpCoeffsWithGain(x, windowType, tAnalysisInSeconds, windowSizeInSeconds, samplingRateInHz, lpcOrder, preCoef);
    }

    public static LpCoeffs[] signal2lpCoeffsWithGain(double[] x, int windowType, float[] tAnalysisInSeconds, double windowSizeInSeconds, int samplingRateInHz, int lpcOrder, float preCoef) {
        int ws = SignalProcUtils.time2sample(windowSizeInSeconds, samplingRateInHz);
        int numfrm = tAnalysisInSeconds.length;
        LpCoeffs[] lpCoeffs = null;
        if (numfrm > 0) {
            Window w = SignalProcUtils.getWindow(windowType, ws);
            double[] frm = new double[ws];
            lpCoeffs = new LpCoeffs[numfrm];
            double[] xPreemp = SignalProcUtils.applyPreemphasis(x, preCoef);
            for (int i = 0; i < numfrm; ++i) {
                Arrays.fill(frm, 0.0);
                int frmStartInd = SignalProcUtils.time2sample((double)tAnalysisInSeconds[i] - 0.5 * windowSizeInSeconds, samplingRateInHz);
                frmStartInd = MathUtils.CheckLimits(frmStartInd, 0, xPreemp.length - 1);
                System.arraycopy(xPreemp, frmStartInd, frm, 0, Math.min(ws, xPreemp.length - frmStartInd));
                lpCoeffs[i] = LpcAnalyser.calcLPC(frm, lpcOrder);
            }
        }
        return lpCoeffs;
    }

    public static void main(String[] args) throws Exception {
        int i;
        int p;
        int windowSize = Defaults.getWindowSize();
        int windowType = Defaults.getWindowType();
        int fftSize = Defaults.getFFTSize();
        int frameShift = Defaults.getFrameShift();
        int pre = p = Integer.getInteger("signalproc.lpcorder", 24).intValue();
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] signalData = signal.getAllData();
        int position = 6000;
        Window w = Window.get(windowType, windowSize);
        double[] sliceToAnalyse = w.apply(signalData, position);
        LpCoeffs lpc = LpcAnalyser.calcLPC(sliceToAnalyse, p);
        double g_db = 2.0 * MathUtils.db(lpc.getGain());
        double[] signalPowerSpectrum = FFT.computeLogPowerSpectrum(sliceToAnalyse);
        double[] a = lpc.getOneMinusA();
        double[] fftA = new double[fftSize];
        System.arraycopy(a, 0, fftA, 0, a.length);
        double[] lpcPowerSpectrum = FFT.computeLogPowerSpectrum(fftA);
        double offset = 0.0;
        for (i = 0; i < lpcPowerSpectrum.length; ++i) {
            lpcPowerSpectrum[i] = -lpcPowerSpectrum[i] + offset + g_db;
        }
        i = 0;
        while (i < signalPowerSpectrum.length) {
            int n = i++;
            signalPowerSpectrum[n] = signalPowerSpectrum[n] + offset;
        }
        double[] lsp = LsfAnalyser.lpc2lsf(a, 1);
        System.out.println("Line spectral frequencies:");
        for (int i2 = 0; i2 < lsp.length; ++i2) {
            System.out.println(i2 + ": " + lsp[i2] + " = " + lsp[i2] / (Math.PI * 2) * (double)samplingRate);
        }
        double deltaF = (double)samplingRate / (double)fftSize;
        FunctionGraph signalSpectrumGraph = new FunctionGraph(0.0, deltaF, signalPowerSpectrum);
        signalSpectrumGraph.showInJFrame("signal spectrum", true, true);
        FunctionGraph lpcSpectrumGraph = new FunctionGraph(0.0, deltaF, lpcPowerSpectrum);
        lpcSpectrumGraph.showInJFrame("lpc spectrum", true, true);
        FIRFilter whiteningFilter = new FIRFilter(a);
        double[] testSlice = new double[fftSize + p];
        System.arraycopy(signalData, position - p, testSlice, 0, testSlice.length);
        double[] residuum = whiteningFilter.apply(testSlice);
        double[] usableSignal = ArrayUtils.subarray(testSlice, p, fftSize);
        double[] usableResiduum = ArrayUtils.subarray(residuum, p, fftSize);
        SignalGraph signalGraph = new SignalGraph(usableSignal, samplingRate);
        signalGraph.showInJFrame("signal", true, true);
        SignalGraph residuumGraph = new SignalGraph(usableResiduum, samplingRate);
        residuumGraph.showInJFrame("residual", true, true);
        double predictionGain = MathUtils.db(MathUtils.sum(MathUtils.multiply(usableSignal, usableSignal)) / MathUtils.sum(MathUtils.multiply(usableResiduum, usableResiduum)));
        System.out.println("Prediction gain: " + predictionGain + " dB");
    }

    public static class LpCoeffs {
        protected double[] oneMinusA = null;
        protected double gain = 1.0;
        protected double[] lsf = null;
        protected double[] lpcc = null;
        protected double[] lprefc = null;

        public LpCoeffs(double[] oneMinusA, double gain) {
            this.oneMinusA = oneMinusA;
            this.gain = gain;
            this.lsf = null;
            this.lpcc = null;
            this.lprefc = null;
        }

        public LpCoeffs(LpCoeffs existing) {
            this.oneMinusA = ArrayUtils.copy(existing.oneMinusA);
            this.gain = existing.gain;
            this.lsf = ArrayUtils.copy(existing.lsf);
            this.lpcc = ArrayUtils.copy(existing.lpcc);
            this.lprefc = ArrayUtils.copy(existing.lprefc);
        }

        public double[] getOneMinusA() {
            return (double[])this.oneMinusA.clone();
        }

        public void setOneMinusA(double[] oneMinusA) {
            this.oneMinusA = (double[])oneMinusA.clone();
            this.lsf = null;
            this.lpcc = null;
            this.lprefc = null;
        }

        public final double getOneMinusA(int i) {
            return this.oneMinusA[i];
        }

        public double getA(int i) {
            return -this.oneMinusA[i + 1];
        }

        public void setOneMinusA(int i, double value) {
            this.oneMinusA[i] = value;
            this.lsf = null;
            this.lpcc = null;
            this.lprefc = null;
        }

        public void setA(int i, double value) {
            this.oneMinusA[i + 1] = -value;
            this.lsf = null;
            this.lpcc = null;
            this.lprefc = null;
        }

        public double getGain() {
            return this.gain;
        }

        public void setGain(double gain) {
            this.gain = gain;
            this.lpcc = null;
        }

        public int getOrder() {
            return this.oneMinusA.length - 1;
        }

        public double[] getA() {
            double[] a = new double[this.getOrder()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = -this.oneMinusA[i + 1];
            }
            return a;
        }

        public void setA(double[] a) {
            this.oneMinusA = new double[a.length + 1];
            this.oneMinusA[0] = 1.0;
            for (int i = 0; i < a.length; ++i) {
                this.oneMinusA[i + 1] = -a[i];
            }
            this.lsf = null;
            this.lpcc = null;
            this.lprefc = null;
        }

        public double[] getLSF() {
            if (this.lsf == null) {
                this.lsf = LsfAnalyser.lpc2lsf(this.oneMinusA, 1);
            }
            return (double[])this.lsf.clone();
        }

        public void setLSF(double[] someLsf) {
            this.lsf = (double[])someLsf.clone();
            this.oneMinusA = LsfAnalyser.lsf2lpc(this.lsf);
            this.lpcc = null;
            this.lprefc = null;
        }

        public double[] getLPCC(int cepstrumOrder) {
            if (this.lpcc == null) {
                this.lpcc = CepstrumLPCAnalyser.lpc2lpcc(this.oneMinusA, this.gain, cepstrumOrder);
            }
            return (double[])this.lpcc.clone();
        }

        public void setLPCC(double[] someLpcc, int LPCOrder) {
            this.lpcc = (double[])someLpcc.clone();
            this.oneMinusA = CepstrumLPCAnalyser.lpcc2lpc(this.lpcc, LPCOrder);
            this.gain = Math.exp(this.lpcc[0]);
            this.lsf = null;
            this.lprefc = null;
        }

        public double[] getLPRefc() {
            if (this.lprefc == null) {
                this.lprefc = ReflectionCoefficients.lpc2lprefc(this.oneMinusA);
            }
            return (double[])this.lprefc.clone();
        }

        public void setLPRefc(double[] someLprefc) {
            this.lprefc = (double[])someLprefc.clone();
            this.oneMinusA = ReflectionCoefficients.lprefc2lpc(this.lprefc);
            this.lsf = null;
            this.lpcc = null;
        }

        public boolean isStable() {
            if (this.lprefc == null) {
                this.lprefc = ReflectionCoefficients.lpc2lprefc(this.oneMinusA);
            }
            for (int i = 0; i < this.lprefc.length; ++i) {
                if (!(this.lprefc[i] > 1.0) && !(this.lprefc[i] < -1.0)) continue;
                return false;
            }
            return true;
        }
    }
}

