/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.util.io.LEDataInputStream;
import marytts.util.io.LEDataOutputStream;
import marytts.util.io.MaryRandomAccessFile;

public class PitchFileHeader {
    public double windowSizeInSeconds;
    public double skipSizeInSeconds;
    public int fs;
    public int numfrm;
    public double voicingThreshold;
    public static double DEFAULT_VOICING_THRESHOLD = 0.35;
    public double minimumF0;
    public double maximumF0;
    public static double DEFAULT_MINIMUM_F0 = 50.0;
    public static double DEFAULT_MAXIMUM_F0 = 500.0;
    public boolean isDoublingCheck;
    public boolean isHalvingCheck;
    public static boolean DEFAULT_DOUBLING_CHECK = true;
    public static boolean DEFAULT_HALVING_CHECK = true;
    public double centerClippingRatio;
    public static double DEFAULT_CENTER_CLIPPING_RATIO = 0.5;
    public double cutOff1;
    public double cutOff2;
    public static double DEFAULT_CUTOFF1 = DEFAULT_MINIMUM_F0 - 20.0;
    public static double DEFAULT_CUTOFF2 = DEFAULT_MAXIMUM_F0 + 200.0;

    public PitchFileHeader() {
        this.windowSizeInSeconds = 0.04;
        this.skipSizeInSeconds = 0.005;
        this.fs = 0;
        this.numfrm = 0;
        this.voicingThreshold = DEFAULT_VOICING_THRESHOLD;
        this.minimumF0 = DEFAULT_MINIMUM_F0;
        this.maximumF0 = DEFAULT_MAXIMUM_F0;
        this.isDoublingCheck = DEFAULT_DOUBLING_CHECK;
        this.isHalvingCheck = DEFAULT_HALVING_CHECK;
        this.centerClippingRatio = DEFAULT_CENTER_CLIPPING_RATIO;
        this.cutOff1 = DEFAULT_CUTOFF1;
        this.cutOff2 = DEFAULT_CUTOFF2;
    }

    public PitchFileHeader(PitchFileHeader existingHeader) {
        this.windowSizeInSeconds = existingHeader.windowSizeInSeconds;
        this.skipSizeInSeconds = existingHeader.skipSizeInSeconds;
        this.fs = existingHeader.fs;
        this.numfrm = existingHeader.numfrm;
        this.voicingThreshold = existingHeader.voicingThreshold;
        this.minimumF0 = existingHeader.minimumF0;
        this.maximumF0 = existingHeader.maximumF0;
        this.isDoublingCheck = existingHeader.isDoublingCheck;
        this.isHalvingCheck = existingHeader.isHalvingCheck;
        this.centerClippingRatio = existingHeader.centerClippingRatio;
        this.cutOff1 = existingHeader.cutOff1;
        this.cutOff2 = existingHeader.cutOff2;
    }

    public void readPitchHeader(MaryRandomAccessFile stream) throws IOException {
        this.readPitchHeader(stream, true);
    }

    public void readPitchHeader(MaryRandomAccessFile stream, boolean bLeaveStreamOpen) throws IOException {
        if (stream != null) {
            this.windowSizeInSeconds = stream.readDouble();
            this.skipSizeInSeconds = stream.readDouble();
            this.fs = stream.readInt();
            this.numfrm = stream.readInt();
            this.voicingThreshold = stream.readDouble();
            this.minimumF0 = stream.readDouble();
            this.maximumF0 = stream.readDouble();
            this.isDoublingCheck = stream.readBoolean();
            this.isHalvingCheck = stream.readBoolean();
            this.centerClippingRatio = stream.readDouble();
            this.cutOff1 = stream.readDouble();
            this.cutOff2 = stream.readDouble();
            if (!bLeaveStreamOpen) {
                stream.close();
                stream = null;
            }
        }
    }

    public void readPitchHeaderOld(LEDataInputStream stream) throws IOException {
        this.readPitchHeaderOld(stream, true);
    }

    public void readPitchHeaderOld(LEDataInputStream stream, boolean bLeaveStreamOpen) throws IOException {
        if (stream != null) {
            this.windowSizeInSeconds = stream.readFloat();
            this.skipSizeInSeconds = stream.readFloat();
            this.fs = stream.readInt();
            this.numfrm = stream.readInt();
            this.voicingThreshold = DEFAULT_VOICING_THRESHOLD;
            this.minimumF0 = DEFAULT_MINIMUM_F0;
            this.maximumF0 = DEFAULT_MAXIMUM_F0;
            this.isDoublingCheck = DEFAULT_DOUBLING_CHECK;
            this.isHalvingCheck = DEFAULT_HALVING_CHECK;
            this.centerClippingRatio = DEFAULT_CENTER_CLIPPING_RATIO;
            this.cutOff1 = DEFAULT_CUTOFF1;
            this.cutOff2 = DEFAULT_CUTOFF2;
            this.windowSizeInSeconds /= (double)this.fs;
            this.skipSizeInSeconds /= (double)this.fs;
            if (!bLeaveStreamOpen) {
                stream.close();
                stream = null;
            }
        }
    }

    public void writePitchHeader(String pitchFile) throws IOException {
        this.writePitchHeader(pitchFile, false);
    }

    public MaryRandomAccessFile writePitchHeader(String pitchFile, boolean bLeaveStreamOpen) throws IOException {
        MaryRandomAccessFile stream = new MaryRandomAccessFile(pitchFile, "rw");
        if (stream != null) {
            this.writePitchHeader(stream);
            if (!bLeaveStreamOpen) {
                stream.close();
                stream = null;
            }
        }
        return stream;
    }

    public void writePitchHeader(MaryRandomAccessFile ler) throws IOException {
        ler.writeDouble(this.windowSizeInSeconds);
        ler.writeDouble(this.skipSizeInSeconds);
        ler.writeInt(this.fs);
        ler.writeInt(this.numfrm);
        ler.writeDouble(this.voicingThreshold);
        ler.writeDouble(this.minimumF0);
        ler.writeDouble(this.maximumF0);
        ler.writeBoolean(this.isDoublingCheck);
        ler.writeBoolean(this.isHalvingCheck);
        ler.writeDouble(this.centerClippingRatio);
        ler.writeDouble(this.cutOff1);
        ler.writeDouble(this.cutOff2);
    }

    public void writePitchHeaderOld(String pitchFile) throws IOException {
        this.writePitchHeaderOld(pitchFile, false);
    }

    public LEDataOutputStream writePitchHeaderOld(String pitchFile, boolean bLeaveStreamOpen) throws IOException {
        LEDataOutputStream stream = new LEDataOutputStream(pitchFile);
        if (stream != null) {
            this.writePitchHeaderOld(stream);
            if (!bLeaveStreamOpen) {
                stream.close();
                stream = null;
            }
        }
        return stream;
    }

    public void writePitchHeaderOld(LEDataOutputStream ler) throws IOException {
        ler.writeDouble(this.windowSizeInSeconds);
        ler.writeDouble(this.skipSizeInSeconds);
        ler.writeInt(this.fs);
        ler.writeInt(this.numfrm);
    }
}

