/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.FrequencyDomainProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class VocalTractScalingSimpleProcessor
extends FrequencyDomainProcessor {
    private double[] vscales;
    private int maxFreq;
    private double[] realOut;
    private double[] imagOut;

    public void SetVScales(double[] vscalesIn) {
        if (vscalesIn.length > 0) {
            this.vscales = MathUtils.modifySize(vscalesIn, this.maxFreq);
            for (int i = 0; i < this.maxFreq; ++i) {
                if (!(this.vscales[i] < 0.05)) continue;
                this.vscales[i] = 0.05;
            }
        } else {
            this.vscales = null;
        }
    }

    public VocalTractScalingSimpleProcessor(int fftSize, double[] vscalesIn) {
        super(fftSize);
        this.maxFreq = fftSize / 2 + 1;
        this.SetVScales(vscalesIn);
        this.realOut = new double[this.maxFreq];
        this.imagOut = new double[this.maxFreq];
    }

    @Override
    protected void process(double[] real, double[] imag) {
        if (this.vscales != null) {
            int i;
            for (i = 1; i <= this.maxFreq; ++i) {
                int wInd = (int)Math.floor((double)i / this.vscales[i - 1] + 0.5);
                if (wInd < 1) {
                    wInd = 1;
                }
                if (wInd > this.maxFreq) {
                    wInd = this.maxFreq;
                }
                this.realOut[i - 1] = real[wInd - 1];
                this.imagOut[i - 1] = imag[wInd - 1];
            }
            System.arraycopy(this.realOut, 0, real, 0, this.maxFreq);
            System.arraycopy(this.imagOut, 0, imag, 0, this.maxFreq);
            for (i = this.maxFreq + 1; i <= real.length; ++i) {
                real[i - 1] = real[2 * this.maxFreq - i - 1];
                imag[i - 1] = imag[2 * this.maxFreq - i - 1];
            }
        }
    }

    public static void main(String[] args) throws Exception {
        double[] vscales = new double[]{2.0};
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, 1024, samplingRate, new VocalTractScalingSimpleProcessor(1024, vscales));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = args[i].substring(0, args[i].length() - 4) + "_vocalTractSimpleScaled.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        }
    }
}

