/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis.hybrid;

import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.SinusoidalTrack;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.signalproc.sinusoidal.TrackGenerator;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class HarmonicsToTrackConverter {
    public static SinusoidalTracks convert(HntmSpeechSignal hntmSignal, HntmAnalyzerParams analysisParams) {
        int i;
        int numFrames = hntmSignal.frames.length;
        float deltaInRadians = SignalProcUtils.hz2radian(50.0f, hntmSignal.samplingRateInHz);
        SinusoidalTracks tr = null;
        if (numFrames > 0) {
            boolean[] bSinAssigneds = null;
            float[] currentCeps = null;
            for (i = 0; i < numFrames; ++i) {
                Sinusoid zeroAmpSin;
                int j;
                if (hntmSignal.frames[i].h.complexAmps != null && hntmSignal.frames[i].h.complexAmps.length > 0) {
                    Sinusoid sin;
                    float amp;
                    if (!analysisParams.useHarmonicAmplitudesDirectly) {
                        currentCeps = hntmSignal.frames[i].h.getCeps(hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz, analysisParams);
                    }
                    if (tr == null) {
                        tr = new SinusoidalTracks(hntmSignal.frames[i].h.complexAmps.length, hntmSignal.samplingRateInHz);
                        tr.setSysAmpsAndTimes(hntmSignal, analysisParams);
                        for (j = 0; j < hntmSignal.frames[i].h.complexAmps.length; ++j) {
                            zeroAmpSin = new Sinusoid(0.0f, SignalProcUtils.hz2radian((float)j * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz), 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                            tr.add(new SinusoidalTrack(hntmSignal.frames[i].tAnalysisInSeconds - TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.TURNED_ON));
                            amp = 0.0f;
                            if (!analysisParams.useHarmonicAmplitudesDirectly) {
                                if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                    amp = (float)RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)j * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz);
                                } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                    amp = (float)RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)j * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz);
                                }
                            } else {
                                amp = (float)MathUtils.magnitudeComplex(hntmSignal.frames[i].h.complexAmps[j]);
                            }
                            sin = new Sinusoid(amp, SignalProcUtils.hz2radian((float)j * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz), MathUtils.phaseInRadiansFloat(hntmSignal.frames[i].h.complexAmps[j]), i);
                            tr.tracks[tr.currentIndex].add(hntmSignal.frames[i].tAnalysisInSeconds, sin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.ACTIVE);
                        }
                    } else {
                        int k;
                        for (j = 0; j < tr.currentIndex + 1; ++j) {
                            if (tr.tracks[j] == null) continue;
                            tr.tracks[j].resetCandidate();
                        }
                        bSinAssigneds = new boolean[hntmSignal.frames[i].h.complexAmps.length];
                        for (k = 0; k < hntmSignal.frames[i].h.complexAmps.length; ++k) {
                            float minDist = Math.abs(SignalProcUtils.hz2radian((float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz) - tr.tracks[0].freqs[tr.tracks[0].currentIndex]);
                            int trackInd = minDist < deltaInRadians ? 0 : -1;
                            for (j = 1; j < tr.currentIndex + 1; ++j) {
                                float tmpDist = Math.abs(SignalProcUtils.hz2radian((float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz) - tr.tracks[j].freqs[tr.tracks[j].currentIndex]);
                                if (!(tmpDist < deltaInRadians) || trackInd != -1 && !(tmpDist < minDist)) continue;
                                minDist = tmpDist;
                                trackInd = j;
                            }
                            if (trackInd > -1) {
                                if (tr.tracks[trackInd].newCandidateInd > -1) {
                                    bSinAssigneds[tr.tracks[trackInd].newCandidateInd] = false;
                                }
                                amp = 0.0f;
                                if (!analysisParams.useHarmonicAmplitudesDirectly) {
                                    if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                        amp = (float)RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz);
                                    } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                        amp = (float)RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz);
                                    }
                                } else {
                                    amp = (float)MathUtils.magnitudeComplex(hntmSignal.frames[i].h.complexAmps[k]);
                                }
                                sin = new Sinusoid(amp, SignalProcUtils.hz2radian((float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz), MathUtils.phaseInRadiansFloat(hntmSignal.frames[i].h.complexAmps[k]), i);
                                tr.tracks[trackInd].newCandidate = new Sinusoid(sin);
                                tr.tracks[trackInd].newCandidateInd = k;
                                bSinAssigneds[k] = true;
                                continue;
                            }
                            bSinAssigneds[k] = false;
                        }
                        for (j = 0; j < tr.currentIndex + 1; ++j) {
                            if (tr.tracks[j].newCandidate != null) {
                                Sinusoid tmpSin = new Sinusoid(tr.tracks[j].newCandidate);
                                if (tr.tracks[j].states[tr.tracks[j].currentIndex] != SinusoidalTrack.ACTIVE) {
                                    zeroAmpSin = new Sinusoid(0.0f, tr.tracks[j].freqs[tr.tracks[j].totalSins - 1], 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                                    tr.tracks[j].add(hntmSignal.frames[i].tAnalysisInSeconds - TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.TURNED_ON);
                                }
                                tr.tracks[j].add(hntmSignal.frames[i].tAnalysisInSeconds, tmpSin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.ACTIVE);
                                continue;
                            }
                            if (tr.tracks[j].states[tr.tracks[j].currentIndex] == SinusoidalTrack.TURNED_OFF) continue;
                            zeroAmpSin = new Sinusoid(0.0f, tr.tracks[j].freqs[tr.tracks[j].totalSins - 1], 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                            tr.tracks[j].add(hntmSignal.frames[i].tAnalysisInSeconds + TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.TURNED_OFF);
                        }
                        for (k = 0; k < bSinAssigneds.length; ++k) {
                            if (bSinAssigneds[k]) continue;
                            zeroAmpSin = new Sinusoid(0.0f, SignalProcUtils.hz2radian((float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz), 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                            tr.add(new SinusoidalTrack(hntmSignal.frames[i].tAnalysisInSeconds - TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.TURNED_ON));
                            amp = 0.0f;
                            if (!analysisParams.useHarmonicAmplitudesDirectly) {
                                if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                    amp = (float)RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz);
                                } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                    amp = (float)RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz);
                                }
                            } else {
                                amp = (float)MathUtils.magnitudeComplex(hntmSignal.frames[i].h.complexAmps[k]);
                            }
                            sin = new Sinusoid(amp, SignalProcUtils.hz2radian((float)k * hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz), MathUtils.phaseInRadiansFloat(hntmSignal.frames[i].h.complexAmps[k]), i);
                            tr.tracks[tr.currentIndex].add(hntmSignal.frames[i].tAnalysisInSeconds, sin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.ACTIVE);
                        }
                    }
                    System.out.println("Track generation using frame " + String.valueOf(i + 1) + " of " + String.valueOf(numFrames));
                }
                if (i != numFrames - 1) continue;
                for (j = 0; j < tr.currentIndex + 1; ++j) {
                    if (!(Math.abs(hntmSignal.frames[i].tAnalysisInSeconds - tr.tracks[j].times[tr.tracks[j].totalSins - 1]) < TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS) || tr.tracks[j].states[tr.tracks[j].currentIndex] != SinusoidalTrack.ACTIVE) continue;
                    zeroAmpSin = new Sinusoid(0.0f, tr.tracks[j].freqs[tr.tracks[j].totalSins - 1], 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                    tr.tracks[j].add(hntmSignal.frames[i].tAnalysisInSeconds + TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, hntmSignal.frames[i].maximumFrequencyOfVoicingInHz, SinusoidalTrack.TURNED_OFF);
                }
            }
        }
        for (i = 0; i <= tr.currentIndex; ++i) {
            tr.tracks[i].correctTrack();
        }
        tr.setOriginalDurationManual(hntmSignal.originalDurationInSeconds);
        SinusoidalTracks trOut = new SinusoidalTracks(tr, 0, tr.currentIndex);
        trOut = TrackGenerator.postProcess(trOut);
        return trOut;
    }
}

