/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.util.data.Datagram;

public class HnmDatagram
extends Datagram {
    public HntmSpeechFrame frame;

    public HnmDatagram(long setDuration, HntmSpeechFrame frame) {
        super(setDuration);
        this.frame = new HntmSpeechFrame(frame);
    }

    public HnmDatagram(RandomAccessFile raf, int noiseModel) throws IOException, EOFException {
        super(raf.readLong());
        int len = raf.readInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        if (len < 12) {
            throw new IOException("Hnm with waveform noise datagram too short (len=" + len + "): cannot be shorter than the space needed for first three Hnm parameters (4*3)");
        }
        byte[] buf = new byte[len];
        raf.readFully(buf);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        this.frame = new HntmSpeechFrame(dis, noiseModel);
    }

    public HnmDatagram(ByteBuffer bb, int noiseModel) throws IOException, EOFException {
        super(bb.getLong());
        int len = bb.getInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        if (len < 12) {
            throw new IOException("Hnm with waveform noise datagram too short (len=" + len + "): cannot be shorter than the space needed for first three Hnm parameters (4*3)");
        }
        this.frame = new HntmSpeechFrame(bb, noiseModel);
    }

    @Override
    public int getLength() {
        return this.frame.getLength();
    }

    public HntmSpeechFrame getFrame() {
        return this.frame;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.duration);
        out.writeInt(this.getLength());
        this.frame.write(out);
    }

    public boolean equals(Datagram other) {
        if (!(other instanceof HnmDatagram)) {
            return false;
        }
        HnmDatagram otherHnm = (HnmDatagram)other;
        if (this.duration != otherHnm.duration) {
            return false;
        }
        return this.frame.equals(otherHnm.frame);
    }
}

