/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.util.io.General;

public class ESTTrackReader {
    private int numFrames;
    private int numChannels;
    private float[] times;
    private float[][] frames;
    private boolean isBigEndian = false;
    private boolean isBinary = false;
    private int timeIdx = 0;

    public ESTTrackReader(DataInputStream dis) {
        this.loadHeaderAndData(dis);
    }

    public ESTTrackReader(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            DataInputStream dis = new DataInputStream(fis);
            this.loadHeaderAndData(dis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new Error("EST track file [" + fileName + "] was not found.");
        }
        catch (SecurityException e) {
            throw new Error("You do not have read access to the file [" + fileName + "].");
        }
        catch (IOException e) {
            throw new Error("IO Exception caught when closing file [" + fileName + "]: " + e.getMessage());
        }
    }

    private void loadHeaderAndData(DataInputStream dis) {
        try {
            if (!General.readWord(dis).equals("EST_File") || !General.readWord(dis).equals("Track")) {
                throw new Error("The given data input stream is not an EST Track file.");
            }
            String token = General.readWord(dis);
            while (!token.equals("EST_Header_End")) {
                if (token.equals("DataType")) {
                    this.isBinary = General.readWord(dis).equals("binary");
                } else if (token.equals("ByteOrder")) {
                    this.isBigEndian = General.readWord(dis).equals("10");
                } else if (token.equals("NumFrames")) {
                    this.numFrames = Integer.parseInt(General.readWord(dis));
                } else if (token.equals("NumChannels")) {
                    this.numChannels = Integer.parseInt(General.readWord(dis));
                }
                token = General.readWord(dis);
            }
            this.times = new float[this.numFrames];
            this.frames = new float[this.numFrames][this.numChannels];
            if (this.isBinary) {
                this.loadBinaryData(dis);
            } else {
                this.loadTextData(dis);
            }
        }
        catch (IOException ioe) {
            throw new Error("IO Exception while parsing EST Track file: " + ioe.getMessage());
        }
    }

    private void loadTextData(DataInputStream dis) throws IOException {
        for (int f = 0; f < this.numFrames; ++f) {
            this.times[f] = Float.parseFloat(General.readWord(dis));
            General.readWord(dis);
            for (int c = 0; c < this.numChannels; ++c) {
                this.frames[f][c] = Float.parseFloat(General.readWord(dis));
            }
        }
    }

    private void loadBinaryData(DataInputStream dis) throws IOException {
        for (int f = 0; f < this.numFrames; ++f) {
            this.times[f] = General.readFloat(dis, this.isBigEndian);
            General.readFloat(dis, this.isBigEndian);
            for (int c = 0; c < this.numChannels; ++c) {
                this.frames[f][c] = General.readFloat(dis, this.isBigEndian);
            }
        }
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public float[] getTimes() {
        return this.times;
    }

    public float[][] getFrames() {
        return this.frames;
    }

    public float getTime(int index) {
        return this.times[index];
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public float getClosestTime(double seconds) {
        if (seconds < 0.0) {
            return 0.0f;
        }
        if (seconds > (double)this.getTimeSpan()) {
            return this.getTimeSpan();
        }
        if ((double)this.getTime(this.timeIdx) > seconds) {
            this.timeIdx = 0;
        }
        float t1 = 0.0f;
        float t2 = this.getTime(this.timeIdx);
        while ((double)t2 < seconds && this.timeIdx < this.numFrames) {
            ++this.timeIdx;
            t1 = t2;
            t2 = this.getTime(this.timeIdx);
        }
        return seconds - (double)t1 < (double)t2 - seconds ? t1 : t2;
    }

    public float getTimeSpan() {
        return this.times[this.numFrames - 1];
    }

    public float[] getFrame(int i) {
        return this.frames[i];
    }

    public float getFrameEntry(int i, int j) {
        return this.frames[i][j];
    }

    public float[] getMinMax() {
        float min;
        float max = min = this.getFrameEntry(0, 0);
        for (int f = 0; f < this.numFrames; ++f) {
            for (int c = 0; c < this.numChannels; ++c) {
                float val = this.frames[f][c];
                if (val < min) {
                    min = val;
                }
                if (!(val > max)) continue;
                max = val;
            }
        }
        float[] result = new float[]{min, max};
        return result;
    }

    public float[] getMinMaxNo1st() {
        float min;
        float max = min = this.getFrameEntry(0, 1);
        for (int f = 0; f < this.numFrames; ++f) {
            for (int c = 1; c < this.numChannels; ++c) {
                float val = this.frames[f][c];
                if (val < min) {
                    min = val;
                }
                if (!(val > max)) continue;
                max = val;
            }
        }
        float[] result = new float[]{min, max};
        return result;
    }
}

