/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.util.data.DoubleDataSource;

public class DDSAudioInputStream
extends AudioInputStream {
    public static final int MAX_AMPLITUDE = Short.MAX_VALUE;
    protected DoubleDataSource source;
    protected double[] sampleBuf;
    protected static final int SAMPLEBUFFERSIZE = 8192;

    public DDSAudioInputStream(DoubleDataSource source, AudioFormat format) {
        super(new ByteArrayInputStream(new byte[0]), format, -1L);
        if (format.getChannels() > 1) {
            throw new IllegalArgumentException("Can only produce mono audio");
        }
        if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("Can only produce PCM_SIGNED or PCM_UNSIGNED audio");
        }
        int bitsPerSample = format.getSampleSizeInBits();
        if (bitsPerSample != 8 && bitsPerSample != 16 && bitsPerSample != 24) {
            throw new IllegalArgumentException("Can deal with sample size 8 or 16 or 24, but not " + bitsPerSample);
        }
        this.source = source;
        this.sampleBuf = new double[8192];
        assert (this.frameSize == bitsPerSample / 8);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nSamples = len / this.frameSize;
        int totalRead = 0;
        int currentPos = off;
        do {
            byte hibyte;
            int sample;
            int i;
            boolean bigEndian;
            int toRead;
            if ((toRead = nSamples - totalRead) > this.sampleBuf.length) {
                toRead = this.sampleBuf.length;
            }
            int nRead = this.source.getData(this.sampleBuf, 0, toRead);
            if (this.frameSize == 1) {
                int i2 = 0;
                while (i2 < nRead) {
                    int sample2 = (int)Math.round(this.sampleBuf[i2] * 127.0);
                    b[currentPos] = (byte)(sample2 >> 8 & 0xFF);
                    ++i2;
                    ++currentPos;
                }
            } else if (this.frameSize == 2) {
                bigEndian = this.format.isBigEndian();
                i = 0;
                while (i < nRead) {
                    sample = (int)Math.round(this.sampleBuf[i] * 32767.0);
                    if (sample > Short.MAX_VALUE || sample < -32767) {
                        System.err.println("Warning: signal amplitude out of range: " + sample);
                    }
                    hibyte = (byte)(sample >> 8);
                    byte lobyte = (byte)(sample & 0xFF);
                    if (!bigEndian) {
                        b[currentPos] = lobyte;
                        b[currentPos + 1] = hibyte;
                    } else {
                        b[currentPos] = hibyte;
                        b[currentPos + 1] = lobyte;
                    }
                    ++i;
                    currentPos += 2;
                }
            } else {
                bigEndian = this.format.isBigEndian();
                i = 0;
                while (i < nRead) {
                    sample = (int)Math.round(this.sampleBuf[i] * 8388605.0);
                    hibyte = (byte)(sample >> 16);
                    byte midbyte = (byte)(sample >> 8 & 0xFF);
                    byte lobyte = (byte)(sample & 0xFF);
                    if (!bigEndian) {
                        b[currentPos] = lobyte;
                        b[currentPos + 1] = midbyte;
                        b[currentPos + 2] = hibyte;
                    } else {
                        b[currentPos] = hibyte;
                        b[currentPos + 1] = midbyte;
                        b[currentPos + 2] = lobyte;
                    }
                    ++i;
                    currentPos += 3;
                }
            }
            totalRead += nRead;
            assert (currentPos <= off + len);
        } while (this.source.hasMoreData() && totalRead < nSamples);
        if (totalRead == 0) {
            return -1;
        }
        return totalRead * this.frameSize;
    }

    @Override
    public long skip(long n) throws IOException {
        double[] data = this.source.getData((int)n);
        return data.length;
    }

    @Override
    public int available() throws IOException {
        return this.frameSize * this.source.available();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long getFrameLength() {
        long dataLength = this.source.getDataLength();
        if (dataLength == -1L) {
            return -1L;
        }
        return dataLength;
    }
}

