/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import marytts.util.math.ComplexArray;
import marytts.util.math.MathUtils;

public class FFTMixedRadix {
    private static int maxf = 10000;
    private static int maxp = 10000;
    private static int[] nfac;
    private static int[] np;
    private static double[] at;
    private static double[] ck;
    private static double[] bt;
    private static double[] sk;
    private static int factInd;
    private static int nt;
    private static int ks;
    private static int kspan;
    private static int nn;
    private static int jc;
    private static double radf;
    private static int jf;
    private static double sd;
    private static double cd;
    private static int kk;
    private static int k1;
    private static int k2;
    private static double ak;
    private static double bk;
    private static double c1;
    private static double s1;
    private static double aj;
    private static double bj;
    private static int kspnn;
    private static int k3;
    private static int k4;
    private static double akp;
    private static double akm;
    private static double ajp;
    private static double ajm;
    private static double bkp;
    private static double bkm;
    private static double bjp;
    private static double bjm;
    private static double c2;
    private static double s2;
    private static double c3;
    private static double s3;
    private static double aa;
    private static double bb;
    private static int currentFactor;
    private static int jCount;
    private static int jj;
    private static int jn;
    private static int kt;
    private static int mCount;
    private static int inc;
    private static double c72;
    private static double s72;
    private static double s120;
    private static double rad;

    public static double[] fftPowerSpectrum(double[] x) {
        return FFTMixedRadix.fftPowerSpectrum(x, x.length);
    }

    public static double[] fftPowerSpectrum(double[] x, int fftSize) {
        int w;
        int xlen = x.length;
        ComplexArray h = new ComplexArray(fftSize);
        double[] Ps = new double[fftSize];
        for (w = 0; w < xlen; ++w) {
            h.real[w] = x[w];
            h.imag[w] = 0.0;
        }
        for (w = xlen; w < fftSize; ++w) {
            h.real[w] = 0.0;
            h.imag[w] = 0.0;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, fftSize, fftSize, fftSize, 1);
        for (w = 0; w < fftSize; ++w) {
            h.imag[w] = -h.imag[w];
        }
        for (w = 0; w < fftSize; ++w) {
            Ps[w] = 10.0 * MathUtils.log10(h.real[w] * h.real[w] + h.imag[w] * h.imag[w]);
        }
        return Ps;
    }

    public static double[] fftAbsSpectrum(double[] x) {
        return FFTMixedRadix.fftAbsSpectrum(x, x.length);
    }

    public static double[] fftAbsSpectrum(double[] x, int fftSize) {
        int w;
        int xlen = x.length;
        ComplexArray h = new ComplexArray(fftSize);
        double[] Ps = new double[fftSize];
        for (w = 0; w < xlen; ++w) {
            h.real[w] = x[w];
            h.imag[w] = 0.0;
        }
        for (w = xlen; w < fftSize; ++w) {
            h.real[w] = 0.0;
            h.imag[w] = 0.0;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, fftSize, fftSize, fftSize, 1);
        for (w = 0; w < fftSize; ++w) {
            h.imag[w] = -h.imag[w];
        }
        for (w = 0; w < fftSize; ++w) {
            Ps[w] = Math.sqrt(h.real[w] * h.real[w] + h.imag[w] * h.imag[w]);
        }
        return Ps;
    }

    public static ComplexArray fftReal(double[] x, int xlen) {
        int w;
        ComplexArray h = new ComplexArray(xlen);
        for (w = 0; w < xlen; ++w) {
            h.real[w] = x[w];
            h.imag[w] = 0.0;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, xlen, xlen, xlen, 1);
        for (w = 0; w < xlen; ++w) {
            h.imag[w] = -h.imag[w];
        }
        return h;
    }

    public static ComplexArray fftReal(double[] x, int xlen, int fftSize) {
        int w;
        if (xlen > fftSize) {
            xlen = fftSize;
        }
        double[] x2 = new double[fftSize];
        for (w = 0; w < xlen; ++w) {
            x2[w] = x[w];
        }
        for (w = xlen; w < fftSize; ++w) {
            x2[w] = 0.0;
        }
        ComplexArray h = FFTMixedRadix.fftReal(x2, fftSize);
        return h;
    }

    public static ComplexArray fftComplex(ComplexArray x, int fftSize) {
        int w;
        ComplexArray h = new ComplexArray(fftSize);
        for (w = 0; w < Math.min(x.real.length, fftSize); ++w) {
            h.real[w] = x.real[w];
            h.imag[w] = x.imag[w];
        }
        for (w = x.real.length; w < fftSize; ++w) {
            h.real[w] = 0.0;
            h.imag[w] = 0.0;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, fftSize, fftSize, fftSize, 1);
        int midVal = (int)(Math.floor(fftSize / 2) + 1.0);
        for (w = 1; w < midVal; ++w) {
            double tmp = h.real[w];
            h.real[w] = h.real[fftSize - w];
            h.real[fftSize - w] = tmp;
            tmp = h.imag[w];
            h.imag[w] = h.imag[fftSize - w];
            h.imag[fftSize - w] = tmp;
        }
        return h;
    }

    public static void fftComplexInPlace(double[] real, double[] imag) {
        ComplexArray c = FFTMixedRadix.fftComplex(real, imag, Math.min(real.length, imag.length));
        System.arraycopy(c.real, 0, real, 0, c.real.length);
        System.arraycopy(c.imag, 0, imag, 0, c.imag.length);
    }

    public static ComplexArray fftComplex(double[] real, double[] imag) {
        return FFTMixedRadix.fftComplex(new ComplexArray(real, imag));
    }

    public static ComplexArray fftComplex(double[] real, double[] imag, int ifftSize) {
        return FFTMixedRadix.fftComplex(new ComplexArray(real, imag), ifftSize);
    }

    public static ComplexArray fftComplex(ComplexArray x) {
        return FFTMixedRadix.fftComplex(x, x.real.length);
    }

    public static ComplexArray ifft(ComplexArray x, int ifftSize) {
        ComplexArray h = null;
        if (x.real.length > ifftSize) {
            ComplexArray h2 = FFTMixedRadix.ifft(x);
            h = new ComplexArray(ifftSize);
            for (int w = 0; w < ifftSize; ++w) {
                h.real[w] = h2.real[w];
                h.imag[w] = h2.imag[w];
            }
        } else if (x.real.length == ifftSize) {
            h = FFTMixedRadix.ifft(x);
        } else {
            int w;
            ComplexArray h2 = FFTMixedRadix.ifft(x);
            h = new ComplexArray(ifftSize);
            for (w = 0; w < h2.real.length; ++w) {
                h.real[w] = h2.real[w];
                h.imag[w] = h2.imag[w];
            }
            for (w = h2.real.length; w < ifftSize; ++w) {
                h.real[w] = 0.0;
                h.imag[w] = 0.0;
            }
        }
        return h;
    }

    public static ComplexArray ifft(double[] real, double[] imag) {
        return FFTMixedRadix.ifft(new ComplexArray(real, imag));
    }

    public static ComplexArray ifft(double[] real, double[] imag, int ifftSize) {
        return FFTMixedRadix.ifft(new ComplexArray(real, imag), ifftSize);
    }

    public static ComplexArray ifft(ComplexArray x) {
        int w;
        ComplexArray h = new ComplexArray(x.real.length);
        for (w = 0; w < x.real.length; ++w) {
            h.real[w] = x.real[w] / (double)x.real.length;
            h.imag[w] = x.imag[w] / (double)x.real.length;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, x.real.length, x.real.length, x.real.length, -1);
        int midVal = (int)(Math.floor(x.real.length / 2) + 1.0);
        for (w = 1; w < midVal; ++w) {
            double tmp = h.real[w];
            h.real[w] = h.real[x.real.length - w];
            h.real[x.real.length - w] = tmp;
            tmp = h.imag[w];
            h.imag[w] = h.imag[x.real.length - w];
            h.imag[x.real.length - w] = tmp;
        }
        return h;
    }

    public static double[] ifftReal(ComplexArray x, int ifftSize) {
        int w;
        ComplexArray h = FFTMixedRadix.ifft(x);
        double[] y = new double[ifftSize];
        for (w = 0; w < Math.min(h.real.length, ifftSize); ++w) {
            y[w] = h.real[w];
        }
        for (w = Math.min(h.real.length, ifftSize); w < ifftSize; ++w) {
            y[w] = 0.0;
        }
        return y;
    }

    private static void mixedRadixFFTBase(double[] a, double[] b, int ntot, int fftSize, int nspan, int isn) {
        boolean bLoopLine924 = false;
        boolean bJumpToLine924 = false;
        boolean bJumpToLine950 = true;
        boolean bLoopLine730 = false;
        boolean bJumpToLine730 = false;
        boolean bLoopLine640 = false;
        boolean bJumpToLine640 = false;
        boolean bJumpToLine640_0 = true;
        boolean bLoopLine520 = false;
        boolean bJumpToLine520 = false;
        boolean bLoopLine230 = false;
        boolean bJumpToLine230 = false;
        boolean bLoopLine210 = false;
        boolean bJumpToLine210 = false;
        boolean bLoopLine820 = false;
        boolean bJumpToLine820 = false;
        boolean bLoopLine830 = false;
        boolean bJumpToLine830 = false;
        boolean bLoopLine840 = false;
        boolean bJumpToLine840 = false;
        boolean bLoopLine850 = false;
        boolean bJumpToLine850 = false;
        boolean bLoopLine870 = false;
        boolean bJumpToLine870 = false;
        boolean bLoopLine880 = false;
        boolean bJumpToLine880 = false;
        boolean bLoopLine910 = false;
        boolean bJumpToLine910 = false;
        boolean bJumpToLine914_0 = true;
        boolean bLoopLine914 = false;
        boolean bJumpToLine914 = false;
        boolean bLoopLine420 = false;
        boolean bJumpToLine420 = false;
        boolean bLoopLine440 = false;
        boolean bJumpToLine460 = false;
        boolean bJumpToLine450 = false;
        boolean bLoopLine430 = false;
        boolean bJumpToLine430 = false;
        boolean bLoopLine410 = false;
        boolean bJumpToLine410 = false;
        boolean bLoopLine320 = false;
        boolean bJumpToLine320 = false;
        boolean bLoopLine320Prev = false;
        boolean bJumpToLine320Prev = false;
        boolean bLoopLine320Prev_2 = false;
        boolean bJumpToLine320Prev_2 = false;
        boolean bLoopLine320Prev_3 = false;
        boolean bJumpToLine320Prev_3 = false;
        boolean bLoopLine100 = false;
        boolean bJumpToLine100 = false;
        boolean bJumpToLine100_2 = false;
        boolean bJumpToLine100_3 = false;
        boolean bJumpToLine400 = false;
        boolean bLoopLine510 = false;
        boolean bJumpToLine510 = false;
        boolean bLoopLine510Prev_2 = false;
        boolean bJumpToLine510Prev_2 = false;
        boolean bLoopLine510Prev_3 = false;
        boolean bJumpToLine510Prev_3 = false;
        boolean bLoopLine902 = false;
        boolean bJumpToLine902 = false;
        boolean bLoopLine904 = false;
        boolean bJumpToLine904 = false;
        boolean bJumpToLine906 = false;
        boolean bJumpToLine890 = false;
        boolean bJumpToLine800 = false;
        boolean bJumpToLine800_1 = false;
        boolean bLoopLine410Prev = false;
        boolean bLoopLine420Prev = false;
        boolean bLoopLine430Prev = false;
        boolean bLoopLine440Prev = false;
        boolean bJumpToLine410Prev = false;
        boolean bJumpToLine420Prev = false;
        boolean bJumpToLine430Prev = false;
        boolean bLoopLine410Prev_2 = false;
        boolean bLoopLine420Prev_2 = false;
        boolean bLoopLine430Prev_2 = false;
        boolean bLoopLine440Prev_2 = false;
        boolean bJumpToLine410Prev_2 = false;
        boolean bJumpToLine420Prev_2 = false;
        boolean bJumpToLine430Prev_2 = false;
        boolean bJumpToLine700 = false;
        nfac = new int[200];
        np = new int[maxp];
        at = new double[maxf];
        ck = new double[maxf];
        bt = new double[maxf];
        sk = new double[maxf];
        inc = isn;
        c72 = 0.3090169943749474;
        s72 = 0.9510565162951535;
        s120 = 0.8660254037844386;
        rad = 6.2831853071796;
        if (fftSize < 2) {
            return;
        }
        if (isn < 0) {
            s72 = -s72;
            s120 = -s120;
            rad = -rad;
            inc = -inc;
        }
        nt = inc * ntot;
        kspan = ks = inc * nspan;
        nn = nt - inc;
        jc = ks / fftSize;
        radf = rad * (double)jc * 0.5;
        factInd = 0;
        jf = 0;
        mCount = 0;
        currentFactor = fftSize;
        if (fftSize < 2) {
            FFTMixedRadix.nfac[0] = fftSize;
        } else {
            while (currentFactor % 16 == 0) {
                FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = 4;
                currentFactor /= 16;
            }
            jn = 3;
            jj = 9;
            while (currentFactor % jj == 0) {
                FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = jn;
                currentFactor /= jj;
            }
            jj = (jn += 2) * jn;
            while (jj <= currentFactor) {
                while (currentFactor % jj == 0) {
                    FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = jn;
                    currentFactor /= jj;
                }
                jj = (jn += 2) * jn;
            }
            boolean bGoto80 = false;
            if (currentFactor <= 4) {
                kt = mCount;
                FFTMixedRadix.nfac[FFTMixedRadix.mCount] = currentFactor;
                if (currentFactor != 1) {
                    ++mCount;
                }
                bGoto80 = true;
                if (kt != 0) {
                    boolean bGoto90 = true;
                    for (jn = kt; jn != 0 || bGoto90; --jn) {
                        bGoto90 = false;
                        FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = nfac[jn - 1];
                    }
                }
            }
            if (!bGoto80) {
                if ((double)currentFactor - Math.floor((double)currentFactor / 4.0) * 4.0 == 0.0) {
                    FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = 2;
                    currentFactor /= 4;
                }
                kt = mCount;
                jn = 2;
                boolean bGoto60 = true;
                while (jn <= currentFactor || bGoto60) {
                    bGoto60 = false;
                    if (currentFactor % jn == 0) {
                        FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = jn;
                        currentFactor /= jn;
                    }
                    jn = (int)(Math.floor(((double)jn + 1.0) / 2.0) * 2.0 + 1.0);
                }
                if (kt != 0) {
                    boolean bGoto90 = true;
                    for (jn = kt; jn != 0 || bGoto90; --jn) {
                        bGoto90 = false;
                        FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = nfac[jn - 1];
                    }
                }
            }
        }
        do {
            bLoopLine100 = false;
            if (bJumpToLine100_2) {
                bJumpToLine100_2 = false;
                bLoopLine440 = bLoopLine440Prev_2;
                bLoopLine430 = bLoopLine430Prev_2;
                bLoopLine420 = bLoopLine420Prev_2;
                bLoopLine410 = bLoopLine410Prev_2;
                bLoopLine510 = bLoopLine510Prev_2;
                bLoopLine320 = bLoopLine320Prev_2;
                bJumpToLine410 = bJumpToLine410Prev_2;
                bJumpToLine420 = bJumpToLine420Prev_2;
                bJumpToLine430 = bJumpToLine430Prev_2;
                bJumpToLine510 = bJumpToLine510Prev_2;
                bJumpToLine320 = bJumpToLine320Prev_2;
            }
            if (bJumpToLine100_3) {
                bJumpToLine100_3 = false;
                bLoopLine510 = bLoopLine510Prev_3;
                bLoopLine320 = bLoopLine320Prev_3;
                bJumpToLine510 = bJumpToLine510Prev_3;
                bJumpToLine320 = bJumpToLine320Prev_3;
            }
            if (bJumpToLine100) {
                bJumpToLine100 = false;
            }
            sd = radf / (double)kspan;
            cd = 2.0 * Math.sin(sd) * Math.sin(sd);
            sd = Math.sin(sd + sd);
            kk = 1;
            if (!(bJumpToLine400 = nfac[++factInd - 1] != 2)) {
                k1 = (kspan /= 2) + 2;
                do {
                    bLoopLine210 = false;
                    bJumpToLine210 = false;
                    k2 = kk + kspan;
                    ak = a[k2 - 1];
                    bk = b[k2 - 1];
                    a[FFTMixedRadix.k2 - 1] = a[kk - 1] - ak;
                    b[FFTMixedRadix.k2 - 1] = b[kk - 1] - bk;
                    a[FFTMixedRadix.kk - 1] = a[kk - 1] + ak;
                    b[FFTMixedRadix.kk - 1] = b[kk - 1] + bk;
                    kk = k2 + kspan;
                    if (kk <= nn) {
                        bLoopLine210 = true;
                        bJumpToLine210 = true;
                    } else {
                        bLoopLine210 = false;
                        bJumpToLine210 = false;
                    }
                    if (bJumpToLine210) continue;
                    if ((kk -= nn) <= jc) {
                        bLoopLine210 = true;
                        bJumpToLine210 = true;
                        continue;
                    }
                    bLoopLine210 = false;
                    bJumpToLine210 = false;
                } while (bLoopLine210);
                bJumpToLine800 = kk > kspan;
                if (!bJumpToLine800) {
                    do {
                        c1 = 1.0 - cd;
                        s1 = sd;
                        do {
                            bLoopLine230 = false;
                            bJumpToLine230 = false;
                            k2 = kk + kspan;
                            ak = a[kk - 1] - a[k2 - 1];
                            bk = b[kk - 1] - b[k2 - 1];
                            a[FFTMixedRadix.kk - 1] = a[kk - 1] + a[k2 - 1];
                            b[FFTMixedRadix.kk - 1] = b[kk - 1] + b[k2 - 1];
                            a[FFTMixedRadix.k2 - 1] = c1 * ak - s1 * bk;
                            b[FFTMixedRadix.k2 - 1] = s1 * ak + c1 * bk;
                            kk = k2 + kspan;
                            if (kk < nt) {
                                bLoopLine230 = true;
                                bJumpToLine230 = true;
                            } else {
                                bLoopLine230 = false;
                                bJumpToLine230 = false;
                            }
                            if (bJumpToLine230) continue;
                            k2 = kk - nt;
                            c1 = -c1;
                            kk = k1 - k2;
                            if (kk > k2) {
                                bLoopLine230 = true;
                                bJumpToLine230 = true;
                            } else {
                                bLoopLine230 = false;
                                bJumpToLine230 = false;
                            }
                            if (bJumpToLine230) continue;
                            ak = c1 - (cd * c1 + sd * s1);
                            s1 = sd * c1 - cd * s1 + s1;
                            c1 = 2.0 - (ak * ak + s1 * s1);
                            s1 = c1 * s1;
                            c1 *= ak;
                            if ((kk += jc) < k2) {
                                bLoopLine230 = true;
                                bJumpToLine230 = true;
                                continue;
                            }
                            bLoopLine230 = false;
                            bJumpToLine230 = false;
                        } while (bLoopLine230);
                    } while ((kk = ((k1 = k1 + inc + inc) - kspan) / 2 + jc) <= jc + jc);
                    bLoopLine100 = true;
                    bJumpToLine100 = true;
                }
            }
            if (bJumpToLine100 && !bJumpToLine400 && !bJumpToLine800) continue;
            do {
                if (!bJumpToLine800 && !bJumpToLine400) {
                    bLoopLine320 = false;
                    bJumpToLine320 = false;
                    k1 = kk + kspan;
                    k2 = k1 + kspan;
                    ak = a[kk - 1];
                    bk = b[kk - 1];
                    aj = a[k1 - 1] + a[k2 - 1];
                    bj = b[k1 - 1] + b[k2 - 1];
                    a[FFTMixedRadix.kk - 1] = ak + aj;
                    b[FFTMixedRadix.kk - 1] = bk + bj;
                    ak = -0.5 * aj + ak;
                    bk = -0.5 * bj + bk;
                    aj = (a[k1 - 1] - a[k2 - 1]) * s120;
                    bj = (b[k1 - 1] - b[k2 - 1]) * s120;
                    a[FFTMixedRadix.k1 - 1] = ak - bj;
                    b[FFTMixedRadix.k1 - 1] = bk + aj;
                    a[FFTMixedRadix.k2 - 1] = ak + bj;
                    b[FFTMixedRadix.k2 - 1] = bk - aj;
                    kk = k2 + kspan;
                    if (kk < nn) {
                        bLoopLine320 = true;
                        bJumpToLine320 = true;
                    } else {
                        bLoopLine320 = false;
                        bJumpToLine320 = false;
                    }
                }
                if (bJumpToLine320 && !bJumpToLine400 && !bJumpToLine800) continue;
                if (!bJumpToLine800 && !bJumpToLine400) {
                    if ((kk -= nn) <= kspan) {
                        bLoopLine320 = true;
                        bJumpToLine320 = true;
                    } else {
                        bLoopLine320 = false;
                        bJumpToLine320 = false;
                    }
                }
                if (bJumpToLine320 && !bJumpToLine400 && !bJumpToLine800) continue;
                if (!bJumpToLine800 && !bJumpToLine700) {
                    bJumpToLine700 = !bJumpToLine400;
                }
                do {
                    if (!(bJumpToLine700 && !bJumpToLine400 || bJumpToLine800 && !bJumpToLine400)) {
                        bJumpToLine400 = false;
                        if (nfac[factInd - 1] == 4 || bJumpToLine510) {
                            if (!bJumpToLine510) {
                                kspnn = kspan;
                                kspan /= 4;
                                do {
                                    bLoopLine410 = false;
                                    bJumpToLine410 = false;
                                    c1 = 1.0;
                                    s1 = 0.0;
                                    do {
                                        bLoopLine420 = false;
                                        bJumpToLine420 = false;
                                        k1 = kk + kspan;
                                        k2 = k1 + kspan;
                                        k3 = k2 + kspan;
                                        akp = a[kk - 1] + a[k2 - 1];
                                        akm = a[kk - 1] - a[k2 - 1];
                                        ajp = a[k1 - 1] + a[k3 - 1];
                                        ajm = a[k1 - 1] - a[k3 - 1];
                                        a[FFTMixedRadix.kk - 1] = akp + ajp;
                                        ajp = akp - ajp;
                                        bkp = b[kk - 1] + b[k2 - 1];
                                        bkm = b[kk - 1] - b[k2 - 1];
                                        bjp = b[k1 - 1] + b[k3 - 1];
                                        bjm = b[k1 - 1] - b[k3 - 1];
                                        b[FFTMixedRadix.kk - 1] = bkp + bjp;
                                        bjp = bkp - bjp;
                                        bJumpToLine450 = isn < 0;
                                        if (!bJumpToLine450) {
                                            akp = akm - bjm;
                                            akm += bjm;
                                            bkp = bkm + ajm;
                                            bkm -= ajm;
                                            bJumpToLine460 = s1 == 0.0;
                                        }
                                        do {
                                            bLoopLine430 = false;
                                            bJumpToLine430 = false;
                                            if (!bJumpToLine460 && !bJumpToLine450) {
                                                a[FFTMixedRadix.k1 - 1] = akp * c1 - bkp * s1;
                                                b[FFTMixedRadix.k1 - 1] = akp * s1 + bkp * c1;
                                                a[FFTMixedRadix.k2 - 1] = ajp * c2 - bjp * s2;
                                                b[FFTMixedRadix.k2 - 1] = ajp * s2 + bjp * c2;
                                                a[FFTMixedRadix.k3 - 1] = akm * c3 - bkm * s3;
                                                b[FFTMixedRadix.k3 - 1] = akm * s3 + bkm * c3;
                                                kk = k3 + kspan;
                                                if (kk <= nt) {
                                                    bLoopLine420 = true;
                                                    bJumpToLine420 = true;
                                                } else {
                                                    bLoopLine420 = false;
                                                    bJumpToLine420 = false;
                                                }
                                            }
                                            if (bJumpToLine420 && !bJumpToLine460 && !bJumpToLine450) continue;
                                            do {
                                                if (!bJumpToLine460 && !bJumpToLine450) {
                                                    bLoopLine440 = false;
                                                    c2 = c1 - (cd * c1 + sd * s1);
                                                    s1 = sd * c1 - cd * s1 + s1;
                                                    c1 = 2.0 - (c2 * c2 + s1 * s1);
                                                    s1 = c1 * s1;
                                                    c1 *= c2;
                                                    c2 = c1 * c1 - s1 * s1;
                                                    s2 = 2.0 * c1 * s1;
                                                    c3 = c2 * c1 - s2 * s1;
                                                    s3 = c2 * s1 + s2 * c1;
                                                    if ((kk = kk - nt + jc) <= kspan) {
                                                        bLoopLine420 = true;
                                                        bJumpToLine420 = true;
                                                    } else {
                                                        bLoopLine420 = false;
                                                        bJumpToLine420 = false;
                                                    }
                                                }
                                                if (bJumpToLine420 && !bJumpToLine460 && !bJumpToLine450) continue;
                                                if (!bJumpToLine460) {
                                                    if (!bJumpToLine450) {
                                                        if ((kk = kk - kspan + inc) <= jc) {
                                                            bLoopLine410 = true;
                                                            bJumpToLine410 = true;
                                                            bLoopLine440 = false;
                                                            bLoopLine430 = false;
                                                            bJumpToLine430 = false;
                                                            bLoopLine420 = false;
                                                            bJumpToLine420 = false;
                                                        } else {
                                                            bLoopLine410 = false;
                                                            bJumpToLine410 = false;
                                                        }
                                                        if (!bJumpToLine410) {
                                                            if (kspan == jc) {
                                                                bJumpToLine800_1 = true;
                                                                bLoopLine410Prev = bLoopLine410;
                                                                bLoopLine420Prev = bLoopLine420;
                                                                bLoopLine430Prev = bLoopLine430;
                                                                bLoopLine440Prev = bLoopLine440;
                                                                bJumpToLine410Prev = bJumpToLine410;
                                                                bJumpToLine420Prev = bJumpToLine420;
                                                                bJumpToLine430Prev = bJumpToLine430;
                                                                bLoopLine410 = false;
                                                                bLoopLine420 = false;
                                                                bLoopLine430 = false;
                                                                bLoopLine440 = false;
                                                                bJumpToLine410 = false;
                                                                bJumpToLine420 = false;
                                                                bJumpToLine430 = false;
                                                            } else {
                                                                bJumpToLine800_1 = false;
                                                            }
                                                            if (!bJumpToLine800_1) {
                                                                bLoopLine100 = true;
                                                                bJumpToLine100_2 = true;
                                                                bLoopLine410Prev_2 = bLoopLine410;
                                                                bLoopLine420Prev_2 = bLoopLine420;
                                                                bLoopLine430Prev_2 = bLoopLine430;
                                                                bLoopLine440Prev_2 = bLoopLine440;
                                                                bLoopLine510Prev_2 = bLoopLine510;
                                                                bLoopLine320Prev_2 = bLoopLine320;
                                                                bJumpToLine410Prev_2 = bJumpToLine410;
                                                                bJumpToLine420Prev_2 = bJumpToLine420;
                                                                bJumpToLine430Prev_2 = bJumpToLine430;
                                                                bJumpToLine510Prev_2 = bJumpToLine510;
                                                                bJumpToLine320Prev_2 = bJumpToLine320;
                                                                bLoopLine440 = false;
                                                                bLoopLine430 = false;
                                                                bLoopLine420 = false;
                                                                bLoopLine410 = false;
                                                                bLoopLine510 = false;
                                                                bLoopLine320 = false;
                                                                bJumpToLine410 = false;
                                                                bJumpToLine420 = false;
                                                                bJumpToLine430 = false;
                                                                bJumpToLine510 = false;
                                                                bJumpToLine320 = false;
                                                            }
                                                        }
                                                    }
                                                    if (!(bJumpToLine100_2 || bJumpToLine800_1 || bJumpToLine410)) {
                                                        bJumpToLine450 = false;
                                                        akp = akm + bjm;
                                                        akm -= bjm;
                                                        bkp = bkm - ajm;
                                                        bkm += ajm;
                                                        if (s1 != 0.0) {
                                                            bLoopLine430 = true;
                                                            bJumpToLine430 = true;
                                                            bLoopLine440 = false;
                                                        } else {
                                                            bLoopLine430 = false;
                                                            bJumpToLine430 = false;
                                                        }
                                                    }
                                                }
                                                if (bJumpToLine100_2 || bJumpToLine800_1 || bJumpToLine430 || bJumpToLine410) continue;
                                                bJumpToLine460 = false;
                                                a[FFTMixedRadix.k1 - 1] = akp;
                                                b[FFTMixedRadix.k1 - 1] = bkp;
                                                a[FFTMixedRadix.k2 - 1] = ajp;
                                                b[FFTMixedRadix.k2 - 1] = bjp;
                                                a[FFTMixedRadix.k3 - 1] = akm;
                                                b[FFTMixedRadix.k3 - 1] = bkm;
                                                kk = k3 + kspan;
                                                if (kk <= nt) {
                                                    bLoopLine420 = true;
                                                    bJumpToLine420 = true;
                                                } else {
                                                    bLoopLine420 = false;
                                                    bJumpToLine420 = false;
                                                }
                                                bLoopLine440 = !bJumpToLine420;
                                            } while (bLoopLine440);
                                        } while (bLoopLine430);
                                    } while (bLoopLine420);
                                } while (bLoopLine410);
                            }
                            if (!bJumpToLine100_2 && !bJumpToLine800_1) {
                                if (bJumpToLine510) {
                                    bJumpToLine510 = false;
                                    bLoopLine510 = false;
                                    bJumpToLine320 = bJumpToLine320Prev;
                                    bLoopLine320 = bLoopLine320Prev;
                                }
                                c2 = c72 * c72 - s72 * s72;
                                s2 = 2.0 * c72 * s72;
                                do {
                                    bLoopLine520 = false;
                                    bJumpToLine520 = false;
                                    k1 = kk + kspan;
                                    k2 = k1 + kspan;
                                    k3 = k2 + kspan;
                                    k4 = k3 + kspan;
                                    akp = a[k1 - 1] + a[k4 - 1];
                                    akm = a[k1 - 1] - a[k4 - 1];
                                    bkp = b[k1 - 1] + b[k4 - 1];
                                    bkm = b[k1 - 1] - b[k4 - 1];
                                    ajp = a[k2 - 1] + a[k3 - 1];
                                    ajm = a[k2 - 1] - a[k3 - 1];
                                    bjp = b[k2 - 1] + b[k3 - 1];
                                    bjm = b[k2 - 1] - b[k3 - 1];
                                    aa = a[kk - 1];
                                    bb = b[kk - 1];
                                    a[FFTMixedRadix.kk - 1] = aa + akp + ajp;
                                    b[FFTMixedRadix.kk - 1] = bb + bkp + bjp;
                                    ak = akp * c72 + ajp * c2 + aa;
                                    bk = bkp * c72 + bjp * c2 + bb;
                                    aj = akm * s72 + ajm * s2;
                                    bj = bkm * s72 + bjm * s2;
                                    a[FFTMixedRadix.k1 - 1] = ak - bj;
                                    a[FFTMixedRadix.k4 - 1] = ak + bj;
                                    b[FFTMixedRadix.k1 - 1] = bk + aj;
                                    b[FFTMixedRadix.k4 - 1] = bk - aj;
                                    ak = akp * c2 + ajp * c72 + aa;
                                    bk = bkp * c2 + bjp * c72 + bb;
                                    aj = akm * s2 - ajm * s72;
                                    bj = bkm * s2 - bjm * s72;
                                    a[FFTMixedRadix.k2 - 1] = ak - bj;
                                    a[FFTMixedRadix.k3 - 1] = ak + bj;
                                    b[FFTMixedRadix.k2 - 1] = bk + aj;
                                    b[FFTMixedRadix.k3 - 1] = bk - aj;
                                    kk = k4 + kspan;
                                    if (kk < nn) {
                                        bLoopLine520 = true;
                                        bJumpToLine520 = true;
                                    } else {
                                        bLoopLine520 = false;
                                        bJumpToLine520 = false;
                                    }
                                    if (bJumpToLine520) continue;
                                    if ((kk -= nn) <= kspan) {
                                        bLoopLine520 = true;
                                        bJumpToLine520 = true;
                                        continue;
                                    }
                                    bLoopLine520 = false;
                                    bJumpToLine520 = false;
                                } while (bLoopLine520);
                                bJumpToLine700 = true;
                            }
                        }
                        if (!(bJumpToLine100_2 || bJumpToLine800_1 || bJumpToLine700)) {
                            currentFactor = nfac[factInd - 1];
                            kspnn = kspan;
                            kspan /= currentFactor;
                            if (currentFactor == 3) {
                                bLoopLine320 = true;
                                bJumpToLine320 = true;
                            } else {
                                bLoopLine320 = false;
                                bJumpToLine320 = false;
                            }
                        }
                    }
                    if (bJumpToLine100_2 || bJumpToLine320 && !bJumpToLine800 && !bJumpToLine800_1 && !bJumpToLine700) continue;
                    if (!(bJumpToLine800 || bJumpToLine800_1 || bJumpToLine700)) {
                        if (currentFactor == 5) {
                            bLoopLine510 = true;
                            bJumpToLine510 = true;
                            bJumpToLine320Prev = bJumpToLine320;
                            bLoopLine320Prev = bLoopLine320;
                            bLoopLine320 = false;
                            bJumpToLine320 = false;
                        } else {
                            bLoopLine510 = false;
                            bJumpToLine510 = false;
                        }
                    }
                    if (bJumpToLine510 && !bJumpToLine800 && !bJumpToLine800_1 && !bJumpToLine700) continue;
                    if (!bJumpToLine800 && !bJumpToLine800_1) {
                        if (!bJumpToLine700) {
                            bJumpToLine640_0 = currentFactor == jf;
                            if (!bJumpToLine640_0) {
                                jf = currentFactor;
                                s1 = rad / (double)currentFactor;
                                c1 = Math.cos(s1);
                                s1 = Math.sin(s1);
                                if (jf > maxf) {
                                    isn = 0;
                                    System.out.println("Array bounds exceeded within subroutine fft\fftSize");
                                    return;
                                }
                                FFTMixedRadix.ck[FFTMixedRadix.jf - 1] = 1.0;
                                FFTMixedRadix.sk[FFTMixedRadix.jf - 1] = 0.0;
                                jCount = 1;
                                do {
                                    FFTMixedRadix.ck[FFTMixedRadix.jCount - 1] = ck[currentFactor - 1] * c1 + sk[currentFactor - 1] * s1;
                                    FFTMixedRadix.sk[FFTMixedRadix.jCount - 1] = ck[currentFactor - 1] * s1 - sk[currentFactor - 1] * c1;
                                    FFTMixedRadix.ck[--FFTMixedRadix.currentFactor - 1] = ck[jCount - 1];
                                    FFTMixedRadix.sk[FFTMixedRadix.currentFactor - 1] = -sk[jCount - 1];
                                } while (++jCount < currentFactor);
                            }
                            do {
                                bLoopLine640 = false;
                                bJumpToLine640 = false;
                                k1 = kk;
                                k2 = kk + kspnn;
                                aa = a[kk - 1];
                                bb = b[kk - 1];
                                ak = aa;
                                bk = bb;
                                jCount = 1;
                                k1 += kspan;
                                do {
                                    FFTMixedRadix.at[++FFTMixedRadix.jCount - 1] = a[k1 - 1] + a[(k2 -= kspan) - 1];
                                    ak = at[jCount - 1] + ak;
                                    FFTMixedRadix.bt[FFTMixedRadix.jCount - 1] = b[k1 - 1] + b[k2 - 1];
                                    bk = bt[jCount - 1] + bk;
                                    FFTMixedRadix.at[++FFTMixedRadix.jCount - 1] = a[k1 - 1] - a[k2 - 1];
                                    FFTMixedRadix.bt[FFTMixedRadix.jCount - 1] = b[k1 - 1] - b[k2 - 1];
                                } while ((k1 += kspan) < k2);
                                a[FFTMixedRadix.kk - 1] = ak;
                                b[FFTMixedRadix.kk - 1] = bk;
                                k1 = kk;
                                k2 = kk + kspnn;
                                jCount = 1;
                                do {
                                    k1 += kspan;
                                    k2 -= kspan;
                                    jj = jCount;
                                    ak = aa;
                                    bk = bb;
                                    aj = 0.0;
                                    bj = 0.0;
                                    currentFactor = 1;
                                    do {
                                        ak = at[++currentFactor - 1] * ck[jj - 1] + ak;
                                        bk = bt[currentFactor - 1] * ck[jj - 1] + bk;
                                        aj = at[++currentFactor - 1] * sk[jj - 1] + aj;
                                        bj = bt[currentFactor - 1] * sk[jj - 1] + bj;
                                        if ((jj += jCount) <= jf) continue;
                                        jj -= jf;
                                    } while (currentFactor < jf);
                                    currentFactor = jf - jCount;
                                    a[FFTMixedRadix.k1 - 1] = ak - bj;
                                    b[FFTMixedRadix.k1 - 1] = bk + aj;
                                    a[FFTMixedRadix.k2 - 1] = ak + bj;
                                    b[FFTMixedRadix.k2 - 1] = bk - aj;
                                } while (++jCount < currentFactor);
                                if ((kk += kspnn) <= nn) {
                                    bLoopLine640 = true;
                                    bJumpToLine640 = true;
                                } else {
                                    bLoopLine640 = false;
                                    bJumpToLine640 = false;
                                }
                                if (bJumpToLine640) continue;
                                if ((kk -= nn) <= kspan) {
                                    bLoopLine640 = true;
                                    bJumpToLine640 = true;
                                    continue;
                                }
                                bLoopLine640 = false;
                                bJumpToLine640 = false;
                            } while (bLoopLine640);
                        }
                        bJumpToLine700 = false;
                        bJumpToLine800 = factInd == mCount;
                        if (!bJumpToLine800) {
                            kk = jc + 1;
                            do {
                                c2 = 1.0 - cd;
                                s1 = sd;
                                do {
                                    c1 = c2;
                                    s2 = s1;
                                    kk += kspan;
                                    do {
                                        bJumpToLine730 = false;
                                        bLoopLine730 = false;
                                        ak = a[kk - 1];
                                        a[FFTMixedRadix.kk - 1] = c2 * ak - s2 * b[kk - 1];
                                        b[FFTMixedRadix.kk - 1] = s2 * ak + c2 * b[kk - 1];
                                        if ((kk += kspnn) <= nt) {
                                            bJumpToLine730 = true;
                                            bLoopLine730 = true;
                                        } else {
                                            bJumpToLine730 = false;
                                            bLoopLine730 = false;
                                        }
                                        if (bJumpToLine730) continue;
                                        ak = s1 * s2;
                                        s2 = s1 * c2 + c1 * s2;
                                        c2 = c1 * c2 - ak;
                                        if ((kk = kk - nt + kspan) <= kspnn) {
                                            bJumpToLine730 = true;
                                            bLoopLine730 = true;
                                            continue;
                                        }
                                        bJumpToLine730 = false;
                                        bLoopLine730 = false;
                                    } while (bLoopLine730);
                                    c2 = c1 - (cd * c1 + sd * s1);
                                    s1 += sd * c1 - cd * s1;
                                    c1 = 2.0 - (c2 * c2 + s1 * s1);
                                    s1 = c1 * s1;
                                    c2 = c1 * c2;
                                } while ((kk = kk - kspnn + jc) <= kspan);
                            } while ((kk = kk - kspan + jc + inc) <= jc + jc);
                            bLoopLine100 = true;
                            bJumpToLine100_3 = true;
                            bLoopLine510Prev_3 = bLoopLine510;
                            bLoopLine320Prev_3 = bLoopLine320;
                            bJumpToLine510Prev_3 = bJumpToLine510;
                            bJumpToLine320Prev_3 = bJumpToLine320;
                            bLoopLine510 = false;
                            bLoopLine320 = false;
                            bJumpToLine510 = false;
                            bJumpToLine320 = false;
                        }
                    }
                    if (bJumpToLine100_3) continue;
                    bJumpToLine800 = false;
                    bJumpToLine800_1 = false;
                    FFTMixedRadix.np[0] = ks;
                    if (kt == 0) {
                        bJumpToLine890 = true;
                    }
                    if (!bJumpToLine890) {
                        currentFactor = kt + kt + 1;
                        if (mCount < currentFactor) {
                            --currentFactor;
                        }
                        jCount = 1;
                        FFTMixedRadix.np[FFTMixedRadix.currentFactor + 1 - 1] = jc;
                        do {
                            FFTMixedRadix.np[FFTMixedRadix.jCount + 1 - 1] = np[jCount - 1] / nfac[jCount - 1];
                            FFTMixedRadix.np[FFTMixedRadix.currentFactor - 1] = np[currentFactor + 1 - 1] * nfac[jCount - 1];
                        } while (++jCount < --currentFactor);
                        k3 = np[currentFactor + 1 - 1];
                        kspan = np[1];
                        kk = jc + 1;
                        k2 = kspan + 1;
                        jCount = 1;
                    }
                    if (fftSize == ntot || !bJumpToLine890) {
                        if (!bJumpToLine890) {
                            do {
                                bLoopLine820 = false;
                                bJumpToLine820 = false;
                                ak = a[kk - 1];
                                a[FFTMixedRadix.kk - 1] = a[k2 - 1];
                                a[FFTMixedRadix.k2 - 1] = ak;
                                bk = b[kk - 1];
                                b[FFTMixedRadix.kk - 1] = b[k2 - 1];
                                b[FFTMixedRadix.k2 - 1] = bk;
                                kk += inc;
                                if ((k2 = kspan + k2) < ks) {
                                    bLoopLine820 = true;
                                    bJumpToLine820 = true;
                                } else {
                                    bLoopLine820 = false;
                                    bJumpToLine820 = false;
                                }
                                if (bJumpToLine820) continue;
                                do {
                                    bLoopLine830 = false;
                                    bJumpToLine830 = false;
                                    k2 -= np[jCount - 1];
                                    if ((k2 = np[++jCount + 1 - 1] + k2) > np[jCount - 1]) {
                                        bLoopLine830 = true;
                                        bJumpToLine830 = true;
                                    } else {
                                        bLoopLine830 = false;
                                        bJumpToLine830 = false;
                                    }
                                    if (bJumpToLine830) continue;
                                    jCount = 1;
                                    do {
                                        bLoopLine840 = false;
                                        bJumpToLine840 = false;
                                        if (kk < k2) {
                                            bLoopLine820 = true;
                                            bJumpToLine820 = true;
                                            bLoopLine830 = false;
                                            bJumpToLine830 = false;
                                        } else {
                                            bLoopLine820 = false;
                                            bJumpToLine820 = false;
                                        }
                                        if (bJumpToLine820) continue;
                                        kk += inc;
                                        if ((k2 = kspan + k2) < ks) {
                                            bLoopLine840 = true;
                                            bJumpToLine840 = true;
                                        } else {
                                            bLoopLine840 = false;
                                            bJumpToLine840 = false;
                                        }
                                        if (bJumpToLine840) continue;
                                        if (kk < ks) {
                                            bLoopLine830 = true;
                                            bJumpToLine830 = true;
                                        } else {
                                            bLoopLine830 = false;
                                            bJumpToLine830 = false;
                                        }
                                        if (bJumpToLine830) continue;
                                        jc = k3;
                                    } while (bLoopLine840);
                                } while (bLoopLine830);
                            } while (bLoopLine820);
                        }
                        bJumpToLine890 = true;
                    }
                    if (!bJumpToLine890) {
                        do {
                            bLoopLine850 = false;
                            bJumpToLine850 = false;
                            currentFactor = kk + jc;
                            do {
                                ak = a[kk - 1];
                                a[FFTMixedRadix.kk - 1] = a[k2 - 1];
                                a[FFTMixedRadix.k2 - 1] = ak;
                                bk = b[kk - 1];
                                b[FFTMixedRadix.kk - 1] = b[k2 - 1];
                                b[FFTMixedRadix.k2 - 1] = bk;
                                k2 += inc;
                            } while ((kk += inc) < currentFactor);
                            kk = kk + ks - jc;
                            k2 = k2 + ks - jc;
                            if (kk < nt) {
                                bLoopLine850 = true;
                                bJumpToLine850 = true;
                            } else {
                                bLoopLine850 = false;
                                bJumpToLine850 = false;
                            }
                            if (bJumpToLine850) continue;
                            k2 = k2 - nt + kspan;
                            kk = kk - nt + jc;
                            if (k2 < ks) {
                                bLoopLine850 = true;
                                bJumpToLine850 = true;
                            } else {
                                bLoopLine850 = false;
                                bJumpToLine850 = false;
                            }
                            if (bJumpToLine850) continue;
                            do {
                                bLoopLine870 = false;
                                bJumpToLine870 = false;
                                k2 -= np[jCount - 1];
                                if ((k2 = np[++jCount + 1 - 1] + k2) > np[jCount - 1]) {
                                    bLoopLine870 = true;
                                    bJumpToLine870 = true;
                                } else {
                                    bLoopLine870 = false;
                                    bJumpToLine870 = false;
                                }
                                if (bJumpToLine870) continue;
                                jCount = 1;
                                do {
                                    bLoopLine880 = false;
                                    bJumpToLine880 = false;
                                    if (kk < k2) {
                                        bLoopLine850 = true;
                                        bJumpToLine850 = true;
                                    } else {
                                        bLoopLine850 = false;
                                        bJumpToLine850 = false;
                                    }
                                    if (bJumpToLine850) continue;
                                    kk += jc;
                                    if ((k2 = kspan + k2) < ks) {
                                        bLoopLine880 = true;
                                        bJumpToLine880 = true;
                                    } else {
                                        bLoopLine880 = false;
                                        bJumpToLine880 = false;
                                    }
                                    if (bJumpToLine880) continue;
                                    if (kk < ks) {
                                        bLoopLine870 = true;
                                        bJumpToLine870 = true;
                                    } else {
                                        bLoopLine870 = false;
                                        bJumpToLine870 = false;
                                    }
                                    if (bJumpToLine870) continue;
                                    jc = k3;
                                } while (bLoopLine880);
                            } while (bLoopLine870);
                        } while (bLoopLine850);
                    }
                    bJumpToLine890 = false;
                    if (2 * kt + 1 >= mCount) {
                        return;
                    }
                    kspnn = np[kt + 1 - 1];
                    jCount = mCount - kt;
                    FFTMixedRadix.nfac[FFTMixedRadix.jCount + 1 - 1] = 1;
                    do {
                        FFTMixedRadix.nfac[FFTMixedRadix.jCount - 1] = nfac[jCount - 1] * nfac[jCount + 1 - 1];
                    } while (--jCount != kt);
                    if ((nn = nfac[++kt - 1] - 1) > maxp) {
                        isn = 0;
                        System.out.println("Array bounds exceeded within subroutine fft\fftSize");
                        return;
                    }
                    jj = 0;
                    jCount = 0;
                    bJumpToLine906 = true;
                    do {
                        if (!bJumpToLine906) {
                            bLoopLine902 = false;
                            bJumpToLine902 = false;
                            jj -= k2;
                            k2 = kk;
                            kk = nfac[++currentFactor - 1];
                        }
                        do {
                            if (!bJumpToLine906) {
                                bLoopLine904 = false;
                                bJumpToLine904 = false;
                                if ((jj = kk + jj) >= k2) {
                                    bLoopLine902 = true;
                                    bJumpToLine902 = true;
                                } else {
                                    bLoopLine902 = false;
                                    bJumpToLine902 = false;
                                }
                            }
                            if (bJumpToLine902 && !bJumpToLine906) continue;
                            if (!bJumpToLine906) {
                                FFTMixedRadix.np[FFTMixedRadix.jCount - 1] = jj;
                            }
                            bJumpToLine906 = false;
                            k2 = nfac[kt - 1];
                            currentFactor = kt + 1;
                            kk = nfac[currentFactor - 1];
                            if (++jCount <= nn) {
                                bLoopLine904 = true;
                                bJumpToLine904 = true;
                            } else {
                                bLoopLine904 = false;
                                bJumpToLine904 = false;
                            }
                            if (bJumpToLine904) continue;
                            jCount = 0;
                            bJumpToLine914_0 = true;
                            do {
                                if (!bJumpToLine914_0) {
                                    bLoopLine910 = false;
                                    bJumpToLine910 = false;
                                    currentFactor = kk;
                                    kk = np[currentFactor - 1];
                                    FFTMixedRadix.np[FFTMixedRadix.currentFactor - 1] = -kk;
                                    if (kk != jCount) {
                                        bLoopLine910 = true;
                                        bJumpToLine910 = true;
                                    } else {
                                        bLoopLine910 = false;
                                        bJumpToLine910 = false;
                                    }
                                }
                                if (bJumpToLine910 && !bJumpToLine914_0) continue;
                                if (!bJumpToLine914_0) {
                                    k3 = kk;
                                }
                                do {
                                    bLoopLine914 = false;
                                    bJumpToLine914 = false;
                                    bJumpToLine914_0 = false;
                                    if ((kk = np[++jCount - 1]) < 0) {
                                        bLoopLine914 = true;
                                        bJumpToLine914 = true;
                                    } else {
                                        bLoopLine914 = false;
                                        bJumpToLine914 = false;
                                    }
                                    if (bJumpToLine914) continue;
                                    if (kk != jCount) {
                                        bLoopLine910 = true;
                                        bJumpToLine910 = true;
                                    } else {
                                        bLoopLine910 = false;
                                        bJumpToLine910 = false;
                                    }
                                    if (bJumpToLine910) continue;
                                    FFTMixedRadix.np[FFTMixedRadix.jCount - 1] = -jCount;
                                    if (jCount != nn) {
                                        bLoopLine914 = true;
                                        bJumpToLine914 = true;
                                    } else {
                                        bLoopLine914 = false;
                                        bJumpToLine914 = false;
                                    }
                                    if (bJumpToLine914) continue;
                                    maxf = inc * maxf;
                                    bJumpToLine950 = true;
                                } while (bLoopLine914);
                            } while (bLoopLine910);
                            do {
                                bLoopLine924 = false;
                                bJumpToLine924 = false;
                                if (!bJumpToLine950) {
                                    if (np[--jCount - 1] < 0) {
                                        bLoopLine924 = true;
                                        bJumpToLine924 = true;
                                    } else {
                                        bLoopLine924 = false;
                                        bJumpToLine924 = false;
                                    }
                                    if (!bJumpToLine924) {
                                        jj = jc;
                                        do {
                                            kspan = jj;
                                            if (jj > maxf) {
                                                kspan = maxf;
                                            }
                                            currentFactor = np[jCount - 1];
                                            kk = jc * currentFactor + factInd + (jj -= kspan);
                                            k1 = kk + kspan;
                                            k2 = 0;
                                            do {
                                                FFTMixedRadix.at[++FFTMixedRadix.k2 - 1] = a[k1 - 1];
                                                FFTMixedRadix.bt[FFTMixedRadix.k2 - 1] = b[k1 - 1];
                                            } while ((k1 -= inc) != kk);
                                            do {
                                                k1 = kk + kspan;
                                                k2 = k1 - jc * (currentFactor + np[currentFactor - 1]);
                                                currentFactor = -np[currentFactor - 1];
                                                do {
                                                    a[FFTMixedRadix.k1 - 1] = a[k2 - 1];
                                                    b[FFTMixedRadix.k1 - 1] = b[k2 - 1];
                                                    k2 -= inc;
                                                } while ((k1 -= inc) != kk);
                                                kk = k2;
                                            } while (currentFactor != jCount);
                                            k1 = kk + kspan;
                                            k2 = 0;
                                            do {
                                                a[FFTMixedRadix.k1 - 1] = at[++k2 - 1];
                                                b[FFTMixedRadix.k1 - 1] = bt[k2 - 1];
                                            } while ((k1 -= inc) != kk);
                                        } while (jj != 0);
                                        if (jCount != 1) {
                                            bLoopLine924 = true;
                                            bJumpToLine924 = true;
                                        } else {
                                            bLoopLine924 = false;
                                            bJumpToLine924 = false;
                                        }
                                    }
                                }
                                if (!bJumpToLine950 && bJumpToLine924) continue;
                                bJumpToLine950 = false;
                                jCount = k3 + 1;
                                factInd = (nt -= kspnn) - inc + 1;
                                if (nt >= 0) {
                                    bLoopLine924 = true;
                                    bJumpToLine924 = true;
                                    continue;
                                }
                                bLoopLine924 = false;
                                bJumpToLine924 = false;
                            } while (bLoopLine924);
                        } while (bLoopLine904);
                    } while (bLoopLine902);
                } while (bLoopLine510);
            } while (bLoopLine320);
        } while (bLoopLine100);
    }

    public static void test_fft_ifft_real_random() {
        int i;
        int totalPoints = (int)(10.0 * Math.random() + 50.0);
        int[] numPoints = new int[totalPoints];
        for (i = 0; i < totalPoints; ++i) {
            numPoints[i] = (int)(6000.0 * Math.random() + 23.0);
        }
        for (i = 0; i < totalPoints; ++i) {
            int fftSize = numPoints[i] + (int)(100.0 * Math.random());
            int ifftSize = numPoints[i] + (int)(100.0 * Math.random());
            double[] x = new double[numPoints[i]];
            for (int j = 0; j < numPoints[i]; ++j) {
                x[j] = 40000.0 * (Math.random() - 0.5);
            }
            ComplexArray h = FFTMixedRadix.fftReal(x, numPoints[i], fftSize);
            String strMessage = fftSize + "-point FFT computed from " + numPoints[i] + " random real values...";
            System.out.println(strMessage);
            double[] y = FFTMixedRadix.ifftReal(h, ifftSize);
            strMessage = ifftSize + "-point IFFT computed...";
            System.out.println(strMessage);
            for (int j = 0; j < numPoints[i]; ++j) {
                if (!(Math.abs(x[j] - y[j]) > 1.0E-4)) continue;
                System.out.println("Detected difference...");
            }
            strMessage = "Test #" + (i + 1) + " of " + totalPoints + " complete for " + numPoints[i] + " random values...\n";
            System.out.println(strMessage);
        }
    }

    public static void main(String[] args) {
        FFTMixedRadix.test_fft_ifft_real_random();
    }
}

