/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.signal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.filter.BandPassFilter;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.filter.HighPassFilter;
import marytts.signalproc.filter.LowPassFilter;
import marytts.signalproc.filter.RecursiveFilter;
import marytts.signalproc.window.BartlettWindow;
import marytts.signalproc.window.BlackmanWindow;
import marytts.signalproc.window.FlattopWindow;
import marytts.signalproc.window.GaussWindow;
import marytts.signalproc.window.HammingWindow;
import marytts.signalproc.window.HanningWindow;
import marytts.signalproc.window.RectWindow;
import marytts.signalproc.window.Window;
import marytts.util.data.AlignLabelsUtils;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.display.DisplayUtils;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFT;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.MathUtils;
import marytts.util.string.StringUtils;

public class SignalProcUtils {
    public static int getLPOrder(int fs) {
        int P = (int)((float)fs / 1000.0f + 2.0f);
        if (P % 2 == 1) {
            ++P;
        }
        return P;
    }

    public static int getDFTSize(int fs) {
        int dftSize = fs <= 8000 ? 128 : (fs <= 16000 ? 256 : (fs <= 22050 ? 512 : (fs <= 32000 ? 1024 : (fs <= 44100 ? 2048 : 4096))));
        return dftSize;
    }

    public static int getFIRFilterOrder(int fs) {
        int oddFilterOrder = SignalProcUtils.getDFTSize(fs) - 1;
        if (oddFilterOrder % 2 == 0) {
            ++oddFilterOrder;
        }
        return oddFilterOrder;
    }

    public static int getLifterOrder(int fs) {
        int lifterOrder = 2 * (int)((float)fs / 1000.0f + 2.0f);
        if (lifterOrder % 2 == 1) {
            ++lifterOrder;
        }
        return lifterOrder;
    }

    public static int halfSpectrumSize(int fftSize) {
        return (int)Math.floor((double)fftSize / 2.0 + 1.5);
    }

    public static int fullSpectrumSize(int maxFreq) {
        return 2 * (maxFreq - 1);
    }

    public static double getEnergydB(double x) {
        double[] y = new double[]{x};
        return SignalProcUtils.getEnergydB(y);
    }

    public static double getEnergydB(double[] x) {
        return SignalProcUtils.getEnergydB(x, x.length);
    }

    public static double getEnergydB(double[] x, int len) {
        return SignalProcUtils.getEnergydB(x, len, 0);
    }

    public static double getEnergydB(double[] x, int len, int start) {
        return 10.0 * Math.log10(SignalProcUtils.getEnergy(x, len, start));
    }

    public static double getEnergy(double[] x, int len, int start) {
        if (start < 0) {
            start = 0;
        }
        if (start > x.length - 1) {
            start = x.length - 1;
        }
        if (start + len > x.length) {
            len = x.length - start - 1;
        }
        double en = 0.0;
        for (int i = start; i < start + len; ++i) {
            en += x[i] * x[i];
        }
        en = Math.sqrt(en);
        en = Math.max(en, 1.0E-100);
        return en;
    }

    public static double getEnergy(double[] x, int len) {
        return SignalProcUtils.getEnergy(x, len, 0);
    }

    public static double getEnergy(double[] x) {
        return SignalProcUtils.getEnergy(x, x.length, 0);
    }

    public static double getAverageSampleEnergy(double[] x, int len, int start) {
        if (start < 0) {
            start = 0;
        }
        if (start > x.length - 1) {
            start = x.length - 1;
        }
        if (start + len > x.length) {
            len = x.length - start - 1;
        }
        double avgSampEn = 0.0;
        for (int i = start; i < start + len; ++i) {
            avgSampEn += x[i] * x[i];
        }
        avgSampEn = Math.sqrt(avgSampEn);
        return avgSampEn /= (double)len;
    }

    public static double getAverageSampleEnergy(double[] x, int len) {
        return SignalProcUtils.getAverageSampleEnergy(x, len, 0);
    }

    public static double getAverageSampleEnergy(double[] x) {
        return SignalProcUtils.getAverageSampleEnergy(x, x.length, 0);
    }

    public static double[] normalizeAverageSampleEnergy(double[] x, double newAverageSampleEnergy) {
        double gain = newAverageSampleEnergy / (1.0E-20 + SignalProcUtils.getAverageSampleEnergy(x));
        return MathUtils.multiply(x, gain);
    }

    public static double[] getEnergyContourRms(double[] x, double windowSizeInSeconds, double skipSizeInSeconds, int samplingRate) {
        int ws = (int)Math.floor(windowSizeInSeconds * (double)samplingRate + 0.5);
        int ss = (int)Math.floor(skipSizeInSeconds * (double)samplingRate + 0.5);
        int numfrm = (int)Math.floor(((double)x.length - (double)ws) / (double)ss + 0.5);
        double[] energies = null;
        if (numfrm > 0) {
            energies = new double[numfrm];
            double[] frm = new double[ws];
            for (int i = 0; i < numfrm; ++i) {
                Arrays.fill(frm, 0.0);
                System.arraycopy(x, i * ss, frm, 0, Math.min(ws, x.length - i * ss));
                energies[i] = 0.0;
                for (int j = 0; j < ws; ++j) {
                    int n = i;
                    energies[n] = energies[n] + frm[j] * frm[j];
                }
                int n = i;
                energies[n] = energies[n] / (double)ws;
                energies[i] = Math.sqrt(energies[i]);
                energies[i] = MathUtils.amp2db(energies[i] + 1.0E-20);
            }
        }
        return energies;
    }

    public static float[] getAverageSampleEnergyContour(double[] x, double windowSizeInSeconds, double skipSizeInSeconds, int samplingRate) {
        int ws = (int)Math.floor(windowSizeInSeconds * (double)samplingRate + 0.5);
        int ss = (int)Math.floor(skipSizeInSeconds * (double)samplingRate + 0.5);
        int numfrm = (int)Math.floor(((double)x.length - (double)ws) / (double)ss + 0.5);
        float[] averageSampleEnergies = null;
        if (numfrm > 0) {
            averageSampleEnergies = new float[numfrm];
            double[] frm = new double[ws];
            for (int i = 0; i < numfrm; ++i) {
                Arrays.fill(frm, 0.0);
                System.arraycopy(x, i * ss, frm, 0, Math.min(ws, x.length - i * ss));
                averageSampleEnergies[i] = (float)SignalProcUtils.getAverageSampleEnergy(frm);
            }
        }
        return averageSampleEnergies;
    }

    public static float[] getAverageSampleEnergyContour(double[] x, float[] times, int samplingRateInHz, float windowDurationInSeconds) {
        float[] averageSampleEnergies = null;
        if (x != null && times != null) {
            averageSampleEnergies = new float[times.length];
            for (int i = 0; i < times.length; ++i) {
                int len;
                averageSampleEnergies[i] = 0.0f;
                if (!(times[i] > -1.0f)) continue;
                int startInd = SignalProcUtils.time2sample(Math.max(0.0f, times[i] - 0.5f * windowDurationInSeconds), samplingRateInHz);
                int endInd = SignalProcUtils.time2sample((double)times[i] + 0.5 * (double)windowDurationInSeconds, samplingRateInHz);
                if (endInd > x.length - 1) {
                    endInd = x.length - 1;
                }
                if ((len = endInd - startInd + 1) <= 0) continue;
                double[] frm = new double[len];
                System.arraycopy(x, startInd, frm, 0, len);
                averageSampleEnergies[i] = (float)SignalProcUtils.getAverageSampleEnergy(frm);
            }
        }
        return averageSampleEnergies;
    }

    public static double[] normalizeAverageSampleEnergyContour(double[] x, float[] times, float[] currentContour, float[] targetContour, int samplingRateInHz, float windowDurationInSeconds) {
        Object averageSampleEnergies = null;
        double[] y = null;
        if (x != null && times != null) {
            y = ArrayUtils.copy(x);
            int n = 0;
            while (n < y.length) {
                float t = SignalProcUtils.sample2time(n, samplingRateInHz);
                int ind = MathUtils.findClosest(times, t);
                float gain = 1.0f;
                if (currentContour[ind] > 0.0f && times[ind] > -1.0f) {
                    gain = t < times[ind] && ind > 0 && currentContour[ind - 1] > 0.0f && times[ind - 1] > -1.0f ? MathUtils.linearMap(t, times[ind - 1], times[ind], targetContour[ind - 1] / currentContour[ind - 1], targetContour[ind] / currentContour[ind]) : (t > times[ind] && ind < times.length - 1 && currentContour[ind + 1] > 0.0f && times[ind + 1] > -1.0f ? MathUtils.linearMap(t, times[ind], times[ind + 1], targetContour[ind] / currentContour[ind], targetContour[ind + 1] / currentContour[ind + 1]) : targetContour[ind] / currentContour[ind]);
                }
                int n2 = n++;
                y[n2] = y[n2] * (double)gain;
            }
        }
        return y;
    }

    public static double[] reverse(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[x.length - i - 1];
        }
        return y;
    }

    public static boolean[] getVuvs(double[] f0s) {
        if (f0s != null) {
            boolean[] vuvs = new boolean[f0s.length];
            for (int i = 0; i < vuvs.length; ++i) {
                vuvs[i] = !(f0s[i] < 10.0);
            }
            return vuvs;
        }
        return null;
    }

    public static PitchMarks pitchContour2pitchMarks(double[] f0s, int fs, int len, double ws, double ss, boolean bPaddZerosForFinalPitchMark, int offset) {
        double[] interpf0s = SignalProcUtils.interpolate_pitch_uv(f0s);
        int numfrm = f0s.length;
        int maxTotalPitchMarks = len;
        int[] tmpPitchMarks = MathUtils.zerosInt(maxTotalPitchMarks);
        float[] tmpF0s = new float[maxTotalPitchMarks];
        int count = 0;
        int prevInd = 1;
        assert (offset >= 0);
        for (int i = 1; i <= len; ++i) {
            int ind = (int)(Math.floor((((double)i - 1.0) / (double)fs - 0.5 * ws) / ss + 0.5) + 1.0);
            if (ind < 1) {
                ind = 1;
            }
            if (ind > numfrm) {
                ind = numfrm;
            }
            double T0 = interpf0s[ind - 1] > 10.0 ? (double)fs / interpf0s[ind - 1] : (double)((float)fs / 100.0f);
            if (i != 1 && !((double)i - T0 >= (double)prevInd)) continue;
            tmpPitchMarks[++count - 1] = i - 1 + offset;
            prevInd = i;
            if (i <= 1) continue;
            tmpF0s[count - 2] = (float)f0s[ind - 1];
        }
        PitchMarks pm = null;
        if (count > 1) {
            if (bPaddZerosForFinalPitchMark && tmpPitchMarks[count - 1] != len - 1) {
                pm = new PitchMarks(count + 1, tmpPitchMarks, tmpF0s, 0);
                pm.pitchMarks[pm.pitchMarks.length - 1] = pm.pitchMarks[pm.pitchMarks.length - 2] + (pm.pitchMarks[pm.pitchMarks.length - 2] - pm.pitchMarks[pm.pitchMarks.length - 3]);
                pm.totalZerosToPadd = pm.pitchMarks[pm.pitchMarks.length - 1] - (len - 1);
            } else {
                pm = new PitchMarks(count, tmpPitchMarks, tmpF0s, 0);
            }
        }
        return pm;
    }

    public static double[] pitchMarks2PitchContour(int[] pitchMarks, float ws, float ss, int samplingRate) {
        double[] f0s = null;
        float[] times = SignalProcUtils.samples2times(pitchMarks, samplingRate);
        int numfrm = (int)Math.floor(((double)times[times.length - 1] - 0.5 * (double)ws) / (double)ss + 0.5);
        if (numfrm > 0) {
            f0s = new double[numfrm];
            for (int i = 0; i < numfrm; ++i) {
                float currentTime = (float)i * ss + 0.5f * ws;
                int currentInd = MathUtils.findClosest(times, currentTime);
                f0s[i] = currentInd > 0 ? 1.0 / (double)(times[currentInd] - times[currentInd - 1]) : 1.0 / (double)times[currentInd];
            }
        }
        return f0s;
    }

    public static double[] fixedRateF0Values(PitchMarks pm, double wsFixedInSeconds, double ssFixedInSeconds, int numfrm, int samplingRate) {
        double[] f0s = new double[numfrm];
        for (int i = 0; i < numfrm; ++i) {
            boolean isVoiced;
            int sample = SignalProcUtils.time2sample((float)((double)i * ssFixedInSeconds + 0.5 * wsFixedInSeconds), samplingRate);
            int ind = MathUtils.findClosest(pm.pitchMarks, sample);
            f0s[i] = 0.0;
            if (ind < 0) {
                ind = sample > pm.pitchMarks[pm.pitchMarks.length - 1] ? pm.pitchMarks.length - 1 : 1;
            }
            boolean bl = isVoiced = (double)pm.f0s[ind - 1] > 10.0;
            if (!isVoiced) continue;
            f0s[i] = ind > 0 ? (double)samplingRate / (double)(pm.pitchMarks[ind] - pm.pitchMarks[ind - 1]) : (double)samplingRate / (double)(pm.pitchMarks[ind + 1] - pm.pitchMarks[ind]);
        }
        return f0s;
    }

    public static double[] interpolate_pitch_uv(double[] f0s) {
        return SignalProcUtils.interpolate_pitch_uv(f0s, 10.0);
    }

    public static double[] interpolate_pitch_uv(double[] f0s, double minVoicedVal) {
        int[] ind_v = MathUtils.find(f0s, 1, minVoicedVal);
        double[] new_f0s = null;
        if (ind_v == null) {
            new_f0s = new double[f0s.length];
            System.arraycopy(f0s, 0, new_f0s, 0, f0s.length);
        } else {
            int i;
            double[] tmp_f0s = new double[f0s.length];
            System.arraycopy(f0s, 0, tmp_f0s, 0, f0s.length);
            int[] ind_v2 = null;
            if (ind_v[0] != 0) {
                tmp_f0s[0] = MathUtils.mean(f0s, ind_v);
                ind_v2 = new int[ind_v.length + 1];
                ind_v2[0] = 0;
                System.arraycopy(ind_v, 0, ind_v2, 1, ind_v.length);
            } else {
                ind_v2 = new int[ind_v.length];
                System.arraycopy(ind_v, 0, ind_v2, 0, ind_v.length);
            }
            int[] ind_v3 = null;
            if (ind_v2[ind_v2.length - 1] != tmp_f0s.length - 1) {
                tmp_f0s[tmp_f0s.length - 1] = tmp_f0s[ind_v2[ind_v2.length - 1]];
                ind_v3 = new int[ind_v2.length + 1];
                System.arraycopy(ind_v2, 0, ind_v3, 0, ind_v2.length);
                ind_v3[ind_v2.length] = f0s.length - 1;
            } else {
                ind_v3 = new int[ind_v2.length];
                System.arraycopy(ind_v2, 0, ind_v3, 0, ind_v2.length);
            }
            double[] y = new double[ind_v3.length];
            for (i = 0; i < ind_v3.length; ++i) {
                y[i] = tmp_f0s[ind_v3[i]];
            }
            int[] xi = new int[f0s.length];
            for (i = 0; i < f0s.length; ++i) {
                xi[i] = i;
            }
            new_f0s = MathUtils.interpolate_linear(ind_v3, y, xi);
        }
        return new_f0s;
    }

    public static double[] getContourLSFit(double[] contour, boolean isPitchUVInterpolation) {
        double[] line = null;
        if (contour != null) {
            double[] newContour = new double[contour.length];
            System.arraycopy(contour, 0, newContour, 0, contour.length);
            if (isPitchUVInterpolation) {
                newContour = SignalProcUtils.interpolate_pitch_uv(newContour);
            }
            double[] indices = new double[contour.length];
            for (int i = 0; i < contour.length; ++i) {
                indices[i] = i;
            }
            line = SignalProcUtils.fitLeastSquaresLine(indices, newContour);
        }
        return line;
    }

    public static double[] fitLeastSquaresLine(double[] x, double[] y) {
        assert (x != null);
        assert (y != null);
        assert (x.length == y.length);
        double[] params = new double[2];
        double sx = 0.0;
        double sy = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        int numPoints = x.length;
        for (int i = 0; i < numPoints; ++i) {
            sx += x[i];
            sy += y[i];
            sxx += x[i] * x[i];
            sxy += x[i] * y[i];
        }
        double delta = (double)numPoints * sxx - sx * sx;
        params[0] = (sxx * sy - sx * sxy) / delta;
        params[1] = ((double)numPoints * sxy - sx * sy) / delta;
        return params;
    }

    public static boolean getVoicing(double[] windowedSpeechFrame, int samplingRateInHz) {
        return SignalProcUtils.getVoicing(windowedSpeechFrame, samplingRateInHz, 0.35f);
    }

    public static boolean getVoicing(double[] windowedSpeechFrame, int samplingRateInHz, double voicingThreshold) {
        double Pvoiced = SignalProcUtils.getVoicingProbability(windowedSpeechFrame, samplingRateInHz);
        return Pvoiced >= voicingThreshold;
    }

    public static double getVoicingProbability(double[] windowedSpeechFrame, int samplingRateInHz) {
        int maxT0 = (int)((double)samplingRateInHz / 40.0);
        int minT0 = (int)((double)samplingRateInHz / 400.0);
        if (maxT0 > windowedSpeechFrame.length - 1) {
            maxT0 = windowedSpeechFrame.length - 1;
        }
        if (minT0 > maxT0) {
            minT0 = maxT0;
        }
        double[] R = SignalProcUtils.autocorr(windowedSpeechFrame, maxT0);
        double maxR = R[minT0];
        for (int i = minT0 + 1; i <= maxT0; ++i) {
            if (!(R[i] > maxR)) continue;
            maxR = R[i];
        }
        double Pvoiced = maxR / R[0];
        return Pvoiced;
    }

    public static double[] autocorr(double[] x, int LPOrder) {
        int N = x.length;
        double[] R = new double[LPOrder + 1];
        for (int m = 0; m <= LPOrder; ++m) {
            R[m] = 0.0;
            for (int n = 0; n <= x.length - m - 1; ++n) {
                int n2 = m;
                R[n2] = R[n2] + x[n] * x[n + m];
            }
        }
        return R;
    }

    public static double[] applyPreemphasis(double[] frm, double preCoef) {
        double[] frmOut = new double[frm.length];
        System.arraycopy(frm, 0, frmOut, 0, frm.length);
        if (preCoef > 0.0) {
            double[] coeffs = new double[]{1.0, -preCoef};
            RecursiveFilter r = new RecursiveFilter(coeffs);
            r.apply(frmOut);
        }
        return frmOut;
    }

    public static double[] removePreemphasis(double[] frm, double preCoef) {
        double[] frmOut = null;
        if (frm != null && frm.length > 0) {
            frmOut = new double[frm.length];
            System.arraycopy(frm, 0, frmOut, 0, frm.length);
            if (preCoef > 0.0) {
                double[] coeffs = new double[]{1.0, preCoef};
                RecursiveFilter r = new RecursiveFilter(coeffs);
                r.apply(frmOut);
            }
        }
        return frmOut;
    }

    public static double[] freq2bark(double[] freqsInHz) {
        double[] barks = null;
        if (freqsInHz != null) {
            barks = new double[freqsInHz.length];
            for (int i = 0; i < barks.length; ++i) {
                barks[i] = SignalProcUtils.freq2bark(freqsInHz[i]);
            }
        }
        return barks;
    }

    public static double freq2bark(double freqInHz) {
        return 13.0 * Math.atan(7.6E-4 * freqInHz) + 3.5 * Math.atan(freqInHz * freqInHz / 5.625E7);
    }

    public static double hz2bark(double freqInHz) {
        double f = freqInHz / 600.0;
        return 6.0 * Math.log(f + Math.sqrt(f * f + 1.0));
    }

    public static double freq2barkNew(double freqInHz) {
        if (freqInHz >= 605.0) {
            return 13.0 * Math.atan(7.6E-4 * freqInHz);
        }
        return 8.7 + 14.2 * Math.log10(1.0E-50 + freqInHz / 1000.0);
    }

    public static double barkNew2freq(double barkNew) {
        if (barkNew >= 5.6017) {
            return Math.tan(barkNew / 13.0) / 7.6E-4;
        }
        return 1000.0 * Math.pow(10.0, (barkNew - 8.7) / 14.2);
    }

    public static double[] bark2freq(double[] barks, int samplingRateInHz) {
        double[] freqsInHz = new double[barks.length];
        for (int i = 0; i < barks.length; ++i) {
            freqsInHz[i] = SignalProcUtils.bark2freq(barks[i], samplingRateInHz);
        }
        return freqsInHz;
    }

    public static double bark2freq(double bark, int samplingRateInHz) {
        double midFreqInHz = 0.25 * (double)samplingRateInHz;
        double stepInHz = 0.125 * (double)samplingRateInHz;
        double midFreqInBark = SignalProcUtils.freq2bark(midFreqInHz);
        while (Math.abs(midFreqInBark - bark) > 1.0E-10) {
            midFreqInHz = midFreqInBark < bark ? (midFreqInHz += stepInHz) : (midFreqInHz -= stepInHz);
            stepInHz *= 0.5;
            midFreqInBark = SignalProcUtils.freq2bark(midFreqInHz);
        }
        return midFreqInHz;
    }

    public static double barkNew2radian(double bark, int samplingRateInHz) {
        return SignalProcUtils.hz2radian(SignalProcUtils.barkNew2freq(bark), samplingRateInHz);
    }

    public static double[][] fft2barkmx(int nfft, int sr, int nfilts, int width, double minfreq, double maxfreq) {
        int i;
        double min_bark = SignalProcUtils.hz2bark(minfreq);
        double nyqbark = SignalProcUtils.hz2bark(maxfreq) - min_bark;
        double[][] wts = new double[nfilts][nfft];
        for (i = 0; i < nfilts; ++i) {
            wts[i] = MathUtils.zeros(nfft);
        }
        double step_barks = nyqbark / (double)(nfilts - 1);
        int halfNfft = nfft / 2;
        double[] binbarks = new double[halfNfft + 1];
        for (i = 0; i < halfNfft + 1; ++i) {
            binbarks[i] = SignalProcUtils.hz2bark(i * sr / nfft);
        }
        double[] lof = new double[halfNfft + 1];
        double[] hif = new double[halfNfft + 1];
        for (i = 1; i <= nfilts; ++i) {
            double f_bark_mid = min_bark + (double)(i - 1) * step_barks;
            for (int j = 0; j < halfNfft + 1; ++j) {
                lof[j] = (binbarks[j] - f_bark_mid) / (double)width - 0.5;
                hif[j] = (binbarks[j] - f_bark_mid) / (double)width + 0.5;
            }
            for (int k = 0; k < halfNfft + 1; ++k) {
                double aux = Math.min(0.0, Math.min(hif[k], -2.5 * lof[k]));
                wts[i - 1][k] = Math.pow(10.0, aux);
            }
        }
        return wts;
    }

    public static int[] freq2index(double[] freqsInHz, int samplingRateInHz, int maxFreq) {
        int[] inds = null;
        if (freqsInHz != null && freqsInHz.length > 0) {
            inds = new int[freqsInHz.length];
            for (int i = 0; i < inds.length; ++i) {
                inds[i] = SignalProcUtils.freq2index(freqsInHz[i], (double)samplingRateInHz, maxFreq);
            }
        }
        return inds;
    }

    public static int freq2index(double freqInHz, double samplingRateInHz, int maxFreqIndex) {
        int index = (int)Math.floor(freqInHz / (0.5 * samplingRateInHz) * (double)(maxFreqIndex - 1) + 0.5);
        index = Math.max(0, index);
        index = Math.min(index, maxFreqIndex);
        return index;
    }

    public static double[] freq2indexDouble(double[] freqsInHz, double samplingRateInHz, int maxFreq) {
        double[] inds = null;
        if (freqsInHz != null && freqsInHz.length > 0) {
            inds = new double[freqsInHz.length];
            for (int i = 0; i < inds.length; ++i) {
                inds[i] = SignalProcUtils.freq2indexDouble(freqsInHz[i], samplingRateInHz, maxFreq);
            }
        }
        return inds;
    }

    public static double freq2indexDouble(double freqInHz, double samplingRateInHz, int maxFreqIndex) {
        double index = freqInHz / (0.5 * samplingRateInHz) * (double)(maxFreqIndex - 1);
        index = Math.max(0.0, index);
        index = Math.min(index, (double)maxFreqIndex);
        return index;
    }

    public static double index2freq(int zeroBasedFreqIndex, int samplingRateInHz, int zeroBasedMaxFreqIndex) {
        return (double)zeroBasedFreqIndex * (0.5 * (double)samplingRateInHz) / (double)zeroBasedMaxFreqIndex;
    }

    public static double indexDouble2freq(double zeroBasedFreqIndex, int samplingRateInHz, int zeroBasedMaxFreqIndex) {
        return zeroBasedFreqIndex * (0.5 * (double)samplingRateInHz) / (double)zeroBasedMaxFreqIndex;
    }

    public static float sample2time(int sample, int samplingRate) {
        return (float)sample / (float)samplingRate;
    }

    public static float sampleFloat2time(float sample, int samplingRate) {
        return sample / (float)samplingRate;
    }

    public static float sample2time(long sample, int samplingRate) {
        return (float)((double)sample / (double)samplingRate);
    }

    public static float sample2time(float sample, int samplingRate) {
        return sample / (float)samplingRate;
    }

    public static int time2sample(float time, int samplingRate) {
        return (int)Math.floor(time * (float)samplingRate + 0.5f);
    }

    public static int[] time2sample(float[] times, int samplingRate) {
        int[] samples = null;
        if (times != null && times.length > 0) {
            samples = new int[times.length];
            for (int i = 0; i < times.length; ++i) {
                samples[i] = SignalProcUtils.time2sample(times[i], samplingRate);
            }
        }
        return samples;
    }

    public static int time2sample(double time, int samplingRate) {
        return (int)Math.floor(time * (double)samplingRate + 0.5);
    }

    public static int[] time2sample(double[] times, int samplingRate) {
        int[] samples = null;
        if (times != null && times.length > 0) {
            samples = new int[times.length];
            for (int i = 0; i < times.length; ++i) {
                samples[i] = SignalProcUtils.time2sample(times[i], samplingRate);
            }
        }
        return samples;
    }

    public static double time2sampleDouble(double time, int samplingRate) {
        return time * (double)samplingRate;
    }

    public static float[] samples2times(int[] samples, int samplingRate) {
        float[] times = null;
        if (samples != null && samples.length > 0) {
            times = new float[samples.length];
            for (int i = 0; i < samples.length; ++i) {
                times[i] = (float)samples[i] / (float)samplingRate;
            }
        }
        return times;
    }

    public static int[] times2samples(float[] times, int samplingRate) {
        int[] samples = null;
        if (times != null && times.length > 0) {
            samples = new int[times.length];
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = (int)Math.floor(times[i] * (float)samplingRate + 0.5f);
            }
        }
        return samples;
    }

    public static float timeScaledTime(float t, float[] scales, float[] times) {
        assert (scales != null);
        if (times != null) assert (scales.length == times.length);
        int N = scales.length;
        float tNew = t;
        if (N > 0) {
            if (times == null || t <= times[0]) {
                tNew = t * scales[0];
            } else {
                int ind = -1;
                int i = 0;
                while (i < N && t > times[i]) {
                    ind = i++;
                }
                if (ind == -1) {
                    tNew = scales[0] * t;
                } else {
                    tNew = scales[0] * times[0];
                    for (i = 0; i < ind; ++i) {
                        tNew += scales[i + 1] * (times[i + 1] - times[i]);
                    }
                    tNew += scales[ind] * (t - times[ind]);
                }
            }
        }
        return tNew;
    }

    public static float[] timeScaledTimes(float[] times, float[] tScales, float[] tScalesTimes) {
        float[] newTimes = null;
        if (times != null && times.length > 0) {
            newTimes = new float[times.length];
            for (int i = 0; i < times.length; ++i) {
                newTimes[i] = SignalProcUtils.timeScaledTime(times[i], tScales, tScalesTimes);
            }
        }
        return newTimes;
    }

    public static double[] timeScalePitchContour(double[] f0s, float ws, float ss, float[] tScales, float[] tScalesTimes) {
        int i;
        if (tScales == null || tScalesTimes == null) {
            return f0s;
        }
        assert (tScales.length == tScalesTimes.length);
        float[] times = new float[f0s.length];
        for (i = 0; i < f0s.length; ++i) {
            times[i] = (float)i * ss + 0.5f * ws;
        }
        float[] newTimes = SignalProcUtils.timeScaledTimes(times, tScales, tScalesTimes);
        int numfrm = (int)Math.floor(((double)newTimes[newTimes.length - 1] - 0.5 * (double)ws) / (double)ss + 0.5);
        double[] f0sNew = new double[numfrm];
        for (i = 0; i < numfrm; ++i) {
            int ind = MathUtils.findClosest(newTimes, (float)i * ss + 0.5f * ws);
            f0sNew[i] = f0s[ind];
        }
        return f0sNew;
    }

    public static double[] pitchScalePitchContour(double[] f0s, float ws, float ss, float[] pScales, float[] pScalesTimes) {
        if (pScales == null || pScalesTimes == null) {
            return f0s;
        }
        assert (pScales.length == pScalesTimes.length);
        double[] f0sNew = new double[f0s.length];
        for (int i = 0; i < f0s.length; ++i) {
            float currentTime = (float)i * ss + 0.5f * ws;
            int smallerCloseInd = MathUtils.findClosest(pScalesTimes, currentTime);
            if (pScalesTimes[smallerCloseInd] > currentTime) {
                --smallerCloseInd;
            }
            if (smallerCloseInd >= 0 && smallerCloseInd < pScales.length - 1) {
                float alpha = (pScalesTimes[smallerCloseInd + 1] - currentTime) / (pScalesTimes[smallerCloseInd + 1] - pScalesTimes[smallerCloseInd]);
                f0sNew[i] = (double)(alpha * pScales[smallerCloseInd] + (1.0f - alpha) * pScales[smallerCloseInd + 1]) * f0s[i];
                continue;
            }
            smallerCloseInd = Math.max(0, smallerCloseInd);
            smallerCloseInd = Math.min(smallerCloseInd, pScales.length - 1);
            f0sNew[i] = (double)pScales[smallerCloseInd] * f0s[i];
        }
        return f0sNew;
    }

    public static double[] getNoise(double startFreqInHz, double endFreqInHz, double transitionBandwidthInHz, int samplingRateInHz, int len) {
        return SignalProcUtils.getNoiseNormalizedFreqs(startFreqInHz / (double)samplingRateInHz, endFreqInHz / (double)samplingRateInHz, transitionBandwidthInHz / (double)samplingRateInHz, len);
    }

    public static double[] getNoiseNormalizedFreqs(double normalizedStartFreq, double normalizedEndFreq, double normalizedTransitionBandwidth, int len) {
        double[] noise = null;
        if (len > 0) {
            FIRFilter f = null;
            int origLen = len;
            noise = new double[origLen];
            if (normalizedStartFreq != 0.0 || normalizedEndFreq != 0.5) {
                if (normalizedStartFreq > 0.0 && normalizedEndFreq < 0.5) {
                    f = new BandPassFilter(normalizedStartFreq, normalizedEndFreq, normalizedTransitionBandwidth);
                } else if (normalizedStartFreq > 0.0) {
                    f = new HighPassFilter(normalizedStartFreq, normalizedTransitionBandwidth);
                } else if (normalizedEndFreq < 0.5) {
                    f = new LowPassFilter(normalizedEndFreq, normalizedTransitionBandwidth);
                }
                origLen = len;
                len += 3 * f.getImpulseResponseLength();
            }
            if (f == null) {
                for (int i = 0; i < origLen; ++i) {
                    noise[i] = Math.random() - 0.5;
                }
                return noise;
            }
            double[] noise2 = new double[len];
            for (int i = 0; i < len; ++i) {
                noise2[i] = Math.random() - 0.5;
            }
            noise2 = f.apply(noise2);
            System.arraycopy(noise2, f.getImpulseResponseLength(), noise, 0, origLen);
        }
        return noise;
    }

    public static float radian2hz(float rad, int samplingRate) {
        return (float)((double)rad / (Math.PI * 2) * (double)samplingRate);
    }

    public static double radian2hz(double rad, int samplingRate) {
        return rad / (Math.PI * 2) * (double)samplingRate;
    }

    public static float hz2radian(float hz, int samplingRate) {
        return (float)((double)hz * (Math.PI * 2) / (double)samplingRate);
    }

    public static double hz2radian(double hz, int samplingRate) {
        return hz * (Math.PI * 2) / (double)samplingRate;
    }

    public static double[] medianFilter(double[] x) {
        return SignalProcUtils.medianFilter(x, 3);
    }

    public static float[] medianFilter(float[] x) {
        return SignalProcUtils.medianFilter(x, 3);
    }

    public static float[] medianFilter(float[] x, int N) {
        int i;
        double[] x2 = new double[x.length];
        for (i = 0; i < x.length; ++i) {
            x2[i] = x[i];
        }
        x2 = SignalProcUtils.medianFilter(x2, N);
        float[] y = new float[x.length];
        for (i = 0; i < x.length; ++i) {
            y[i] = (float)x2[i];
        }
        return y;
    }

    public static double[] medianFilter(double[] x, int N) {
        double[] y = new double[x.length];
        Vector<Double> v = new Vector<Double>();
        if (N % 2 == 1) {
            int midVal = (N - 1) / 2;
            for (int k = 0; k < x.length; ++k) {
                int iLeft = Math.max(0, k - midVal);
                int iRight = Math.min(x.length - 1, iLeft + N);
                for (int j = iLeft; j <= iRight; ++j) {
                    v.add(x[j]);
                }
                Collections.sort(v);
                y[k] = (Double)v.get(midVal);
                v.clear();
            }
        } else {
            int midVal = N / 2 - 1;
            for (int k = 0; k < x.length; ++k) {
                int iLeft = Math.max(0, k - midVal);
                int iRight = Math.min(x.length - 1, k + midVal);
                for (int j = iLeft; j <= iRight; ++j) {
                    v.add(x[j]);
                }
                Collections.sort(v);
                y[k] = midVal + 1 < v.size() ? 0.5 * ((Double)v.get(midVal) + (Double)v.get(midVal + 1)) : (Double)v.get(midVal);
                v.clear();
            }
        }
        return y;
    }

    public static double[] meanFilter(double[] x, int N) {
        return SignalProcUtils.meanFilter(x, N, x[0], x[x.length - 1]);
    }

    public static float[] meanFilter(float[] x, int N) {
        return SignalProcUtils.meanFilter(x, N, x[0], x[x.length - 1]);
    }

    public static float[] meanFilter(float[] x, int N, float leftOutOfBound, float rightOutOfBound) {
        double[] xd = ArrayUtils.copyFloat2Double(x);
        xd = SignalProcUtils.meanFilter(xd, N, (double)leftOutOfBound, (double)rightOutOfBound);
        return ArrayUtils.copyDouble2Float(xd);
    }

    public static double[] meanFilter(double[] x, int N, double leftOutOfBound, double rightOutOfBound) {
        double[] y = new double[x.length];
        Vector<Double> v = new Vector<Double>();
        if (N % 2 == 1) {
            int midVal = (N - 1) / 2;
            for (int k = 0; k < x.length; ++k) {
                int j;
                for (j = 0; j < midVal; ++j) {
                    if (k - j >= 0) {
                        v.add(x[k - j]);
                        continue;
                    }
                    v.add(leftOutOfBound);
                }
                for (j = midVal; j < N; ++j) {
                    if (k + j < x.length) {
                        v.add(x[k + j]);
                        continue;
                    }
                    v.add(rightOutOfBound);
                }
                y[k] = SignalProcUtils.mean(v);
                v.clear();
            }
        } else {
            int midVal = N / 2 - 1;
            for (int k = 0; k < x.length; ++k) {
                int j;
                for (j = 0; j <= midVal; ++j) {
                    if (k - j >= 0) {
                        v.add(x[k - j]);
                        continue;
                    }
                    v.add(leftOutOfBound);
                }
                for (j = midVal + 1; j < N; ++j) {
                    if (k + j < x.length) {
                        v.add(x[k + j]);
                        continue;
                    }
                    v.add(rightOutOfBound);
                }
                y[k] = SignalProcUtils.mean(v);
                v.clear();
            }
        }
        return y;
    }

    public static double mean(Vector<Double> v) {
        double m = 0.0;
        for (int i = 0; i < v.size(); ++i) {
            m += v.get(i).doubleValue();
        }
        return m /= (double)v.size();
    }

    public static float frameIndex2Time(int zeroBasedFrameIndex, float windowSizeInSeconds, float skipSizeInSeconds) {
        return Math.max(0.0f, 0.5f * windowSizeInSeconds + (float)zeroBasedFrameIndex * skipSizeInSeconds);
    }

    public static double frameIndex2Time(int zeroBasedFrameIndex, double windowSizeInSeconds, double skipSizeInSeconds) {
        return Math.max(0.0, 0.5 * windowSizeInSeconds + (double)zeroBasedFrameIndex * skipSizeInSeconds);
    }

    public static int time2frameIndex(float time, float windowSizeInSeconds, float skipSizeInSeconds) {
        return (int)Math.max(0.0, Math.floor((double)((time - 0.5f * windowSizeInSeconds) / skipSizeInSeconds) + 0.5));
    }

    public static int time2frameIndex(double time, double windowSizeInSeconds, double skipSizeInSeconds) {
        return (int)Math.max(0.0, Math.floor((time - 0.5 * windowSizeInSeconds) / skipSizeInSeconds + 0.5));
    }

    public static void centerClip(double[] x, double ratio) {
        if (ratio < 0.0) {
            ratio = 0.0;
        }
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        double positiveMax = MathUtils.getMax(x);
        double negativeMax = MathUtils.getMin(x);
        double positiveTh = positiveMax * ratio;
        double negativeTh = negativeMax * ratio;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] > positiveTh) {
                int n = i;
                x[n] = x[n] - positiveTh;
                continue;
            }
            if (x[i] < negativeTh) {
                int n = i;
                x[n] = x[n] - negativeTh;
                continue;
            }
            x[i] = 0.0;
        }
    }

    public static double[] getVoiceds(double[] f0s) {
        double[] voiceds = null;
        if (f0s != null) {
            int i;
            int totalVoiceds = 0;
            for (i = 0; i < f0s.length; ++i) {
                if (!(f0s[i] > 10.0)) continue;
                ++totalVoiceds;
            }
            if (totalVoiceds > 0) {
                voiceds = new double[totalVoiceds];
                int count = 0;
                for (i = 0; i < f0s.length; ++i) {
                    if (f0s[i] > 10.0) {
                        voiceds[count++] = f0s[i];
                    }
                    if (count >= totalVoiceds) break;
                }
            }
        }
        return voiceds;
    }

    public static double[] getLogF0s(double[] f0s) {
        return MathUtils.log(f0s, 10.0, 0.0);
    }

    public static double[] getExpF0s(double[] logF0s) {
        double[] f0s = null;
        if (logF0s != null) {
            f0s = new double[logF0s.length];
            for (int i = 0; i < f0s.length; ++i) {
                f0s[i] = logF0s[i] > Math.log(10.0) ? Math.exp(logF0s[i]) : 0.0;
            }
        }
        return f0s;
    }

    public static double getF0Range(double[] f0s) {
        return SignalProcUtils.getF0Range(f0s, 0.1, 0.1);
    }

    public static double getF0Range(double[] f0s, double percentileMin, double percentileMax) {
        double range = 0.0;
        double[] voiceds = SignalProcUtils.getVoiceds(f0s);
        if (voiceds != null) {
            if (percentileMin < 0.0) {
                percentileMin = 0.0;
            }
            if (percentileMin > 1.0) {
                percentileMin = 1.0;
            }
            if (percentileMax < 0.0) {
                percentileMax = 0.0;
            }
            if (percentileMax > 1.0) {
                percentileMax = 1.0;
            }
            MathUtils.quickSort(voiceds);
            int ind1 = (int)Math.floor((double)voiceds.length * percentileMin + 0.5);
            int ind2 = (int)Math.floor((double)voiceds.length * (1.0 - percentileMax) + 0.5);
            range = Math.max(0.0, voiceds[ind2] - voiceds[ind1]);
        }
        return range;
    }

    public static int frameIndex2LabelIndex(int zeroBasedFrameIndex, Labels labels, double windowSizeInSeconds, double skipSizeInSeconds) {
        double time = (double)zeroBasedFrameIndex * skipSizeInSeconds + 0.5 * windowSizeInSeconds;
        return SignalProcUtils.time2LabelIndex(time, labels);
    }

    public static int time2LabelIndex(double time, Labels labels) {
        int index = 0;
        for (int i = 0; i < labels.items.length; ++i) {
            if (!(labels.items[i].time > time)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > labels.items.length - 1) {
            index = labels.items.length - 1;
        }
        return index;
    }

    public static double getRmsDistance(double[] x, double[] y) {
        double rmsDist = 0.0;
        for (int i = 0; i < Math.min(x.length, y.length); ++i) {
            rmsDist += (x[i] - y[i]) * (x[i] - y[i]);
        }
        rmsDist /= (double)Math.min(x.length, y.length);
        rmsDist = Math.sqrt(rmsDist);
        return rmsDist;
    }

    public static int[] merge(int[] x1, int[] x2) {
        int[] y = null;
        int ylen = 0;
        if (x1 != null) {
            ylen += x1.length;
        }
        if (x2 != null) {
            ylen += x2.length;
        }
        y = new int[ylen];
        int pos = 0;
        if (x1 != null) {
            System.arraycopy(x1, 0, y, 0, x1.length);
            pos += x1.length;
        }
        if (x2 != null) {
            System.arraycopy(x2, 0, y, pos, x2.length);
        }
        return y;
    }

    public static double[] merge(double[] x1, double[] x2) {
        double[] y = null;
        int ylen = 0;
        if (x1 != null) {
            ylen += x1.length;
        }
        if (x2 != null) {
            ylen += x2.length;
        }
        y = new double[ylen];
        int pos = 0;
        if (x1 != null) {
            System.arraycopy(x1, 0, y, 0, x1.length);
            pos += x1.length;
        }
        if (x2 != null) {
            System.arraycopy(x2, 0, y, pos, x2.length);
        }
        return y;
    }

    public static double[] decimate(double[] x, double D) {
        double[] y = null;
        if (x != null) {
            int ylen = (int)Math.floor((double)x.length / D + 0.5);
            y = new double[ylen];
            double dind = 0.5 * D;
            int total = 0;
            while (total < ylen) {
                int ind1 = (int)Math.floor(dind);
                int ind2 = ind1 + 1;
                if (ind2 > x.length - 1) {
                    ind2 = x.length - 1;
                }
                ind1 = ind2 - 1;
                y[total++] = ((double)ind2 - dind) * x[ind1] + (dind - (double)ind1) * x[ind2];
                dind += D;
            }
        }
        return y;
    }

    public static double[] interpolate(double[] x, double D) {
        double[] y = null;
        if (x != null) {
            int ylen = (int)Math.floor((double)x.length * D + 0.5);
            y = new double[ylen];
            for (int i = 0; i < ylen; ++i) {
                double xindDouble = (double)i / D;
                int xind = (int)Math.floor(xindDouble);
                y[i] = xind <= 0 ? ((double)xind - xindDouble) * (2.0 * x[0] - x[1]) + ((double)(1 - xind) + xindDouble) * x[xind] : (xind > x.length - 1 ? (x[x.length - 1] - x[x.length - 2]) * (xindDouble - (double)x.length + 1.0) + x[x.length - 1] : ((double)xind - xindDouble) * x[xind - 1] + ((double)(1 - xind) + xindDouble) * x[xind]);
            }
        }
        return y;
    }

    public static double energy(double[] x) {
        double e = 0.0;
        for (int i = 0; i < x.length; ++i) {
            e += x[i] * x[i];
        }
        return e;
    }

    public static double[] filter(double[] b, double[] x) {
        double[] a = new double[]{1.0};
        return SignalProcUtils.filter(b, a, x);
    }

    public static double[] filter(double[] b, double[] a, double[] x) {
        return SignalProcUtils.filter(b, a, x, false);
    }

    public static double[] filter(double[] b, double[] x, boolean bNormalize) {
        double[] a = new double[]{1.0};
        return SignalProcUtils.filter(b, a, x, bNormalize);
    }

    public static double[] filter(double[] b, double[] a, double[] x, boolean bNormalize) {
        double[] zi = new double[Math.max(a.length, b.length) - 1];
        Arrays.fill(zi, 0.0);
        return SignalProcUtils.filter(b, a, x, bNormalize, zi);
    }

    public static double[] filter(double[] b, double[] x, boolean bNormalize, double[] zi) {
        double[] a = new double[]{1.0};
        return SignalProcUtils.filter(b, a, x, bNormalize, zi);
    }

    public static double[] filter(double[] b, double[] a, double[] x, boolean bNormalize, double[] zi) {
        int n;
        double[] y = new double[x.length];
        int nb = b.length - 1;
        int na = a.length - 1;
        if (bNormalize && a[0] != 1.0) {
            n = 0;
            while (n < b.length) {
                int n2 = n++;
                b[n2] = b[n2] / a[0];
            }
            n = 0;
            while (n < a.length) {
                int n3 = n++;
                a[n3] = a[n3] / a[0];
            }
        }
        for (n = 0; n < x.length; ++n) {
            int ind;
            double x_terms = 0.0;
            for (ind = n; ind > n - nb - 1; --ind) {
                if (ind >= 0) {
                    x_terms += b[n - ind] * x[ind];
                    continue;
                }
                x_terms += b[n - ind] * zi[-ind - 1];
            }
            double y_terms = 0.0;
            for (ind = n - 1; ind > n - na - 1; --ind) {
                if (ind < 0) continue;
                y_terms += -a[n - ind] * y[ind];
            }
            y[n] = x_terms + y_terms;
        }
        return y;
    }

    public static double[] filtfilt(double[] b, double[] x) {
        double[] a = new double[]{1.0};
        return SignalProcUtils.filtfilt(b, a, x);
    }

    public static double[] filtfilt(double[] b, double[] a, double[] x) {
        int i;
        int nfilt;
        double[] tmpb = null;
        double[] tmpa = null;
        if (b.length > a.length) {
            nfilt = b.length;
            tmpb = new double[nfilt];
            tmpa = new double[nfilt];
            for (i = 0; i < b.length; ++i) {
                tmpb[i] = b[i];
            }
            for (i = 0; i < a.length; ++i) {
                tmpa[i] = a[i];
            }
            for (i = a.length; i < nfilt; ++i) {
                tmpa[i] = 0.0;
            }
        } else {
            nfilt = a.length;
            tmpb = new double[nfilt];
            tmpa = new double[nfilt];
            for (i = 0; i < a.length; ++i) {
                tmpa[i] = a[i];
            }
            for (i = 0; i < b.length; ++i) {
                tmpb[i] = b[i];
            }
            for (i = b.length; i < nfilt; ++i) {
                tmpb[i] = 0.0;
            }
        }
        int nfact = 3 * (nfilt - 1);
        int rwlen = 3 * nfilt - 5;
        int ylen = 2 * nfact + x.length;
        double[] y = new double[ylen];
        double[] yRet = null;
        if (x.length > nfact) {
            int j;
            int[] rows = new int[rwlen];
            for (i = 0; i <= nfilt - 2; ++i) {
                rows[i] = i;
            }
            for (i = nfilt - 1; i <= 2 * nfilt - 4; ++i) {
                rows[i] = i - nfilt + 2;
            }
            for (i = 2 * nfilt - 3; i <= 3 * nfilt - 6; ++i) {
                rows[i] = i - 2 * nfilt + 3;
            }
            int[] cols = new int[rwlen];
            for (i = 0; i <= nfilt - 2; ++i) {
                cols[i] = 0;
            }
            for (i = nfilt - 1; i <= 2 * nfilt - 4; ++i) {
                cols[i] = i - nfilt + 2;
            }
            for (i = 2 * nfilt - 3; i <= 3 * nfilt - 6; ++i) {
                cols[i] = i - 2 * nfilt + 4;
            }
            double[] data = new double[rwlen];
            data[0] = 1.0 + tmpa[1];
            for (i = 1; i <= nfilt - 2; ++i) {
                data[i] = tmpa[i + 1];
            }
            for (i = nfilt - 1; i <= 2 * nfilt - 4; ++i) {
                data[i] = 1.0;
            }
            for (i = 2 * nfilt - 3; i <= 3 * nfilt - 6; ++i) {
                data[i] = -1.0;
            }
            int N = nfilt - 1;
            double[][] sp = new double[N][N];
            for (i = 0; i < N; ++i) {
                for (j = 0; j < N; ++j) {
                    sp[i][j] = 0.0;
                }
            }
            for (i = 0; i < rwlen; ++i) {
                sp[rows[i]][cols[i]] = data[i];
            }
            double[] denum = new double[N];
            for (i = 0; i < N; ++i) {
                denum[i] = 0.0;
            }
            for (i = 2; i < nfilt + 1; ++i) {
                denum[i - 2] = b[i - 1] - tmpa[i - 1] * b[0];
            }
            double[] zi = new double[N];
            for (i = 0; i < N; ++i) {
                zi[i] = 0.0;
            }
            sp = MathUtils.inverse(sp);
            for (i = 0; i < N; ++i) {
                double tmp = 0.0;
                for (j = 0; j < N; ++j) {
                    tmp += sp[i][j] * denum[i];
                }
                zi[i] = tmp;
            }
            for (i = 0; i < nfact; ++i) {
                y[i] = 2.0 * x[0] - x[nfact - i];
            }
            for (i = 0; i < x.length; ++i) {
                y[i + nfact] = x[i];
            }
            for (i = 0; i < nfact; ++i) {
                y[nfact + x.length + i] = 2.0 * x[x.length - 1] - x[x.length - 2 - i];
            }
            for (i = 0; i < N; ++i) {
                zi[i] = zi[i] * y[0];
            }
            y = SignalProcUtils.filter(tmpb, tmpa, y, false, zi);
            y = SignalProcUtils.reverse(y);
            y = SignalProcUtils.filter(tmpb, tmpa, y, false, zi);
            y = SignalProcUtils.reverse(y);
            yRet = new double[x.length];
            for (i = 0; i < x.length; ++i) {
                yRet[i] = y[i + nfact];
            }
        } else {
            yRet = SignalProcUtils.filter(b, a, x);
        }
        return yRet;
    }

    public static double[] filterfd(double[] filterFFTAbsMag, double[] x, double samplingRate) {
        return SignalProcUtils.filterfd(filterFFTAbsMag, x, samplingRate, 0.02);
    }

    public static double[] filterfd(double[] filterFFTAbsMag, double[] x, double samplingRate, double winsize) {
        return SignalProcUtils.filterfd(filterFFTAbsMag, x, samplingRate, winsize, 0.01);
    }

    public static double[] filterfd(double[] filterFFTAbsMag, double[] x, double samplingRate, double winsize, double skipsize) {
        double[] y = null;
        if (x != null && filterFFTAbsMag != null) {
            int i;
            int ws = (int)Math.floor(winsize * samplingRate + 0.5);
            int ss = (int)Math.floor(skipsize * samplingRate + 0.5);
            int maxFreq = filterFFTAbsMag.length;
            int fftSize = 2 * (maxFreq - 1);
            if (ws > fftSize) {
                ws = fftSize;
            }
            int numfrm = (int)Math.floor(((double)x.length - 0.5 * (double)ws) / (double)ss + 0.5) + 1;
            HammingWindow wgt = new HammingWindow(ws);
            wgt.normalize(1.0f);
            y = new double[x.length];
            Arrays.fill(y, 0.0);
            double[] w = new double[x.length];
            Arrays.fill(w, 0.0);
            ComplexArray XFRM = new ComplexArray(fftSize);
            double[] yfrm = new double[ws];
            for (i = 1; i <= numfrm; ++i) {
                int j;
                Arrays.fill(XFRM.real, 0.0);
                Arrays.fill(XFRM.imag, 0.0);
                for (j = 1; j <= Math.min(ws, x.length - (i - 1) * ss); ++j) {
                    XFRM.real[j - 1] = x[(i - 1) * ss + j - 1];
                }
                wgt.applyInline(XFRM.real, 0, ws);
                FFT.transform(XFRM.real, XFRM.imag, false);
                for (j = 0; j < maxFreq; ++j) {
                    int n = j;
                    XFRM.real[n] = XFRM.real[n] * filterFFTAbsMag[j];
                    int n2 = j;
                    XFRM.imag[n2] = XFRM.imag[n2] * filterFFTAbsMag[j];
                }
                for (j = maxFreq + 1; j <= fftSize; ++j) {
                    XFRM.real[j - 1] = XFRM.real[2 * maxFreq - 1 - j];
                    XFRM.imag[j - 1] = -XFRM.imag[2 * maxFreq - 1 - j];
                }
                FFT.transform(XFRM.real, XFRM.imag, true);
                System.arraycopy(XFRM.real, 0, yfrm, 0, ws);
                for (j = (i - 1) * ss + 1; j <= Math.min(x.length, (i - 1) * ss + ws); ++j) {
                    int n = j - 1;
                    y[n] = y[n] + wgt.value(j - (i - 1) * ss - 1) * yfrm[j - (i - 1) * ss - 1];
                    int n3 = j - 1;
                    w[n3] = w[n3] + wgt.value(j - (i - 1) * ss - 1) * wgt.value(j - (i - 1) * ss - 1);
                }
            }
            for (i = 1; i <= x.length; ++i) {
                if (!(w[i - 1] > 0.0)) continue;
                int n = i - 1;
                y[n] = y[n] / w[i - 1];
            }
        }
        return y;
    }

    public static void addWhiteNoise(double[] x, double level) {
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] + level * Math.random();
        }
    }

    public static double[] getWhiteNoise(int totalSamples, double maxAbsGain) {
        double[] n = null;
        if (totalSamples > 0) {
            n = new double[totalSamples];
            for (int i = 0; i < totalSamples; ++i) {
                n[i] = 2.0 * maxAbsGain * (Math.random() - 0.5);
            }
        }
        return n;
    }

    public static double[] getWhiteNoiseOfVariance(int totalSamples, double variance) {
        double[] n = SignalProcUtils.getWhiteNoise(totalSamples, 1.0);
        MathUtils.adjustVariance(n, variance);
        return n;
    }

    public static double[] getWhiteNoiseOfMeanVariance(int totalSamples, double mean, double variance) {
        double[] n = SignalProcUtils.getWhiteNoise(totalSamples, 1.0);
        MathUtils.adjustMean(n, mean);
        MathUtils.adjustVariance(n, variance);
        return n;
    }

    public static float[] specLinear2cepstrum(double[] specLinear, int cepsOrder) {
        int fftSize;
        int fftSizeFromLen = 2 * (specLinear.length - 1);
        for (fftSize = 2; fftSize < fftSizeFromLen; fftSize *= 2) {
        }
        double[] specLog = MathUtils.log(specLinear);
        double[] real = new double[fftSize];
        double[] imag = new double[fftSize];
        Arrays.fill(real, 0.0);
        Arrays.fill(imag, 0.0);
        System.arraycopy(specLog, 0, real, 0, Math.min(specLog.length, fftSize));
        FFT.transform(real, imag, true);
        float[] nceps = new float[cepsOrder + 1];
        for (int i = 0; i < cepsOrder + 1; ++i) {
            nceps[i] = (float)real[i];
        }
        return nceps;
    }

    public static double cepstrum2linearSpecAmp(float[] ceps, float freqInRadians) {
        double logM = ceps[0];
        for (int m = 1; m < ceps.length; ++m) {
            logM += (double)(2.0f * ceps[m]) * Math.cos((float)m * freqInRadians);
        }
        return Math.exp(logM);
    }

    public static double cepstrum2minimumPhase(float[] ceps, float freqInRadians) {
        double minPhase = 0.0;
        for (int m = 1; m < ceps.length; ++m) {
            minPhase -= (double)(2.0f * ceps[m]) * Math.sin((float)m * freqInRadians);
        }
        return minPhase;
    }

    public static double getMaximumFreqOfVoicingInHz(double[] specAmpsLinear, int[] peakInds, int[][] freqBandInds, int samplingRate) {
        double maximumFreqOfVoicingInHz = 0.5 * (double)samplingRate;
        for (int i = 0; i < freqBandInds.length; ++i) {
        }
        return maximumFreqOfVoicingInHz;
    }

    public static double[] spectralMirror(double[] halfSpectrum) {
        int maxFreq = halfSpectrum.length + 1;
        int fftSize = SignalProcUtils.fullSpectrumSize(maxFreq);
        double[] fullSpectrum = new double[fftSize];
        System.arraycopy(halfSpectrum, 0, fullSpectrum, 0, maxFreq - 1);
        for (int k = maxFreq; k <= fftSize - 1; ++k) {
            fullSpectrum[k] = halfSpectrum[2 * maxFreq - k - 2];
        }
        return fullSpectrum;
    }

    public static double[] addSignals(double[] s1, double[] s2) {
        int len = 0;
        if (s1 != null) {
            len = s1.length;
        }
        if (s2 != null && s2.length > len) {
            len = s2.length;
        }
        double[] y = null;
        if (len > 0) {
            y = new double[len];
        }
        if (s1 != null) {
            System.arraycopy(s1, 0, y, 0, s1.length);
        }
        if (s2 != null) {
            for (int i = 0; i < s2.length; ++i) {
                int n = i;
                y[n] = y[n] + s2[i];
            }
        }
        return y;
    }

    public static double[] addSignals(double[] s1, double gain1, double[] s2, double gain2) {
        double[] y;
        block7: {
            block6: {
                int len = 0;
                if (s1 != null) {
                    len = s1.length;
                }
                if (s2 != null && s2.length > len) {
                    len = s2.length;
                }
                y = null;
                if (len > 0) {
                    y = new double[len];
                }
                if (s1 != null) {
                    System.arraycopy(s1, 0, y, 0, s1.length);
                }
                if (s2 == null) break block6;
                for (int i = 0; i < s2.length; ++i) {
                    y[i] = gain1 * y[i] + gain2 * s2[i];
                }
                break block7;
            }
            if (s1 == null) break block7;
            for (int i = 0; i < s1.length; ++i) {
                y[i] = gain1 * y[i];
            }
        }
        return y;
    }

    public static double[] subtractSignals(double[] s1, double[] s2) {
        return SignalProcUtils.addSignals(s1, 1.0, s2, -1.0);
    }

    public static double[] arFilter(double[] x, double[] a, double lpGain) {
        return SignalProcUtils.arFilter(x, a, lpGain, null);
    }

    public static double[] arFilter(double[] x, float[] a, double lpGain) {
        return SignalProcUtils.arFilter(x, a, lpGain, null);
    }

    public static double[] arFilter(double[] x, float[] a, double lpGain, double[] yInitial) {
        double[] aDouble = ArrayUtils.copyFloat2Double(a);
        return SignalProcUtils.arFilter(x, aDouble, lpGain, yInitial);
    }

    public static double[] arFilter(double[] x, double[] a, double lpGain, double[] yInitial) {
        double[] y = new double[x.length];
        int p = a.length;
        for (int n = 0; n < x.length; ++n) {
            int k;
            y[n] = lpGain * x[n];
            for (k = 1; k <= Math.min(p, n); ++k) {
                int n2 = n;
                y[n2] = y[n2] + a[k - 1] * y[n - k];
            }
            if (yInitial == null) continue;
            for (k = n + 1; k <= p; ++k) {
                int n3 = n;
                y[n3] = y[n3] + a[k - 1] * yInitial[p - k + n];
            }
        }
        return y;
    }

    public static double[] arFilterFreqDomain(double[] windowedFrame, double[] a, double lpGain, double startFreqInHz, double endFreqInHz, int samplingRateInHz) {
        int k;
        int fftSize;
        for (fftSize = 2; fftSize < windowedFrame.length; fftSize *= 2) {
        }
        int maxFreqInd = fftSize / 2;
        ComplexArray X = new ComplexArray(fftSize);
        System.arraycopy(windowedFrame, 0, X.real, 0, windowedFrame.length);
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(X.real, X.imag, false);
        } else {
            X = FFTMixedRadix.fftComplex(X);
        }
        double[] H2 = LpcAnalyser.calcSpecLinear(a, lpGain, fftSize);
        int startFreqInd = SignalProcUtils.freq2index(startFreqInHz, (double)samplingRateInHz, maxFreqInd);
        int endFreqInd = SignalProcUtils.freq2index(endFreqInHz, (double)samplingRateInHz, maxFreqInd);
        for (k = 0; k < startFreqInd; ++k) {
            H2[k] = 0.0;
        }
        for (k = endFreqInd + 1; k <= maxFreqInd; ++k) {
            H2[k] = 0.0;
        }
        ComplexArray Y = new ComplexArray(fftSize);
        for (k = 0; k <= maxFreqInd; ++k) {
            Y.real[k] = X.real[k] * H2[k];
            Y.imag[k] = X.imag[k] * H2[k];
        }
        for (k = maxFreqInd + 1; k < fftSize; ++k) {
            Y.real[k] = Y.real[fftSize - k];
            Y.imag[k] = -1.0 * Y.imag[fftSize - k];
        }
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(Y.real, Y.imag, true);
        } else {
            Y = FFTMixedRadix.ifft(Y);
        }
        double[] y = new double[windowedFrame.length];
        for (k = 0; k < windowedFrame.length; ++k) {
            y[k] = Y.real[k];
        }
        return y;
    }

    public static double[] fdFilter(double[] x, double[] filterFreqResponse) {
        int i;
        int maxFreqInd = filterFreqResponse.length - 1;
        int fftSize = 2 * maxFreqInd;
        ComplexArray frameDft = SignalProcUtils.getFrameDft(x, fftSize);
        for (i = 0; i <= maxFreqInd; ++i) {
            int n = i;
            frameDft.real[n] = frameDft.real[n] * filterFreqResponse[i];
            int n2 = i;
            frameDft.imag[n2] = frameDft.imag[n2] * filterFreqResponse[i];
        }
        for (i = maxFreqInd + 1; i < fftSize; ++i) {
            frameDft.real[i] = frameDft.real[fftSize - i];
            frameDft.imag[i] = -1.0 * frameDft.imag[fftSize - i];
        }
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(frameDft.real, frameDft.imag, true);
        } else {
            frameDft = FFTMixedRadix.ifft(frameDft);
        }
        double[] y = new double[Math.min(x.length, frameDft.real.length)];
        for (i = 0; i < x.length; ++i) {
            y[i] = frameDft.real[i];
        }
        return y;
    }

    public static double[] fdFilter(double[] x, float startFreqInHz, float endFreqInHz, int samplingRateInHz, int fftSize) {
        while (fftSize < x.length) {
            fftSize *= 2;
        }
        ComplexArray frameDft = SignalProcUtils.getFrameDft(x, fftSize);
        return SignalProcUtils.fdFilter(frameDft, startFreqInHz, endFreqInHz, samplingRateInHz, x.length);
    }

    public static double[] fdFilter(ComplexArray frameDft, float startFreqInHz, float endFreqInHz, int samplingRateInHz, int origLen) {
        int i;
        int fftSize = frameDft.real.length;
        int maxFreqInd = fftSize / 2;
        int startFreqInd = SignalProcUtils.freq2index(startFreqInHz, (double)samplingRateInHz, maxFreqInd);
        int endFreqInd = SignalProcUtils.freq2index(endFreqInHz, (double)samplingRateInHz, maxFreqInd);
        double[] y = null;
        float totalRmsEnergy = 0.0f;
        float passbandRmsEnergy = 0.0f;
        int totalPassbandSamples = 0;
        for (i = 0; i <= startFreqInd; ++i) {
            totalRmsEnergy = (float)((double)totalRmsEnergy + (frameDft.real[i] * frameDft.real[i] + frameDft.imag[i] * frameDft.imag[i]));
            frameDft.real[i] = 0.0;
            frameDft.imag[i] = 0.0;
        }
        for (i = startFreqInd + 1; i < endFreqInd; ++i) {
            totalRmsEnergy = (float)((double)totalRmsEnergy + (frameDft.real[i] * frameDft.real[i] + frameDft.imag[i] * frameDft.imag[i]));
            passbandRmsEnergy = (float)((double)passbandRmsEnergy + (frameDft.real[i] * frameDft.real[i] + frameDft.imag[i] * frameDft.imag[i]));
            ++totalPassbandSamples;
        }
        for (i = endFreqInd; i <= maxFreqInd; ++i) {
            totalRmsEnergy = (float)((double)totalRmsEnergy + (frameDft.real[i] * frameDft.real[i] + frameDft.imag[i] * frameDft.imag[i]));
            frameDft.real[i] = 0.0;
            frameDft.imag[i] = 0.0;
        }
        for (i = maxFreqInd + 1; i < fftSize; ++i) {
            frameDft.real[i] = frameDft.real[fftSize - i];
            frameDft.imag[i] = -1.0 * frameDft.imag[fftSize - i];
        }
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(frameDft.real, frameDft.imag, true);
        } else {
            frameDft = FFTMixedRadix.ifft(frameDft);
        }
        y = new double[Math.min(origLen, frameDft.real.length)];
        for (i = 0; i < origLen; ++i) {
            y[i] = frameDft.real[i];
        }
        return y;
    }

    public static void displayDFTSpectrumLinearNoWindowing(double[] frame) {
        int fftSize;
        for (fftSize = 2; fftSize < frame.length; fftSize *= 2) {
        }
        SignalProcUtils.displayDFTSpectrumLinearNoWindowing(frame, fftSize);
    }

    public static void displayDFTSpectrumLinearNoWindowing(double[] frame, int fftSize) {
        SignalProcUtils.displayDFTSpectrumLinear(frame, fftSize, 0);
    }

    public static void displayDFTSpectrumLinear(double[] frame) {
        int fftSize;
        for (fftSize = 2; fftSize < frame.length; fftSize *= 2) {
        }
        SignalProcUtils.displayDFTSpectrumLinear(frame, fftSize);
    }

    public static void displayDFTSpectrumLinear(double[] frame, int fftSize) {
        SignalProcUtils.displayDFTSpectrumLinear(frame, fftSize, 1);
    }

    public static void displayDFTSpectrumLinear(double[] frame, int fftSize, int windowType) {
        Window win = Window.get(windowType, frame.length);
        win.normalizeSquaredSum(1.0f);
        double[] frameW = win.apply(frame, 0);
        while (fftSize < frameW.length) {
            fftSize *= 2;
        }
        if (fftSize % 2 != 0) {
            ++fftSize;
        }
        ComplexArray frameDft = new ComplexArray(fftSize);
        System.arraycopy(frameW, 0, frameDft.real, 0, frame.length);
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(frameDft.real, frameDft.imag, false);
        } else {
            frameDft = FFTMixedRadix.fftComplex(frameDft);
        }
        DisplayUtils.plot(MathUtils.magnitudeComplex(frameDft));
    }

    public static void displayDFTSpectrumInDBNoWindowing(double[] frame) {
        int fftSize;
        for (fftSize = 2; fftSize < frame.length; fftSize *= 2) {
        }
        SignalProcUtils.displayDFTSpectrumInDBNoWindowing(frame, fftSize);
    }

    public static void displayDFTSpectrumInDBNoWindowing(double[] frame, int fftSize) {
        SignalProcUtils.displayDFTSpectrumInDB(frame, fftSize, 0);
    }

    public static void displayDFTSpectrumInDB(double[] frame) {
        int fftSize;
        for (fftSize = 2; fftSize < frame.length; fftSize *= 2) {
        }
        SignalProcUtils.displayDFTSpectrumInDB(frame, fftSize);
    }

    public static void displayDFTSpectrumInDB(double[] frame, int fftSize) {
        SignalProcUtils.displayDFTSpectrumInDB(frame, fftSize, 1);
    }

    public static void displayDFTSpectrumInDB(double[] frame, int fftSize, int windowType) {
        Window win = Window.get(windowType, frame.length);
        if (windowType == 0) {
            win.normalizePeakValue(1.0f);
        }
        SignalProcUtils.displayDFTSpectrumInDB(frame, fftSize, win.getCoeffs());
    }

    public static void displayDFTSpectrumInDB(double[] frame, int fftSize, double[] wgt) {
        ComplexArray frameDft = SignalProcUtils.getFrameDft(frame, fftSize, wgt);
        int maxFreqInd = (int)Math.floor(0.5 * (double)fftSize + 0.5);
        DisplayUtils.plot(MathUtils.amp2db(MathUtils.magnitudeComplex(frameDft)), 0, maxFreqInd);
    }

    public static double[] getFrameHalfMagnitudeSpectrum(double[] frame, int fftSize) {
        double[] fullSpec = SignalProcUtils.getFrameMagnitudeSpectrum(frame, fftSize, 0);
        int maxFreq = SignalProcUtils.halfSpectrumSize(fftSize);
        double[] halfSpec = ArrayUtils.subarray(fullSpec, 0, maxFreq);
        return halfSpec;
    }

    public static double[] getFrameMagnitudeSpectrum(double[] frame, int fftSize) {
        return SignalProcUtils.getFrameMagnitudeSpectrum(frame, fftSize, 0);
    }

    public static double[] getFrameHalfMagnitudeSpectrum(double[] frame, int fftSize, int windowType) {
        double[] fullSpec = SignalProcUtils.getFrameMagnitudeSpectrum(frame, fftSize, windowType);
        int maxFreq = SignalProcUtils.halfSpectrumSize(fftSize);
        double[] halfSpec = ArrayUtils.subarray(fullSpec, 0, maxFreq);
        return halfSpec;
    }

    public static double[] getFrameMagnitudeSpectrum(double[] frame, int fftSize, int windowType) {
        Window win = Window.get(windowType, frame.length);
        if (windowType == 0) {
            win.normalizePeakValue(1.0f);
        }
        return SignalProcUtils.getFrameMagnitudeSpectrum(frame, fftSize, win.getCoeffs());
    }

    public static double[] getFrameHalfMagnitudeSpectrum(double[] frame, int fftSize, double[] wgt) {
        double[] fullSpec = SignalProcUtils.getFrameMagnitudeSpectrum(frame, fftSize, wgt);
        int maxFreq = SignalProcUtils.halfSpectrumSize(fftSize);
        double[] halfSpec = ArrayUtils.subarray(fullSpec, 0, maxFreq);
        return halfSpec;
    }

    public static double[] getFrameMagnitudeSpectrum(double[] frame, int fftSize, double[] wgt) {
        return MathUtils.magnitudeComplex(SignalProcUtils.getFrameDft(frame, fftSize, wgt));
    }

    public static ComplexArray getFrameDft(double[] frame, int fftSize) {
        return SignalProcUtils.getFrameDft(frame, fftSize, 0);
    }

    public static ComplexArray getFrameDft(double[] frame, int fftSize, int windowType) {
        Window win = Window.get(windowType, frame.length);
        if (windowType == 0) {
            win.normalizePeakValue(1.0f);
        }
        double[] wgt = win.getCoeffs();
        return SignalProcUtils.getFrameDft(frame, fftSize, wgt);
    }

    public static ComplexArray getFrameDft(double[] frame, int fftSize, double[] windowWgt) {
        double[] frameW = MathUtils.multiply(frame, windowWgt);
        while (fftSize < frameW.length) {
            fftSize *= 2;
        }
        if (fftSize % 2 != 0) {
            ++fftSize;
        }
        ComplexArray frameDft = new ComplexArray(fftSize);
        System.arraycopy(frameW, 0, frameDft.real, 0, frame.length);
        if (MathUtils.isPowerOfTwo(fftSize)) {
            FFT.transform(frameDft.real, frameDft.imag, false);
        } else {
            frameDft = FFTMixedRadix.fftComplex(frameDft);
        }
        return frameDft;
    }

    public static void displayLPSpectrumLinear(double[] alpha, double lpGain, int fftSize) {
        double[] lpSpec = LpcAnalyser.calcSpecLinear(alpha, lpGain, fftSize);
        DisplayUtils.plot(lpSpec);
    }

    public static void displayLPSpectrumInDB(double[] alpha, double lpGain, int fftSize) {
        double[] lpSpecInDB = MathUtils.amp2db(LpcAnalyser.calcSpecLinear(alpha, lpGain, fftSize));
        DisplayUtils.plot(lpSpecInDB);
    }

    public static double[] shift(double[] x, int N) {
        if (N == 0) {
            return x;
        }
        double[] y = new double[x.length];
        if (N > 0) {
            int i;
            for (i = 0; i < N; ++i) {
                y[i] = x[0];
            }
            for (i = N; i < x.length - N; ++i) {
                y[i] = x[i - N];
            }
        } else {
            int i;
            N = -1 * N;
            for (i = 0; i < x.length - N; ++i) {
                y[i] = x[i + N];
            }
            for (i = x.length - N; i < x.length; ++i) {
                y[i] = x[x.length - 1];
            }
        }
        return y;
    }

    public static float[] shift(float[] x, int N) {
        if (N == 0) {
            return x;
        }
        float[] y = new float[x.length];
        if (N > 0) {
            int i;
            for (i = 0; i < N; ++i) {
                y[i] = x[0];
            }
            for (i = N; i < x.length; ++i) {
                y[i] = x[i - N];
            }
        } else {
            int i;
            N = -1 * N;
            for (i = 0; i < x.length - N; ++i) {
                y[i] = x[i + N];
            }
            for (i = x.length - N; i < x.length; ++i) {
                y[i] = x[x.length - 1];
            }
        }
        return y;
    }

    public static double[] getPeakAmplitudes(double[] sDft, double f0InHz, int numHarmonics, int fftSize, double samplingRateInHz, boolean bIncludeZerothHarmonic) {
        int startHarmonicIndex = bIncludeZerothHarmonic ? 0 : 1;
        int endHarmonicIndex = numHarmonics;
        return SignalProcUtils.getPeakAmplitudes(sDft, f0InHz, startHarmonicIndex, endHarmonicIndex, fftSize, samplingRateInHz, true);
    }

    public static double[] getPeakAmplitudeFrequencies(double[] sDft, double f0InHz, int numHarmonics, int fftSize, double samplingRateInHz, boolean bIncludeZerothHarmonic) {
        int startHarmonicIndex = bIncludeZerothHarmonic ? 0 : 1;
        int endHarmonicIndex = numHarmonics;
        return SignalProcUtils.getPeakAmplitudes(sDft, f0InHz, startHarmonicIndex, endHarmonicIndex, fftSize, samplingRateInHz, false);
    }

    public static double[] getPeakAmplitudes(double[] sDft, double f0InHz, int startHarmonicIndex, int endHarmonicIndex, int fftSize, double samplingRateInHz, boolean amplitudes) {
        int numHarmonics;
        int maxFreqIndex = (int)Math.floor(0.5 * (double)fftSize + 0.5);
        int numAmps = numHarmonics = endHarmonicIndex - startHarmonicIndex + 1;
        double[] amps = new double[numAmps];
        double[] ampsFreq = new double[numAmps];
        int zeroBasedMaxFreqIndex = fftSize / 2;
        for (int i = startHarmonicIndex; i <= endHarmonicIndex; ++i) {
            int freqStartInd = SignalProcUtils.freq2index((double)i * f0InHz - 0.3 * f0InHz, (double)((int)samplingRateInHz), maxFreqIndex);
            int freqEndInd = SignalProcUtils.freq2index((double)i * f0InHz + 0.3 * f0InHz, (double)((int)samplingRateInHz), maxFreqIndex);
            int k = MathUtils.getMaxIndex(sDft, freqStartInd, freqEndInd);
            amps[i - startHarmonicIndex] = sDft[k];
            if (amplitudes) continue;
            ampsFreq[i - startHarmonicIndex] = SignalProcUtils.index2freq(k, (int)samplingRateInHz, zeroBasedMaxFreqIndex);
        }
        if (amplitudes) {
            return amps;
        }
        return ampsFreq;
    }

    public static float[] getAnalysisTimes(int numfrm, double windowSizeInSeconds, double frameShiftInSeconds) {
        float[] analysisTimesInSeconds = null;
        if (numfrm > 0) {
            analysisTimesInSeconds = new float[numfrm];
            for (int i = 0; i < numfrm; ++i) {
                analysisTimesInSeconds[i] = (float)((double)i * frameShiftInSeconds + 0.5 * windowSizeInSeconds);
            }
        }
        return analysisTimesInSeconds;
    }

    public static double[][] getMapped(double[][] x, int[] mapInds) {
        Object y = null;
        if (mapInds != null && x != null) {
            y = new double[mapInds.length][];
            for (int i = 0; i < mapInds.length; ++i) {
                y[i] = ArrayUtils.copy(x[mapInds[i]]);
            }
        }
        return y;
    }

    public static float[][] getMapped(float[][] x, int[] mapInds) {
        Object y = null;
        if (mapInds != null && x != null) {
            y = new float[mapInds.length][];
            for (int i = 0; i < mapInds.length; ++i) {
                y[i] = ArrayUtils.copy(x[mapInds[i]]);
            }
        }
        return y;
    }

    public static Window getWindow(int windowType, int windowSizeInSamples) {
        if (windowType == 5) {
            return new BartlettWindow(windowSizeInSamples);
        }
        if (windowType == 2) {
            return new BlackmanWindow(windowSizeInSamples);
        }
        if (windowType == 6) {
            return new FlattopWindow(windowSizeInSamples);
        }
        if (windowType == 4) {
            return new GaussWindow(windowSizeInSamples);
        }
        if (windowType == 1) {
            return new HammingWindow(windowSizeInSamples);
        }
        if (windowType == 3) {
            return new HanningWindow(windowSizeInSamples);
        }
        if (windowType == 0) {
            return new RectWindow(windowSizeInSamples);
        }
        System.out.println("Undefined window type!");
        return null;
    }

    public static int getTotalFrames(int totalSamples, int windowLengthInSamples, int skipSizeInSamples) {
        int samplingRate = 16000;
        return SignalProcUtils.getTotalFrames(SignalProcUtils.sample2time(totalSamples, samplingRate), (double)SignalProcUtils.sample2time(windowLengthInSamples, samplingRate), (double)SignalProcUtils.sample2time(skipSizeInSamples, samplingRate));
    }

    public static int getTotalFrames(int totalSamples, double windowSizeInSeconds, double skipSizeInSeconds) {
        int samplingRate = 16000;
        return SignalProcUtils.getTotalFrames(SignalProcUtils.sample2time(totalSamples, samplingRate), windowSizeInSeconds, skipSizeInSeconds);
    }

    public static int getTotalFrames(double totalTimeInSeconds, double windowSizeInSeconds, double skipSizeInSeconds) {
        int numfrm = 0;
        if (skipSizeInSeconds > 0.0 && (double)((numfrm = (int)Math.floor((totalTimeInSeconds - windowSizeInSeconds) / skipSizeInSeconds + 0.5)) - 1) * skipSizeInSeconds + windowSizeInSeconds < totalTimeInSeconds) {
            ++numfrm;
        }
        return numfrm;
    }

    public static double melNonMultiplied(double freqInRadian, int samplingRateInHz) {
        return Math.log(1.0 + freqInRadian * (double)samplingRateInHz / 4398.22971502571);
    }

    public static double radian2mel(double freqInRadian, int samplingRateInHz) {
        return Math.PI * SignalProcUtils.melNonMultiplied(freqInRadian, samplingRateInHz) / SignalProcUtils.melNonMultiplied(Math.PI, samplingRateInHz);
    }

    public static double hz2mel(double freqInHz, int samplingRateInHz) {
        return SignalProcUtils.radian2mel(SignalProcUtils.hz2radian(freqInHz, samplingRateInHz), samplingRateInHz);
    }

    public static double mel2radian(double mel, int samplingRateInHz) {
        return 4398.22971502571 / (double)samplingRateInHz * (-1.0 + Math.exp(mel * SignalProcUtils.melNonMultiplied(Math.PI, samplingRateInHz) / Math.PI));
    }

    public static double mel2hz(double mel, int samplingRateInHz) {
        return SignalProcUtils.radian2hz(SignalProcUtils.mel2radian(mel, samplingRateInHz), samplingRateInHz);
    }

    public static double[] replaceNaNsWith(double[] x, double val) {
        double[] y = null;
        if (x != null && x.length > 0) {
            y = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                y[i] = Double.isNaN(x[i]) ? 0.0 : x[i];
            }
        }
        return y;
    }

    public static double sourceTime2targetTime(double sourceTime, Labels sourceLabels, Labels targetLabels) {
        int[][] map = AlignLabelsUtils.alignLabels(sourceLabels.items, targetLabels.items);
        return SignalProcUtils.sourceTime2targetTime(sourceTime, sourceLabels, targetLabels, map);
    }

    public static double sourceTime2targetTime(double sourceTime, Labels sourceLabels, Labels targetLabels, int[][] map) {
        double locationInLabelPercent;
        int sourceLabInd = SignalProcUtils.time2LabelIndex(sourceTime, sourceLabels);
        if (sourceLabInd > 0) {
            double sourceDuration = sourceLabels.items[sourceLabInd].time - sourceLabels.items[sourceLabInd - 1].time;
            locationInLabelPercent = (sourceTime - sourceLabels.items[sourceLabInd - 1].time) / sourceDuration;
        } else {
            double sourceDuration = sourceLabels.items[sourceLabInd].time;
            locationInLabelPercent = sourceTime / sourceLabels.items[sourceLabInd].time;
        }
        int targetLabInd = StringUtils.findInMap(map, sourceLabInd);
        double targetDuration = targetLabInd > 0 ? targetLabels.items[targetLabInd].time - targetLabels.items[targetLabInd - 1].time : targetLabels.items[targetLabInd].time;
        double targetTime = targetLabInd > 0 ? targetLabels.items[targetLabInd - 1].time + locationInLabelPercent * targetDuration : locationInLabelPercent * targetDuration;
        return targetTime;
    }

    public static int[] mapFrameIndices(int numfrmSource, Labels srcLabs, double srcWindowSizeInSeconds, double srcSkipSizeInSeconds, int numFrmTarget, Labels tgtLabs, double tgtWindowSizeInSeconds, double tgtSkipSizeInSeconds) {
        int[] mappedInds = null;
        int[][] mappedLabelInds = AlignLabelsUtils.alignLabels(srcLabs.items, tgtLabs.items);
        if (numfrmSource > 0) {
            mappedInds = new int[numfrmSource];
            for (int i = 0; i < numfrmSource; ++i) {
                double tMapEnd;
                double sMapEnd;
                double tMapStart;
                double sMapStart;
                double tSource = (double)i * srcSkipSizeInSeconds + 0.5 * srcWindowSizeInSeconds;
                int sourceLabInd = SignalProcUtils.time2LabelIndex(tSource, srcLabs);
                int targetLabInd = StringUtils.findInMap(mappedLabelInds, sourceLabInd);
                if (targetLabInd < 0) {
                    int j;
                    sMapStart = 0.0;
                    tMapStart = 0.0;
                    sMapEnd = srcLabs.items[srcLabs.items.length - 1].time;
                    tMapEnd = tgtLabs.items[tgtLabs.items.length - 1].time;
                    for (j = targetLabInd - 1; j >= 0; --j) {
                        int prevSourceLabInd = StringUtils.findInMapReverse(mappedLabelInds, j);
                        if (prevSourceLabInd <= -1) continue;
                        sMapStart = srcLabs.items[prevSourceLabInd].time;
                        tMapStart = tgtLabs.items[j].time;
                        break;
                    }
                    for (j = targetLabInd + 1; j < tgtLabs.items.length; ++j) {
                        int nextSourceLabInd = StringUtils.findInMapReverse(mappedLabelInds, j);
                        if (nextSourceLabInd <= -1) continue;
                        sMapEnd = srcLabs.items[nextSourceLabInd].time;
                        tMapEnd = tgtLabs.items[j].time;
                        break;
                    }
                } else {
                    sMapStart = 0.0;
                    if (sourceLabInd > 0) {
                        sMapStart = srcLabs.items[sourceLabInd - 1].time;
                    }
                    tMapStart = 0.0;
                    if (targetLabInd > 0) {
                        tMapStart = tgtLabs.items[targetLabInd - 1].time;
                    }
                    sMapEnd = srcLabs.items[sourceLabInd].time;
                    tMapEnd = tgtLabs.items[targetLabInd].time;
                }
                double tTarget = MathUtils.linearMap(tSource, sMapStart, sMapEnd, tMapStart, tMapEnd);
                int targetFrmInd = SignalProcUtils.time2frameIndex(tTarget, tgtWindowSizeInSeconds, tgtSkipSizeInSeconds);
                mappedInds[i] = targetFrmInd = MathUtils.CheckLimits(targetFrmInd, 0, numFrmTarget - 1);
            }
        }
        return mappedInds;
    }

    public static double[] normalizeVocalTract(double[] srcSignal, double[] tgtSignal, Labels sourceLabels, Labels targetLabels, int windowType, double windowSizeInSeconds, double frameShiftInSeconds, int lpcOrder, int samplingRateInHz, float preCoef) {
        float[][] sourceLpcs = LpcAnalyser.signal2lpCoeffsf(srcSignal, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRateInHz, lpcOrder, preCoef);
        float[] sAnalysisInSeconds = SignalProcUtils.getAnalysisTimes(sourceLpcs.length, windowSizeInSeconds, frameShiftInSeconds);
        float[][] targetLpcs = LpcAnalyser.signal2lpCoeffsf(tgtSignal, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRateInHz, lpcOrder, preCoef);
        int[] mappedInds = SignalProcUtils.mapFrameIndices(sourceLpcs.length, sourceLabels, windowSizeInSeconds, frameShiftInSeconds, targetLpcs.length, targetLabels, windowSizeInSeconds, frameShiftInSeconds);
        float[][] mappedTargetLpcs = SignalProcUtils.getMapped(targetLpcs, mappedInds);
        return SignalProcUtils.normalizeVocalTract(srcSignal, sAnalysisInSeconds, mappedTargetLpcs, windowType, windowSizeInSeconds, lpcOrder, samplingRateInHz, preCoef);
    }

    public static double[] normalizeVocalTract(double[] s, float[] sAnalysisInSeconds, float[][] mappedTgtLpcs, int windowType, double windowSizeInSeconds, int lpcOrderSrc, int samplingRateInHz, float preCoef) {
        float[][] srcLpcs = LpcAnalyser.signal2lpCoeffsf(s, windowType, sAnalysisInSeconds, windowSizeInSeconds, samplingRateInHz, lpcOrderSrc, preCoef);
        return SignalProcUtils.normalizeVocalTract(s, sAnalysisInSeconds, srcLpcs, mappedTgtLpcs, windowSizeInSeconds, samplingRateInHz, preCoef);
    }

    public static double[] normalizeVocalTract(double[] x, float[] tAnalysisInSeconds, float[][] srcLpcs, float[][] mappedTgtLpcs, double windowSizeInSeconds, int samplingRateInHz, float preCoef) {
        int k;
        int fftSize;
        double[] y = null;
        assert (tAnalysisInSeconds.length == srcLpcs.length);
        assert (tAnalysisInSeconds.length == mappedTgtLpcs.length);
        int lpOrder = srcLpcs[0].length;
        int numfrm = tAnalysisInSeconds.length;
        int ws = SignalProcUtils.time2sample(windowSizeInSeconds, samplingRateInHz);
        int halfWs = (int)Math.floor(0.5 * (double)ws + 0.5);
        HammingWindow wgt = new HammingWindow(ws);
        double[] winWgt = wgt.getCoeffs();
        double[] frm = new double[ws];
        for (fftSize = SignalProcUtils.getDFTSize(samplingRateInHz); fftSize < ws; fftSize *= 2) {
        }
        ComplexArray expTerm = LpcAnalyser.calcExpTerm(fftSize, lpOrder);
        y = new double[x.length];
        double[] w = new double[x.length];
        Arrays.fill(y, 0.0);
        Arrays.fill(w, 0.0);
        double[] xPreemp = SignalProcUtils.applyPreemphasis(x, preCoef);
        for (int i = 0; i < numfrm; ++i) {
            int frmStartIndex = i == 0 ? 0 : Math.max(0, SignalProcUtils.time2sample((double)tAnalysisInSeconds[i] - 0.5 * windowSizeInSeconds, samplingRateInHz));
            int frmEndIndex = Math.min(frmStartIndex + ws - 1, xPreemp.length - 1);
            Arrays.fill(frm, 0.0);
            System.arraycopy(xPreemp, frmStartIndex, frm, 0, frmEndIndex - frmStartIndex + 1);
            frm = wgt.apply(frm, 0);
            double origEn = SignalProcUtils.energy(frm);
            double[] inputVocalTractSpectrum = LpcAnalyser.calcSpecLinearf(srcLpcs[i], 1.0, fftSize, expTerm);
            double[] outputVocalTractSpectrum = LpcAnalyser.calcSpecLinearf(mappedTgtLpcs[i], 1.0, fftSize, expTerm);
            ComplexArray inputDft = new ComplexArray(fftSize);
            int maxFreq = fftSize / 2 + 1;
            Arrays.fill(inputDft.real, 0.0);
            Arrays.fill(inputDft.imag, 0.0);
            System.arraycopy(frm, 0, inputDft.real, 0, ws);
            inputDft = FFTMixedRadix.fftComplex(inputDft);
            for (k = 1; k <= maxFreq; ++k) {
                inputDft.real[k - 1] = inputDft.real[k - 1] * outputVocalTractSpectrum[k - 1] / inputVocalTractSpectrum[k - 1];
                inputDft.imag[k - 1] = inputDft.imag[k - 1] * outputVocalTractSpectrum[k - 1] / inputVocalTractSpectrum[k - 1];
            }
            for (k = maxFreq + 1; k <= fftSize; ++k) {
                inputDft.real[k - 1] = inputDft.real[2 * maxFreq - 1 - k];
                inputDft.imag[k - 1] = -inputDft.imag[2 * maxFreq - 1 - k];
            }
            inputDft = FFTMixedRadix.ifft(inputDft);
            System.arraycopy(inputDft.real, 0, frm, 0, ws);
            double newEn = SignalProcUtils.energy(frm);
            frm = MathUtils.multiply(frm, Math.sqrt(origEn) / Math.sqrt(newEn));
            for (k = 0; k < ws && frmStartIndex + k <= y.length - 1; ++k) {
                if (i == 0) {
                    if (k < halfWs) {
                        int n = frmStartIndex + k;
                        y[n] = y[n] + frm[k] * winWgt[k];
                        int n2 = frmStartIndex + k;
                        w[n2] = w[n2] + 1.0;
                        continue;
                    }
                    int n = frmStartIndex + k;
                    y[n] = y[n] + frm[k] * winWgt[k];
                    int n3 = frmStartIndex + k;
                    w[n3] = w[n3] + winWgt[k] * winWgt[k];
                    continue;
                }
                if (i == numfrm - 1) {
                    if (k > halfWs) {
                        int n = frmStartIndex + k;
                        y[n] = y[n] + frm[k] * winWgt[k];
                        w[frmStartIndex + k] = 1.0;
                        continue;
                    }
                    int n = frmStartIndex + k;
                    y[n] = y[n] + frm[k] * winWgt[k];
                    int n4 = frmStartIndex + k;
                    w[n4] = w[n4] + winWgt[k] * winWgt[k];
                    continue;
                }
                int n = frmStartIndex + k;
                y[n] = y[n] + frm[k] * winWgt[k];
                int n5 = frmStartIndex + k;
                w[n5] = w[n5] + winWgt[k] * winWgt[k];
            }
            System.out.println(String.valueOf(frmStartIndex) + "-" + String.valueOf(frmEndIndex) + " Normalized vocal tract spectrum for frame " + String.valueOf(i + 1) + " of " + String.valueOf(numfrm));
        }
        for (k = 0; k < y.length; ++k) {
            if (!(w[k] > 0.0)) continue;
            int n = k;
            y[n] = y[n] / w[k];
        }
        y = SignalProcUtils.removePreemphasis(y, preCoef);
        return y;
    }

    public static void test_normalizeVocalTract() throws UnsupportedAudioFileException, IOException {
        String sourceWavFile = "d:\\src.wav";
        String sourceLabFile = "d:\\src.lab";
        String targetWavFile = "d:\\tgt.wav";
        String targetLabFile = "d:\\tgt.lab";
        String outputWavFile = "d:\\srcResidual_tgtVocalTract.wav";
        int windowType = 1;
        double windowSizeInSeconds = 0.02;
        double frameShiftInSeconds = 0.01;
        float preCoef = 0.97f;
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(sourceWavFile));
        AudioFormat format = inputAudio.getFormat();
        int fsSrc = (int)inputAudio.getFormat().getSampleRate();
        int lpcOrderSrc = SignalProcUtils.getLPOrder(fsSrc);
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] s = signal.getAllData();
        Labels sourceLabels = new Labels(sourceLabFile);
        inputAudio = AudioSystem.getAudioInputStream(new File(targetWavFile));
        int fsTgt = (int)inputAudio.getFormat().getSampleRate();
        int lpcOrderTgt = SignalProcUtils.getLPOrder(fsTgt);
        signal = new AudioDoubleDataSource(inputAudio);
        double[] t = signal.getAllData();
        Labels targetLabels = new Labels(targetLabFile);
        double[] sNorm = SignalProcUtils.normalizeVocalTract(s, t, sourceLabels, targetLabels, windowType, windowSizeInSeconds, frameShiftInSeconds, lpcOrderSrc, fsSrc, preCoef);
        MaryAudioUtils.writeWavFile(sNorm, outputWavFile, format);
    }

    public static double[] normalizeVocalTract(double[] srcSignal, double[] tgtSignal, int windowType, double windowSizeInSeconds, double frameShiftInSeconds, int lpcOrder, int samplingRateInHz, float preCoef) {
        float[][] sourceLpcs = LpcAnalyser.signal2lpCoeffsf(srcSignal, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRateInHz, lpcOrder, preCoef);
        float[] sAnalysisInSeconds = SignalProcUtils.getAnalysisTimes(sourceLpcs.length, windowSizeInSeconds, frameShiftInSeconds);
        float[][] targetLpcs = LpcAnalyser.signal2lpCoeffsf(tgtSignal, windowType, windowSizeInSeconds, frameShiftInSeconds, samplingRateInHz, lpcOrder, preCoef);
        int[] mappedInds = new int[sourceLpcs.length];
        for (int i = 0; i < sourceLpcs.length; ++i) {
            mappedInds[i] = MathUtils.linearMap(i, 0, sourceLpcs.length - 1, 0, targetLpcs.length - 1);
        }
        float[][] mappedTargetLpcs = SignalProcUtils.getMapped(targetLpcs, mappedInds);
        return SignalProcUtils.normalizeVocalTract(srcSignal, sAnalysisInSeconds, mappedTargetLpcs, windowType, windowSizeInSeconds, lpcOrder, samplingRateInHz, preCoef);
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        SignalProcUtils.test_normalizeVocalTract();
    }
}

