/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;

public final class TokenNameFinderEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "TokenNameFinderEvaluator";
    }

    public String getShortDescription() {
        return "";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " -encoding charset -model model -data testData";
    }

    public void run(String[] args) {
        if (args.length != 6) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        File testData = new File(CmdLineUtil.getParameter("-data", args));
        CmdLineUtil.checkInputFile("Test data", testData);
        Charset encoding = CmdLineUtil.getEncodingParameter(args);
        if (encoding == null) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TokenNameFinderModel model = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(new File(CmdLineUtil.getParameter("-model", args)));
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(new NameFinderME(model));
        final ObjectStream<NameSample> sampleStream = TokenNameFinderTrainerTool.openSampleData("Test", testData, encoding);
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        ObjectStream<NameSample> measuredSampleStream = new ObjectStream<NameSample>(){

            @Override
            public NameSample read() throws IOException {
                monitor.incrementCounter();
                return (NameSample)sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            System.err.println("Reading test data error " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException e) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        System.out.println(evaluator.getFMeasure());
    }
}

