/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.wizards.PreviewListener;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleSegmenterPreviewer
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 5843079846332271665L;
    private PreviewListener previewListener;
    private JTextArea textAreaOriginal;
    private JTextArea textAreaSegments;
    private JList selectorList = null;
    private String splitExpression;

    public SimpleSegmenterPreviewer(PreviewListener listener) {
        super((Frame)RapidMinerGUI.getMainFrame(), "Segmenter Previewer");
        this.previewListener = listener;
        try {
            this.splitExpression = this.previewListener.getParameters().getParameter("split_expression").toString();
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        this.textAreaOriginal = new JTextArea();
        this.textAreaOriginal.setWrapStyleWord(true);
        this.textAreaOriginal.setLineWrap(true);
        this.textAreaOriginal.setMargin(new Insets(10, 10, 10, 10));
        this.textAreaSegments = new JTextArea();
        this.textAreaSegments.setWrapStyleWord(true);
        this.textAreaSegments.setLineWrap(true);
        this.textAreaSegments.setMargin(new Insets(10, 10, 10, 10));
        File baseDir = null;
        try {
            baseDir = this.previewListener.getProcess().resolveFileName(this.previewListener.getParameters().getParameter("texts"));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        File[] files = baseDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isFile() && !f.isHidden();
            }
        });
        this.selectorList = files != null && files.length > 0 ? new JList<File>(files) : new JList();
        this.selectorList.setSelectionMode(0);
        this.selectorList.addListSelectionListener(this);
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleSegmenterPreviewer.this.dispose();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.gridx = 0;
        gbcLabel.gridy = -1;
        gbcLabel.fill = 2;
        gbcLabel.weightx = 1.0;
        gbcLabel.weighty = 0.0;
        gbcLabel.insets = new Insets(10, 10, 10, 10);
        JLabel label = new JLabel("Select a document");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.selectorList), gbc);
        label = new JLabel("Original text");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.textAreaOriginal), gbc);
        label = new JLabel("Extracted segments");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.textAreaSegments), gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(7, 7, 7, 7);
        this.getContentPane().add((Component)okButton, gbc);
        this.setSize(Math.max(640, (int)(0.66 * (double)this.getOwner().getWidth())), Math.max(480, (int)(0.66 * (double)this.getOwner().getHeight())));
        this.setLocationRelativeTo(this.getOwner());
        if (files != null && files.length > 0) {
            this.selectorList.setSelectedIndex(0);
        } else {
            this.textAreaOriginal.setText("You must specify a directory containing at least one text in \"texts\"");
        }
    }

    private void showSegments(File f) {
        StringBuffer originalText = new StringBuffer();
        try {
            String[] segments;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), this.previewListener.getProcess().getRootOperator().getEncoding()));
            String buf = null;
            while ((buf = in.readLine()) != null) {
                originalText.append(buf);
                originalText.append('\n');
            }
            this.textAreaOriginal.setText(originalText.toString());
            this.textAreaOriginal.setCaretPosition(0);
            StringBuffer segmentsText = new StringBuffer();
            String[] stringArray = segments = originalText.toString().split(this.splitExpression);
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                segmentsText.append("\n-----------------\n");
                segmentsText.append(segment);
                ++n2;
            }
            this.textAreaSegments.setText(segmentsText.toString());
            this.textAreaSegments.setCaretPosition(0);
        }
        catch (FileNotFoundException e) {
            this.textAreaOriginal.setText("Could not load text from " + f);
        }
        catch (IOException e) {
            this.textAreaOriginal.setText("Could not load text from " + f);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        File f = (File)this.selectorList.getModel().getElementAt(this.selectorList.getSelectedIndex());
        if (f != null) {
            this.showSegments(f);
        } else {
            this.textAreaOriginal.setText("You must specify a directory containing at least one text in \"texts\"");
        }
    }
}

