<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>
	<xsl:template match="/">
		<xsl:text>PROCESS_TYPE,SOURCE_DATA,IDENTIFIED,NUM_IDENTIFIED_CANDIDATES,CANDIDATES_MAX_SCORE,CANDIDATES_MEAN_SCORE,CANDIDATES_SCORE_DEV,CORRECTLY_IDENTIFIED,CORRECTLY_IDENTIFIED_CANDIDATE_SCORE,CORRECTLY_IDENTIFIED_CANDIDATE_SCORE_IS_MAX
</xsl:text>	
		<xsl:apply-templates select="//PerInput"/> 
	</xsl:template>
	
	<xsl:template match="PerInput">
<xsl:value-of select="concat('&quot;', 
							 @processType, 
							 '&quot;,',
							 '&quot;',
							 sourceData/text(),
							 '&quot;,',
							 identified/text(),
							 ',',
							 numIdentifiedCandidates/text(),
							 ',',
							 format-number(candidatesMaxScore/text(), '0.000000'),
							 ',', 
							 format-number(candidatesMeanScore/text(), '0.000000'),
							 ',',
							 format-number(candidatesScoreDev/text(), '0.000000'),
							 ',',
							 correctlyIdentified/text(),
							 ',',
							 format-number(correctlyIdentifiedCandidateScore/text(), '0.000000'),
							 ',',
							 correctlyIdentifiedCandidateScoreIsMax/text())"/><xsl:text>
</xsl:text>
	</xsl:template>
</xsl:stylesheet>