/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.resourcefile;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.inject.Inject;
import org.gcube.rest.commons.inject.ResourcesFoldername;
import org.gcube.rest.commons.inject.StatefulResourceClass;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFileUtilsBinary<T extends StatefulResource>
extends IResourceFileUtils<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFileUtilsBinary.class);
    private final Class<T> clazz;
    private final String resourcesFoldername;

    @Inject
    public ResourceFileUtilsBinary(@StatefulResourceClass Class<T> clazz, @ResourcesFoldername String resourcesFoldername) {
        this.clazz = clazz;
        this.resourcesFoldername = resourcesFoldername;
    }

    @Override
    public String getResourcesFoldername() {
        return this.resourcesFoldername;
    }

    @Override
    public void createResourceDirectory() throws IOException {
        File resourcesDir = new File(this.resourcesFoldername);
        Files.createParentDirs((File)new File(this.resourcesFoldername));
        if (resourcesDir.mkdir()) {
            logger.info("creating new resources folder");
        } else {
            logger.info("resources folder already exists");
        }
    }

    @Override
    public void writeResourceToFile(String resourceID, T resource) throws IOException {
        String filename = resourceID;
        File resourceFile = new File(this.resourcesFoldername + "/" + filename);
        if (resourceFile.createNewFile()) {
            logger.info("creating new resources folder");
        } else {
            logger.info("resources folder already exists");
        }
        FileOutputStream fout = new FileOutputStream(resourceFile);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(resource);
        oos.flush();
        oos.close();
    }

    @Override
    public T readResourceFromFile(String filename) throws IOException, ClassNotFoundException {
        return this.readResourceFromFile(new File(filename));
    }

    @Override
    public T readResourceFromFile(File file) throws IOException, ClassNotFoundException {
        byte[] jsonResource = Files.toByteArray((File)file);
        ByteArrayInputStream is = new ByteArrayInputStream(jsonResource);
        ObjectInputStream ois = new ObjectInputStream(is);
        StatefulResource sr = (StatefulResource)ois.readObject();
        ois.close();
        if (this.clazz.isInstance(sr)) {
            StatefulResource statefulResource = (StatefulResource)this.clazz.cast(sr);
            return (T)statefulResource;
        }
        throw new IllegalStateException("stateful resource is of type : " + sr.getClass().getName() + " not " + this.clazz.getName());
    }
}

