/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.helpers;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLConverter {
    public static String convertToXML(Object obj) throws JAXBException {
        return XMLConverter.convertToXML(obj, false);
    }

    public static String convertToXML(Object obj, boolean prettyPrint) throws JAXBException {
        String xml = null;
        StringWriter sw = new StringWriter();
        JAXBContext carContext = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller carMarshaller = carContext.createMarshaller();
        carMarshaller.marshal(obj, (Writer)sw);
        xml = sw.toString();
        return xml;
    }

    public static Node convertToXMLNode(Object obj) throws JAXBException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = dbf.newDocumentBuilder().newDocument();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(obj, (Node)doc);
        return (Element)doc.getFirstChild();
    }

    public static <T> T fromXML(String xml, Class<T> clazz) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return clazz.cast(unmarshaller.unmarshal((Reader)reader));
    }

    public static <T> T fromXML(Node node, Class<T> clazz) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return clazz.cast(unmarshaller.unmarshal(node));
    }

    public static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            return null;
        }
        return sw.toString();
    }

    public static Node stringToNode(String str) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(str.getBytes())).getDocumentElement();
        }
        catch (Exception e) {
            return null;
        }
    }
}

