/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.helpers;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathEvaluator {
    private Node node;
    private XPath xpath;

    public XPathEvaluator(Node node) {
        this.node = node;
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }

    public List<String> evaluate(String expression) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate(expression, this.node, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() == 2 || nodeList.item(i).getNodeType() == 3) {
                    list.add(nodeList.item(i).getTextContent());
                    continue;
                }
                list.add(XMLConverter.nodeToString(nodeList.item(i)));
            }
        }
        catch (XPathExpressionException e) {
            try {
                Double number = (Double)this.xpath.evaluate(expression, this.node, XPathConstants.NUMBER);
                list.add(String.valueOf(number.intValue()));
            }
            catch (XPathExpressionException e1) {
                return null;
            }
        }
        return list;
    }

    public Node getNode() {
        return this.node;
    }

    public XPath getXpath() {
        return this.xpath;
    }

    public static void main(String[] args) {
        String xml = "<oai_dc:oai_dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n    xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"\n    xmlns:dcterms=\"http://purl.org/dc/terms/\">\n     <dc:title>\u039b\u03ac\u03bc\u03c0\u03b1 \u03c4\u03bf\u03af\u03c7\u03bf\u03c5.</dc:title>\n     <dc:creator/>\n     <dc:subject>\u03c6\u03b1\u03bd\u03ac\u03c1\u03b9</dc:subject>\n     <dc:description>\u039b\u03ac\u03bc\u03c0\u03b1 \u03c4\u03bf\u03af\u03c7\u03bf\u03c5</dc:description>\n     <dc:publisher>\u038a\u03b4\u03c1\u03c5\u03bc\u03b1 \u0392\u03b1\u03c1\u03ce\u03bd\u03bf\u03c5 \u039c\u03b9\u03c7\u03b1\u03ae\u03bb \u03a4\u03bf\u03c3\u03af\u03c4\u03c3\u03b1</dc:publisher>\n     <dc:contributor/>\n     <dc:date>2014-04-23</dc:date>\n     <dc:type>\u0391\u03bd\u03c4\u03b9\u03ba\u03b5\u03af\u03bc\u03b5\u03bd\u03bf \u03c6\u03c9\u03c4\u03b9\u03c3\u03bc\u03bf\u03cd</dc:type>\n     <dc:format/>\n     <dc:identifier>\u0393\u0395_1297</dc:identifier>\n     <dc:source/>\n     <dc:language/>\n     <dc:coverage/>\n     <dc:relation/>\n     <dc:rights/>\n     <dcterms:medium>\u03c7\u03b1\u03bb\u03ba\u03cc\u03c2, \u03b3\u03c5\u03b1\u03bb\u03af</dcterms:medium>\n     <dc:identifier>http://gator3239.hostgator.com/~post/tositsa/PHOTO%202/GE_1297.tif</dc:identifier>\n     <dc:type>image/tif</dc:type>\n</oai_dc:oai_dc>";
        List<String> list = new XPathEvaluator(XMLConverter.stringToNode(xml)).evaluate("//*[local-name()='oai_dc']");
        System.out.println(list);
    }
}

