/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.resourcefile;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.gcube.rest.commons.inject.ResourcesFoldername;
import org.gcube.rest.commons.inject.StatefulResourceClass;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFileUtilsJSON<T extends StatefulResource>
extends IResourceFileUtils<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFileUtilsJSON.class);
    private final Class<T> clazz;
    private final String resourcesFoldername;

    @Inject
    public ResourceFileUtilsJSON(@StatefulResourceClass Class<T> clazz, @ResourcesFoldername String resourcesFoldername) {
        this.clazz = clazz;
        this.resourcesFoldername = resourcesFoldername;
    }

    @Override
    public String getResourcesFoldername() {
        return this.resourcesFoldername;
    }

    @Override
    public void createResourceDirectory() throws IOException {
        File resourcesDir = new File(this.resourcesFoldername);
        Files.createParentDirs((File)new File(this.resourcesFoldername));
        if (resourcesDir.mkdir()) {
            logger.info("creating new resources folder");
        } else {
            logger.info("resources folder already exists");
        }
    }

    @Override
    public void writeResourceToFile(String resourceID, T resource) throws IOException {
        String filename = resourceID;
        File resourceFile = new File(this.resourcesFoldername + "/" + filename);
        if (resourceFile.createNewFile()) {
            logger.info("creating new resources folder");
        } else {
            logger.info("resources folder already exists");
        }
        String json = JSONConverter.convertToJSON(resource, true);
        Files.write((byte[])json.getBytes(), (File)resourceFile);
    }

    @Override
    public T readResourceFromFile(String filename) throws IOException, ClassNotFoundException {
        return this.readResourceFromFile(new File(filename));
    }

    @Override
    public T readResourceFromFile(File file) throws IOException, ClassNotFoundException {
        byte[] jsonResource = Files.toByteArray((File)file);
        StatefulResource resource = (StatefulResource)JSONConverter.fromJSON(new String(jsonResource), this.clazz);
        logger.info("read resource from json file with class : " + resource.getClass() + " of " + this.clazz + " and id : " + resource.getResourceID());
        return (T)resource;
    }
}

