/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.is.publisher.is;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Singleton
public class PublisherISimpl<T extends GeneralResource>
implements ResourcePublisher<T> {
    private static final Logger logger = LoggerFactory.getLogger(PublisherISimpl.class);

    @Inject
    public PublisherISimpl() {
    }

    public static void main(String[] args) throws RegistryNotFoundException {
        String scope = "/gcube";
        String id = "175aa11f-ba99-4554-b389-5a4ac93e37d9";
        GCoreEndpoint gce = null;
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/ID/text() eq '" + id + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 0) {
            gce = (GCoreEndpoint)resources.get(0);
            List<String> scopes = Arrays.asList(scope);
            ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
            publish.remove((Resource)gce, scopes);
        }
    }

    public void deleteResource(String resourceID, String scope) throws ResourcePublisherException {
        logger.info("deleting resource with ID : " + resourceID + " from IS");
        GenericResource genericResource = PublisherISimpl.getResourceByID(resourceID, scope);
        if (genericResource == null) {
            throw new ResourcePublisherException("resource with id : " + resourceID + " not found");
        }
        this.deleteFromScopes(genericResource, scope);
    }

    private void deleteFromScopes(GenericResource genericResource, String scope) throws ResourcePublisherException {
        ScopeProvider.instance.set(scope);
        List<String> scopesList = Arrays.asList(scope);
        ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
        Resource r = null;
        try {
            r = publish.remove((Resource)genericResource, scopesList);
            logger.info("resource removed with id : " + r.id());
        }
        catch (RegistryNotFoundException e) {
            throw new ResourcePublisherException((Throwable)e);
        }
    }

    public void publishResource(T resource, String resourceClass, String resourceNamePref, String scope) throws ResourcePublisherException {
        logger.info("creating resource with ID : " + resource.getResourceID() + " from IS");
        GenericResource genericResource = null;
        try {
            genericResource = this.convertToGenericResource(resource, resourceClass, resourceNamePref);
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
            logger.error("error while converting resource to generic resource", e);
        }
        ScopeProvider.instance.set(scope);
        List<String> scopes = Arrays.asList(scope);
        ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
        Resource r = null;
        try {
            r = publish.create((Resource)genericResource, scopes);
            logger.info("resource created with id : " + r.id());
        }
        catch (RegistryNotFoundException e) {
            throw new ResourcePublisherException((Throwable)e);
        }
    }

    public void updateResource(T resource, String resourceClass, String resourceNamePref, String scope) throws ResourcePublisherException {
        logger.info("updating resource with ID : " + resource.getResourceID() + " to IS");
        ScopeProvider.instance.set(scope);
        ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
        GenericResource genericResource = null;
        try {
            genericResource = this.convertToGenericResource(resource, resourceClass, resourceNamePref);
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
            logger.error("error while converting resource to generic resource", e);
        }
        Resource r = null;
        try {
            r = publish.update((Resource)genericResource);
            logger.info("resource updated with id : " + r.id());
        }
        catch (RegistryNotFoundException e) {
            throw new ResourcePublisherException((Throwable)e);
        }
    }

    private static GenericResource getResourceByID(String resourceID, String scope) {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + resourceID + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)query);
        if (resources.size() > 0) {
            return (GenericResource)resources.get(0);
        }
        logger.warn("Could not find resource with ID : " + resourceID);
        return null;
    }

    private GenericResource convertToGenericResource(T resource, String clazz, String name) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        GenericResource genericResource = new GenericResource();
        ResourceMediator.setId((Resource)genericResource, (String)resource.getResourceID());
        genericResource.newProfile();
        genericResource.profile().name(name + "." + resource.getResourceID());
        genericResource.profile().type(clazz);
        String serialization = resource.toXML();
        logger.info("resource serialization : " + serialization);
        Element newBody = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization.getBytes())).getDocumentElement();
        genericResource.profile().newBody();
        Node importedNode = genericResource.profile().body().getOwnerDocument().importNode(newBody, true);
        genericResource.profile().body().appendChild(importedNode);
        return genericResource;
    }
}

