/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.app;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.jpa.JpaPersistModule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.rest.commons.db.app.ApplicationInitializer;
import org.gcube.rest.commons.db.dao.app.GeneralResourceModelDao;
import org.gcube.rest.commons.db.dao.app.ResourceModelDao;
import org.gcube.rest.commons.db.dao.app.RunInstanceModelDao;
import org.gcube.rest.commons.db.dao.app.SerInstanceModelDao;
import org.gcube.rest.commons.db.model.app.GeneralResourceModel;
import org.gcube.rest.commons.db.model.app.ResourceModel;
import org.gcube.rest.commons.db.model.app.RunInstanceModel;
import org.gcube.rest.commons.db.model.app.SerInstanceModel;
import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.commons.resourceawareservice.resources.SerInstance;

public class Test {
    public static void main(String[] args) throws URISyntaxException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JpaPersistModule("myapp-db")});
        ApplicationInitializer ai = (ApplicationInitializer)injector.getInstance(ApplicationInitializer.class);
        ResourceModelDao dao = (ResourceModelDao)injector.getInstance(ResourceModelDao.class);
        System.out.println("before save");
        Resource resource = new Resource();
        resource.setDescription("dummy description");
        resource.setName("dummy name");
        resource.setScopes((List)Lists.newArrayList((Object[])new String[]{"scope1", "scope2"}));
        ResourceModel resourceModel1 = new ResourceModel(resource);
        resourceModel1 = dao.save(resourceModel1);
        System.out.println("after save");
        System.out.println("before findAll");
        System.out.println(dao.findAll());
        System.out.println("after findAll");
        System.out.println("before findById");
        ResourceModel resourceModel2 = (ResourceModel)dao.findById(resourceModel1.getId());
        System.out.println("after findById");
        System.out.println("rm : " + resourceModel2.getId());
        System.out.println("rm : " + resourceModel2.getDescription());
        System.out.println("rm : " + resourceModel2.getScopes());
        GeneralResource generalGeneral = new GeneralResource();
        generalGeneral.setResourceID("123456789-abcde");
        GeneralResourceModel generalResourceModel = new GeneralResourceModel(generalGeneral);
        GeneralResourceModelDao generalResourceModelDao = (GeneralResourceModelDao)injector.getInstance(GeneralResourceModelDao.class);
        System.out.println("before save");
        generalResourceModel = generalResourceModelDao.save(generalResourceModel);
        System.out.println("after save");
        System.out.println("before findAll");
        System.out.println(generalResourceModelDao.findAll());
        System.out.println("after findAll");
        System.out.println("before findById");
        GeneralResourceModel generalResourceModel2 = (GeneralResourceModel)generalResourceModelDao.findById(generalResourceModel.getId());
        System.out.println("after findById");
        System.out.println("rm : " + generalResourceModel2.getId());
        System.out.println("rm : " + generalResourceModel2.getDescription());
        System.out.println("rm : " + generalResourceModel2.getResourceID());
        HashMap endpoints = Maps.newHashMap();
        endpoints.put("key", new URI("http://google.com"));
        RunInstance runInstance = new RunInstance((Map)endpoints, "id", "ghnID", "serviceName", "serviceClass", null, null);
        RunInstanceModel rim = new RunInstanceModel(runInstance);
        RunInstanceModelDao runInstanceModelDao = (RunInstanceModelDao)injector.getInstance(RunInstanceModelDao.class);
        rim = runInstanceModelDao.save(rim);
        System.out.println(runInstanceModelDao.findAll());
        System.out.println("before findById");
        RunInstanceModel rim2 = (RunInstanceModel)runInstanceModelDao.findById(rim.getId());
        System.out.println("after findById");
        System.out.println("rim2 : " + rim2.getId());
        System.out.println("rim2" + rim2.getDescription());
        System.out.println("rim2 : " + rim2.getEndpoints());
        SerInstance.NodeProperties nodeProperties = new SerInstance.NodeProperties("nodeID", (List)Lists.newArrayList((Object[])new String[]{"scopeA", "scopeB"}), null);
        SerInstance serInstance = new SerInstance(new URI("http://google.com"), "my key", "serviceName", "serviceClass", nodeProperties);
        SerInstanceModel serInstanceModel = new SerInstanceModel(serInstance);
        SerInstanceModelDao serInstanceModelDao = (SerInstanceModelDao)injector.getInstance(SerInstanceModelDao.class);
        System.out.println("before save");
        serInstanceModel = serInstanceModelDao.save(serInstanceModel);
        System.out.println("after save");
        System.out.println("before findAll");
        System.out.println(serInstanceModelDao.findAll());
        System.out.println("after findAll");
        System.out.println("before findById");
        SerInstanceModel serInstanceModel2 = (SerInstanceModel)serInstanceModelDao.findById(serInstanceModel.getId());
        System.out.println("after findById");
        System.out.println("rm : " + serInstanceModel2.getId());
        System.out.println("rm : " + serInstanceModel2.getDescription());
        System.out.println("rm : " + serInstanceModel2.getEndpoint());
        System.out.println("rm : " + serInstanceModel2.getNodeId());
        System.out.println("rm : " + serInstanceModel2.getScopes());
        System.out.println("rm : " + serInstanceModel2.getEndpoint());
        SerInstance serInstance2 = serInstanceModel2.copyTo();
        System.out.println("are equal ? : " + serInstance2.equals((Object)serInstance));
        ai.stop();
    }
}

