/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.model.app;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.gcube.rest.commons.db.dao.core.ConverterRecord;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.w3c.dom.Node;

@Entity
@Table(name="run_instance_model")
public class RunInstanceModel
extends ConverterRecord<RunInstance> {
    private static final long serialVersionUID = 1L;
    @Column(name="resourceId")
    private String resourceId;
    @Column(name="ghnId")
    private String ghnId;
    @Column(name="endpoints")
    @ElementCollection
    private Map<String, URI> endpoints;
    @Column(name="scopes")
    @ElementCollection
    private List<String> scopes;
    @Column(name="specificData")
    private String specificData;
    @Column(name="serviceClass")
    private String serviceClass;
    @Column(name="serviceName")
    private String serviceName;

    public RunInstanceModel() {
    }

    public RunInstanceModel(RunInstance base) {
        this.copyFrom(base);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getGhnId() {
        return this.ghnId;
    }

    public void setGhnId(String ghnId) {
        this.ghnId = ghnId;
    }

    public Map<String, URI> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<String, URI> endpoints) {
        this.endpoints = endpoints;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getSpecificData() {
        return this.specificData;
    }

    public void setSpecificData(String specificData) {
        this.specificData = specificData;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public final void copyFrom(RunInstance resource) {
        this.ghnId = resource.getGhnId();
        this.resourceId = resource.getId();
        this.specificData = XMLConverter.nodeToString((Node)resource.getSpecificData());
        this.serviceClass = resource.getServiceClass();
        this.serviceName = resource.getServiceName();
        if (resource.getScopes() != null) {
            this.scopes = Lists.newArrayList((Iterable)resource.getScopes());
        }
        if (resource.getEndpoints() != null) {
            this.endpoints = Maps.newHashMap((Map)resource.getEndpoints());
        }
    }

    @Override
    public final RunInstance copyTo() throws IllegalStateException {
        Node node = XMLConverter.stringToNode((String)this.specificData);
        if (node == null && !Strings.isNullOrEmpty((String)this.specificData)) {
            throw new IllegalStateException("error while creating object from convertable");
        }
        RunInstance resource = new RunInstance((Map)Maps.newHashMap(this.endpoints), this.resourceId, this.ghnId, this.serviceName, this.serviceClass, (Set)Sets.newHashSet(this.scopes), node);
        return resource;
    }
}

