package org.gcube.rest.commons.db.app;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

import org.gcube.rest.commons.db.dao.app.GeneralResourceModelDao;
import org.gcube.rest.commons.db.dao.app.ResourceModelDao;
import org.gcube.rest.commons.db.dao.app.RunInstanceModelDao;
import org.gcube.rest.commons.db.dao.app.SerInstanceModelDao;
import org.gcube.rest.commons.db.model.app.GeneralResourceModel;
import org.gcube.rest.commons.db.model.app.ResourceModel;
import org.gcube.rest.commons.db.model.app.RunInstanceModel;
import org.gcube.rest.commons.db.model.app.SerInstanceModel;
import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.commons.resourceawareservice.resources.SerInstance;
import org.gcube.rest.commons.resourceawareservice.resources.SerInstance.NodeProperties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.persist.jpa.JpaPersistModule;

public class Test {

	public static void main(String[] args) throws URISyntaxException {
		
		Injector injector = Guice.createInjector(new JpaPersistModule("myapp-db"));
		ApplicationInitializer ai = injector.getInstance(ApplicationInitializer.class);
		
		ResourceModelDao dao = injector.getInstance(ResourceModelDao.class);
		
		System.out.println("before save");
		Resource resource = new Resource();
		resource.setDescription("dummy description");
		resource.setName("dummy name");
		resource.setScopes(Lists.newArrayList("scope1" , "scope2"));
		
		ResourceModel resourceModel1 = new ResourceModel(resource);
		
		resourceModel1 = dao.save(resourceModel1);
		System.out.println("after save");
		
		
		System.out.println("before findAll");
		System.out.println(dao.findAll());
		System.out.println("after findAll");
		
		System.out.println("before findById");
		ResourceModel resourceModel2 = dao.findById(resourceModel1.getId());
		System.out.println("after findById");
		
		System.out.println("rm : " + resourceModel2.getId());
		System.out.println("rm : " + resourceModel2.getDescription());
		System.out.println("rm : " + resourceModel2.getScopes());
//		
//		
		GeneralResource generalGeneral = new GeneralResource();
		generalGeneral.setResourceID("123456789-abcde");
		
		GeneralResourceModel generalResourceModel = new GeneralResourceModel(generalGeneral);
		
		
		GeneralResourceModelDao generalResourceModelDao  = injector.getInstance(GeneralResourceModelDao.class);
		System.out.println("before save");
		generalResourceModel = generalResourceModelDao.save(generalResourceModel);
		System.out.println("after save");
		
		System.out.println("before findAll");
		System.out.println(generalResourceModelDao.findAll());
		System.out.println("after findAll");
		
		
		System.out.println("before findById");
		GeneralResourceModel generalResourceModel2 = generalResourceModelDao.findById(generalResourceModel.getId());
		System.out.println("after findById");
		
		System.out.println("rm : " + generalResourceModel2.getId());
		System.out.println("rm : " + generalResourceModel2.getDescription());
		System.out.println("rm : " + generalResourceModel2.getResourceID());
		
		
		
		Map<String, URI> endpoints = Maps.newHashMap();
		endpoints.put("key", new URI("http://google.com"));
		
		RunInstance runInstance = new RunInstance(endpoints, "id", "ghnID", "serviceName", "serviceClass", null, null);
		
		RunInstanceModel rim = new RunInstanceModel(runInstance);
		
		RunInstanceModelDao runInstanceModelDao  = injector.getInstance(RunInstanceModelDao.class);
		
		rim = runInstanceModelDao.save(rim);
		
		System.out.println(runInstanceModelDao.findAll());
		

		System.out.println("before findById");
		RunInstanceModel rim2 = runInstanceModelDao.findById(rim.getId());
		System.out.println("after findById");
		
		
		System.out.println("rim2 : " + rim2.getId());
		System.out.println("rim2" + rim2.getDescription());
		System.out.println("rim2 : " + rim2.getEndpoints());
		
		
		NodeProperties nodeProperties = new NodeProperties("nodeID", Lists.newArrayList("scopeA", "scopeB"), null);
		
		SerInstance serInstance = new SerInstance(new URI("http://google.com"), "my key", "serviceName", "serviceClass", nodeProperties);
		SerInstanceModel serInstanceModel = new SerInstanceModel(serInstance);
		
		SerInstanceModelDao serInstanceModelDao  = injector.getInstance(SerInstanceModelDao.class);
		
		
		System.out.println("before save");
		serInstanceModel = serInstanceModelDao.save(serInstanceModel);
		System.out.println("after save");
		
		System.out.println("before findAll");
		System.out.println(serInstanceModelDao.findAll());
		System.out.println("after findAll");
		
		
		System.out.println("before findById");
		SerInstanceModel serInstanceModel2 = serInstanceModelDao.findById(serInstanceModel.getId());
		System.out.println("after findById");
		
		System.out.println("rm : " + serInstanceModel2.getId());
		System.out.println("rm : " + serInstanceModel2.getDescription());
		System.out.println("rm : " + serInstanceModel2.getEndpoint());
		System.out.println("rm : " + serInstanceModel2.getNodeId());
		System.out.println("rm : " + serInstanceModel2.getScopes());
		System.out.println("rm : " + serInstanceModel2.getEndpoint());
		
		SerInstance serInstance2 = serInstanceModel2.copyTo();
		
		System.out.println("are equal ? : " + serInstance2.equals(serInstance));
		
		
		ai.stop();
		
	}
	
}
