/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.model.app;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.gcube.rest.commons.db.dao.core.ConverterRecord;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.w3c.dom.Node;

@Entity
@Table(name="resource_model")
public class ResourceModel
extends ConverterRecord<Resource> {
    private static final long serialVersionUID = 1L;
    @Column(name="resourceID")
    private String resourceID;
    @Column(name="name")
    private String name;
    @Column(name="type")
    private String type;
    @Column(name="scopes")
    @ElementCollection(targetClass=String.class)
    private List<String> scopes;
    @Column(name="body")
    private String body;

    public ResourceModel() {
    }

    public ResourceModel(Resource base) {
        this.copyFrom(base);
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public final void copyFrom(Resource resource) {
        this.resourceID = resource.getResourceID();
        this.name = resource.getName();
        this.type = resource.getType();
        this.setDescription(resource.getDescription());
        this.body = resource.getBodyAsString();
        if (resource.getScopes() != null) {
            this.scopes = Lists.newArrayList((Iterable)resource.getScopes());
        }
    }

    @Override
    public final Resource copyTo() throws IllegalStateException {
        Node node = XMLConverter.stringToNode((String)this.body);
        if (node == null && !Strings.isNullOrEmpty((String)this.body)) {
            throw new IllegalStateException("error while creating object from convertable");
        }
        Resource resource = new Resource();
        resource.setResourceID(this.resourceID);
        resource.setName(this.name);
        resource.setType(this.type);
        resource.setDescription(this.getDescription());
        resource.setScopes((List)Lists.newArrayList(this.scopes));
        resource.setBody(node);
        return resource;
    }
}

