/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.dao.app;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.gcube.rest.commons.db.model.app.ResourceModel;
import org.gcube.rest.commons.db.model.core.GenericDaoImpl;
import org.gcube.rest.commons.db.model.core.IGenericDAO;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

@Singleton
public class ResourceModelDao
extends GenericDaoImpl<ResourceModel>
implements IGenericDAO<ResourceModel> {
    private static final String SCOPES_FIELD_NAME = "scopes";
    private static final String SCOPES_ALIAS = "s";
    private static final Map<String, String> aliases = ImmutableMap.of((Object)"scopes", (Object)"s");
    public static final Function<ResourceModel, Resource> converterResourceModelToResource = new Function<ResourceModel, Resource>(){

        public Resource apply(ResourceModel input) {
            return input.copyTo();
        }
    };
    public static final Function<Resource, ResourceModel> converterResourceResourceModel = new Function<Resource, ResourceModel>(){

        public ResourceModel apply(Resource input) {
            return new ResourceModel(input);
        }
    };

    @Override
    public Class<ResourceModel> getClazz() {
        return ResourceModel.class;
    }

    public List<ResourceModel> getGenericResourcesByID(String resourceID, String scope) {
        SimpleExpression criterion1 = Restrictions.eq((String)"resourceID", (Object)resourceID);
        SimpleExpression criterion2 = Restrictions.eq((String)"s.elements", (Object)scope);
        List<ResourceModel> results = this.findByCriteria(aliases, new Criterion[]{criterion1, criterion2});
        return results;
    }

    public List<ResourceModel> getGenericResourcesByName(String name, String scope) {
        SimpleExpression criterion1 = Restrictions.eq((String)"name", (Object)name);
        SimpleExpression criterion2 = Restrictions.eq((String)"s.elements", (Object)scope);
        List<ResourceModel> results = this.findByCriteria(aliases, new Criterion[]{criterion1, criterion2});
        return results;
    }

    public List<ResourceModel> getGenericResourcesByType(String type, String scope) {
        SimpleExpression criterion1 = Restrictions.eq((String)"type", (Object)type);
        SimpleExpression criterion2 = Restrictions.eq((String)"s.elements", (Object)scope);
        List<ResourceModel> results = this.findByCriteria(aliases, new Criterion[]{criterion1, criterion2});
        return results;
    }

    public List<ResourceModel> getGenericResourcesByTypeAndName(String type, String name, String scope) {
        SimpleExpression criterion1 = Restrictions.eq((String)"type", (Object)type);
        SimpleExpression criterion2 = Restrictions.eq((String)"name", (Object)name);
        SimpleExpression criterion3 = Restrictions.eq((String)"s.elements", (Object)scope);
        List<ResourceModel> results = this.findByCriteria(aliases, new Criterion[]{criterion1, criterion2, criterion3});
        return results;
    }

    public List<String> listGenericResourceIDsByType(String type, String scope) {
        SimpleExpression criterion1 = Restrictions.eq((String)"type", (Object)type);
        SimpleExpression criterion2 = Restrictions.eq((String)"s.elements", (Object)scope);
        List results = this.findByCriteria(aliases, new Criterion[]{criterion1, criterion2});
        ArrayList ids = Lists.newArrayList();
        for (ResourceModel result : results) {
            ids.add(result.getResourceID());
        }
        return ids;
    }

    public static List<Resource> convertToResourceList(List<ResourceModel> list) {
        return Lists.newArrayList((Iterable)Collections2.transform(list, converterResourceModelToResource));
    }
}

