/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.security.secrets.UmaTokenSecret;

public class AccessTokenSecret
extends Secret {
    public static final long TOLERANCE = TimeUnit.MILLISECONDS.toMillis(200L);
    private String accessToken;
    private String context;
    private UmaTokenSecret umaTokenSecret;
    protected boolean initialised = false;

    public AccessTokenSecret(String accessToken, String context) {
        this.accessToken = accessToken;
        this.context = context;
        this.init();
    }

    private synchronized void init() {
        try {
            KeycloakClient client = KeycloakClientFactory.newInstance();
            TokenResponse tokenResponse = client.queryUMAToken(this.context, "Bearer " + this.accessToken, this.context, null);
            this.umaTokenSecret = new UmaTokenSecret(tokenResponse.getAccessToken());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void refreshAccessToken() {
        try {
            KeycloakClient client = KeycloakClientFactory.newInstance();
            TokenResponse tokenResponse = client.queryUMAToken(this.context, "Bearer " + this.accessToken, this.context, null);
            this.umaTokenSecret = new UmaTokenSecret(tokenResponse.getAccessToken());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Owner getOwner() {
        return this.umaTokenSecret.getOwner();
    }

    public String getContext() {
        if (this.umaTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.umaTokenSecret.getContext();
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        if (this.umaTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.umaTokenSecret.getHTTPAuthorizationHeaders();
    }

    public boolean isValid() {
        if (this.umaTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.umaTokenSecret.isValid();
    }
}

