package org.gcube.common.software.analyser;

import java.io.File;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.software.utils.Utils;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class AnalyserFactory {
	
	public static final String EXPORT_FILENAME_EXTENSION = ".json";
	
	public static final String GLOBAL_PROPERTY_NAME = "global";
	public static final String VERSIONS_PROPERTY_NAME = "versions";
	
	public static Analyser getAnalyser(File jsonFile) throws Exception {
		ObjectMapper objectMapper = Utils.getObjectMapper();
		JsonNode jsonNode = objectMapper.readTree(jsonFile);
		return getAnalyser(jsonNode);
	}
	
	public static Analyser getAnalyser(String json) throws Exception {
		ObjectMapper objectMapper = Utils.getObjectMapper();
		JsonNode jsonNode = objectMapper.readTree(json);
		return getAnalyser(jsonNode);
	}
	
	public static Analyser getAnalyser(JsonNode jsonNode) throws Exception {
		Analyser analyser = new Analyser();
		ObjectNode originalGlobal = (ObjectNode) jsonNode.get(GLOBAL_PROPERTY_NAME);
		analyser.setGlobalConfiguration(originalGlobal);
		ArrayNode originalVersions = (ArrayNode) jsonNode.get(VERSIONS_PROPERTY_NAME);
		analyser.setVersionConfigurations(originalVersions);
		return analyser;
	}
	
}
