/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.SerializationFeature;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;

public class Utils {
    public static final String DATETIME_PATTERN = "yyyy-MM-dd";
    protected static ObjectMapper objectMapper = new ObjectMapper();

    public static String getDateAsString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
        return simpleDateFormat.format(date);
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static String replaceVariable(String variableName, String replace, String s) {
        return s.replaceAll("\\{\\{" + variableName + "\\}\\}", replace);
    }

    public static JsonNode merge(JsonNode node1, JsonNode node2) {
        ObjectNode cloned = (ObjectNode)node1.deepCopy();
        Iterator iterator = node2.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            JsonNode value = node2.get(fieldName);
            cloned.replace(fieldName, value.deepCopy());
        }
        return cloned;
    }

    static {
        SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_PATTERN);
        objectMapper.setDateFormat((DateFormat)sdf);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }
}

