/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.analyser;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gcube.com.fasterxml.jackson.core.TreeNode;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.software.model.GlobalConfig;
import org.gcube.common.software.model.ProcessorConfig;
import org.gcube.common.software.model.SoftwareArtifactFile;
import org.gcube.common.software.model.SoftwareArtifactMetadata;
import org.gcube.common.software.model.Variables;
import org.gcube.common.software.processor.SoftwareArtifactProcessor;
import org.gcube.common.software.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyser {
    private static final Logger logger = LoggerFactory.getLogger(Analyser.class);
    protected ObjectMapper objectMapper = Utils.getObjectMapper();
    protected File outputDirectory;
    protected ObjectNode globalConfiguration;
    protected ArrayNode artifactMetadataArray;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public ObjectNode getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(ObjectNode originalGlobalConfiguration) {
        this.globalConfiguration = originalGlobalConfiguration.deepCopy();
    }

    public ArrayNode getArtifactMetadataArray() {
        return this.artifactMetadataArray;
    }

    public void setArtifactMetadataArray(ArrayNode original) {
        this.artifactMetadataArray = original.deepCopy();
    }

    protected SoftwareArtifactMetadata actualizeSoftwareArtifactConfig(JsonNode version) throws Exception {
        ((ObjectNode)version).remove("processors");
        Variables variables = (Variables)this.objectMapper.treeToValue((TreeNode)version, Variables.class);
        Set<String> missingVariables = variables.parse();
        int size = missingVariables.size();
        if (size > 0) {
            throw new Exception("The following variables has been used but not defined or cannot be actualised" + missingVariables.toArray(new String[size]).toString());
        }
        JsonNode swVersion = (JsonNode)this.objectMapper.convertValue(variables.getProperties(), JsonNode.class);
        SoftwareArtifactMetadata softwareVersionConfig = (SoftwareArtifactMetadata)this.objectMapper.treeToValue((TreeNode)swVersion, SoftwareArtifactMetadata.class);
        List<SoftwareArtifactFile> svfs = softwareVersionConfig.getFiles();
        for (SoftwareArtifactFile svf : svfs) {
            URL url = svf.getURL();
            String urlString = variables.replaceAllVariables(url.toString());
            svf.setURL(new URL(urlString));
            String desiredName = svf.getDesiredName();
            desiredName = variables.replaceAllVariables(desiredName);
            svf.setDesiredName(desiredName);
        }
        return softwareVersionConfig;
    }

    protected GlobalConfig getGlobalConfig(JsonNode node) throws Exception {
        Variables variables = (Variables)this.objectMapper.treeToValue((TreeNode)node, Variables.class);
        variables.parse();
        JsonNode sc = (JsonNode)this.objectMapper.convertValue(variables.getProperties(), JsonNode.class);
        GlobalConfig globalConfig = (GlobalConfig)this.objectMapper.treeToValue((TreeNode)sc, GlobalConfig.class);
        globalConfig.setOriginalJson(this.globalConfiguration);
        return globalConfig;
    }

    protected ProcessorConfig actualizeProcessorConfig(ProcessorConfig processorConfig, SoftwareArtifactMetadata softwareArtifactMetadata) throws Exception {
        ObjectNode versionNode = (ObjectNode)this.objectMapper.valueToTree((Object)softwareArtifactMetadata);
        Variables versionVariables = (Variables)this.objectMapper.treeToValue((TreeNode)versionNode, Variables.class);
        ObjectNode node = (ObjectNode)this.objectMapper.valueToTree((Object)processorConfig);
        Variables variables = (Variables)this.objectMapper.treeToValue((TreeNode)node, Variables.class);
        variables.parseWith(versionVariables);
        JsonNode ec = (JsonNode)this.objectMapper.convertValue(variables.getProperties(), JsonNode.class);
        return (ProcessorConfig)this.objectMapper.treeToValue((TreeNode)ec, ProcessorConfig.class);
    }

    protected void checkProcessors(Set<String> availableProcessorNames, Set<String> requestedProcessorNames) throws Exception {
        if (!availableProcessorNames.containsAll(requestedProcessorNames)) {
            requestedProcessorNames.removeAll(availableProcessorNames);
            throw new Exception("The following requested exporters does not exists " + requestedProcessorNames);
        }
    }

    public List<File> analyse() throws Exception {
        GlobalConfig globalConfig = this.getGlobalConfig((JsonNode)this.globalConfiguration);
        Map<String, Class<? extends SoftwareArtifactProcessor>> availableProcessors = SoftwareArtifactProcessor.getAvailableProcessors();
        Map<String, ProcessorConfig> requestedProcessors = globalConfig.getProcessorConfigurations();
        this.checkProcessors(availableProcessors.keySet(), requestedProcessors.keySet());
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(globalConfig.getFileName());
        }
        if (!this.outputDirectory.exists()) {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        SoftwareArtifactMetadata previous = null;
        int i = 0;
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (i = 0; i < this.artifactMetadataArray.size(); ++i) {
            ObjectNode artifactMetadata = (ObjectNode)this.artifactMetadataArray.get(i).deepCopy();
            JsonNode mergedArtifactMetadata = Utils.merge((JsonNode)this.globalConfiguration, (JsonNode)artifactMetadata);
            SoftwareArtifactMetadata softwareArtifactMetadata = this.actualizeSoftwareArtifactConfig(mergedArtifactMetadata);
            softwareArtifactMetadata.setOriginalJson(artifactMetadata);
            softwareArtifactMetadata.setPrevious(previous);
            logger.trace("Going to process {}", (Object)softwareArtifactMetadata.getTitle());
            for (String className : requestedProcessors.keySet()) {
                logger.debug("Going to export with {}", (Object)className);
                Class<? extends SoftwareArtifactProcessor> processorClass = availableProcessors.get(className);
                ProcessorConfig processorConfig = requestedProcessors.get(className);
                processorConfig = this.actualizeProcessorConfig(processorConfig, softwareArtifactMetadata);
                SoftwareArtifactProcessor sap = processorClass.newInstance();
                sap.setOutputDirectory(this.outputDirectory);
                sap.setGlobalConfig(globalConfig);
                sap.setSoftwareArtifactConfig(softwareArtifactMetadata);
                sap.setProcessorConfig(processorConfig);
                sap.setFirst(i == 0);
                boolean last = i == this.artifactMetadataArray.size() - 1;
                sap.setLast(last);
                sap.export();
                if (!last) continue;
                outputFiles.add(sap.getOutputFile());
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
            previous = softwareArtifactMetadata;
        }
        return outputFiles;
    }
}

