/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.GenericItemContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.ListResolverTyped;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;

public class FolderContainer
extends ItemContainer<FolderItem> {
    protected FolderContainer(ItemManagerClient itemclient, FolderItem item) {
        super(itemclient, item);
    }

    protected FolderContainer(ItemManagerClient itemclient, String folderId) {
        super(itemclient, folderId);
    }

    @Override
    public ContainerType getType() {
        return ContainerType.FOLDER;
    }

    public ListResolverTyped list() {
        return new ListResolverTyped((onlyType, excludes) -> this.itemclient.getChildren(this.itemId, onlyType, excludes), this.itemclient);
    }

    public FileContainer uploadFile(InputStream stream, String filename, String description) {
        return new FileContainer(this.itemclient, this.itemclient.uploadFile(stream, this.itemId, filename, description));
    }

    public FolderContainer uploadArchive(InputStream stream, String extractionFolderName) {
        return new FolderContainer(this.itemclient, this.itemclient.uploadArchive(stream, this.itemId, extractionFolderName));
    }

    public FolderContainer newFolder(String name, String description) throws Exception {
        String newFolderId = this.itemclient.createFolder(this.itemId, name, description);
        return new FolderContainer(this.itemclient, newFolderId);
    }

    public GenericItemContainer newGcubeItem(GCubeItem item) throws Exception {
        String itemId = this.itemclient.createGcubeItem(this.itemId, item);
        return new GenericItemContainer(this.itemclient, itemId);
    }

    public List<ACL> getAcls() throws Exception {
        return this.itemclient.getACL(this.itemId);
    }

    public ListResolver findByName(String namePattern) {
        return new ListResolver((onlyType, excludes) -> this.itemclient.findChildrenByNamePattern(this.itemId, namePattern, excludes), this.itemclient);
    }

    public FolderContainer share(Set<String> users, AccessType accessType) throws Exception {
        this.itemclient.shareFolder(this.itemId, users, accessType);
        return this;
    }

    public FolderContainer unshare(Set<String> users) throws Exception {
        this.itemclient.unshareFolder(this.itemId, users);
        return this;
    }
}

