package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.scope.impl.ScopeBean.Type;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;

public class Util {
 
	protected static ItemContainer<? extends Item> getContainerFromItem(Item item,ItemManagerClient itemClient){
		if (item instanceof AbstractFileItem) 
			return new FileContainer(itemClient, (AbstractFileItem)item);
		else if (item instanceof FolderItem)
			return new FolderContainer(itemClient, (FolderItem)item);
		else return new GenericItemContainer(itemClient, item);
	}
	
	public static String getVREGroupFromContext(String context) throws BackendGenericError{
		ScopeBean bean = new ScopeBean(context);
		if (!bean.is(Type.VRE)) throw new BackendGenericError(context+ " is not a VRE context");
		String entireScopeName= bean.toString().replaceAll("^/(.*)/?$", "$1").replaceAll("/", "-");
		return entireScopeName;
	}
}
