package org.gcube.common.storagehub.model.items.nodes;

import static org.gcube.common.storagehub.model.NodeConstants.PARAMETERS_NAME;

import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.annotations.Attribute;
import org.gcube.common.storagehub.model.annotations.AttributeRootNode;
import org.gcube.common.storagehub.model.annotations.NodeAttribute;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@AttributeRootNode(value="nthl:externalRepostiory")
public class ExternalRepository {

	@Attribute("hl:pluginName")
	String plugin;
	
	@JsonIgnore
	@NodeAttribute(value=PARAMETERS_NAME)
	Metadata metadata = new Metadata();
	
	
}
