/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.bencode;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bitlet.wetorrent.bencode.DictionaryComparator;

public class Bencode {
    private Object rootElement = null;

    public Bencode(InputStream is) throws IOException {
        if (!is.markSupported()) {
            throw new IOException("is.markSupported should be true");
        }
        this.rootElement = this.parse(is);
    }

    public Bencode() {
    }

    public void print(OutputStream os) throws IOException {
        this.print(this.rootElement, os);
    }

    private void print(Object object, OutputStream os) throws IOException {
        if (object instanceof Long) {
            os.write(105);
            os.write(((Long)object).toString().getBytes());
            os.write(101);
        }
        if (object instanceof ByteBuffer) {
            byte[] byteString = ((ByteBuffer)object).array();
            os.write(Integer.toString(byteString.length).getBytes());
            os.write(58);
            for (int i = 0; i < byteString.length; ++i) {
                os.write(byteString[i]);
            }
        } else if (object instanceof List) {
            List list = (List)object;
            os.write(108);
            for (Object elem : list) {
                this.print(elem, os);
            }
            os.write(101);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            os.write(100);
            TreeMap sortedMap = new TreeMap(new DictionaryComparator());
            for (Map.Entry entry : map.entrySet()) {
                sortedMap.put((ByteBuffer)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : sortedMap.entrySet()) {
                this.print(entry.getKey(), os);
                this.print(entry.getValue(), os);
            }
            os.write(101);
        }
    }

    private Object parse(InputStream is) throws IOException {
        is.mark(0);
        int readChar = is.read();
        switch (readChar) {
            case 105: {
                return this.parseInteger(is);
            }
            case 108: {
                return this.parseList(is);
            }
            case 100: {
                return this.parseDictionary(is);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                is.reset();
                return this.parseByteString(is);
            }
        }
        throw new IOException("Problem parsing bencoded file");
    }

    public Object getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(Object rootElement) {
        this.rootElement = rootElement;
    }

    private Long parseInteger(InputStream is) throws IOException {
        int readChar = is.read();
        StringBuffer buff = new StringBuffer();
        do {
            if (readChar < 0) {
                throw new IOException("Unexpected EOF found");
            }
            buff.append((char)readChar);
        } while ((readChar = is.read()) != 101);
        return Long.parseLong(buff.toString());
    }

    private List<Object> parseList(InputStream is) throws IOException {
        LinkedList<Object> list = new LinkedList<Object>();
        is.mark(0);
        int readChar = is.read();
        while (readChar != 101) {
            if (readChar < 0) {
                throw new IOException("Unexpected EOF found");
            }
            is.reset();
            list.add(this.parse(is));
            is.mark(0);
            readChar = is.read();
        }
        return list;
    }

    private SortedMap<ByteBuffer, Object> parseDictionary(InputStream is) throws IOException {
        TreeMap<ByteBuffer, Object> map = new TreeMap<ByteBuffer, Object>(new DictionaryComparator());
        is.mark(0);
        int readChar = is.read();
        while (readChar != 101) {
            if (readChar < 0) {
                throw new IOException("Unexpected EOF found");
            }
            is.reset();
            map.put(this.parseByteString(is), this.parse(is));
            is.mark(0);
            readChar = is.read();
        }
        return map;
    }

    private ByteBuffer parseByteString(InputStream is) throws IOException {
        int readChar = is.read();
        StringBuffer buff = new StringBuffer();
        do {
            if (readChar < 0) {
                throw new IOException("Unexpected EOF found");
            }
            buff.append((char)readChar);
        } while ((readChar = is.read()) != 58);
        Integer length = Integer.parseInt(buff.toString());
        byte[] byteString = new byte[length.intValue()];
        for (int i = 0; i < byteString.length; ++i) {
            byteString[i] = (byte)is.read();
        }
        return ByteBuffer.wrap(byteString);
    }
}

