/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer.task;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.bitlet.wetorrent.peer.IncomingPeerListener;
import org.bitlet.wetorrent.peer.TorrentPeer;
import org.bitlet.wetorrent.util.Utils;
import org.bitlet.wetorrent.util.stream.OutputStreamLimiter;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class Handshake
implements ThreadTask {
    TorrentPeer peer;
    IncomingPeerListener incomingPeerListener = null;

    public Handshake(TorrentPeer peer) {
        this.peer = peer;
    }

    public Handshake(TorrentPeer peer, IncomingPeerListener incomingPeerListener) {
        this.peer = peer;
        this.incomingPeerListener = incomingPeerListener;
    }

    private void sendProtocolHeader(TorrentPeer peer) throws IOException {
        DataOutputStream os = new DataOutputStream(new OutputStreamLimiter(peer.getSocket().getOutputStream(), peer.getPeersManager().getTorrent().getUploadBandwidthLimiter()));
        os.writeByte(19);
        os.write("BitTorrent protocol".getBytes());
        os.write(new byte[8]);
        os.write(peer.getPeersManager().getTorrent().getMetafile().getInfoSha1());
        os.write(peer.getPeersManager().getTorrent().getPeerId());
    }

    @Override
    public boolean execute() throws Exception {
        byte protocolIdentifierLength;
        DataInputStream is = new DataInputStream(this.peer.getSocket().getInputStream());
        if (this.peer.getPeersManager() != null && this.incomingPeerListener == null) {
            this.sendProtocolHeader(this.peer);
        }
        if ((protocolIdentifierLength = is.readByte()) != 19) {
            throw new Exception("Error, wrong protocol identifier length " + protocolIdentifierLength);
        }
        byte[] protocolByteString = new byte[protocolIdentifierLength];
        is.readFully(protocolByteString);
        if (!Utils.bytesCompare("BitTorrent protocol".getBytes(), protocolByteString)) {
            throw new Exception("Error, wrong protocol identifier");
        }
        byte[] reserved = new byte[8];
        is.readFully(reserved);
        byte[] infoHash = new byte[20];
        is.readFully(infoHash);
        if (this.peer.getPeersManager() == null && this.incomingPeerListener != null) {
            if (!this.incomingPeerListener.dispatchPeer(this.peer, infoHash)) {
                this.peer.getSocket().close();
                throw new Exception("Wrong info hash");
            }
            this.sendProtocolHeader(this.peer);
        } else if (!Utils.bytesCompare(infoHash, this.peer.getPeersManager().getTorrent().getMetafile().getInfoSha1())) {
            this.peer.getSocket().close();
            throw new Exception("Wrong info hash");
        }
        byte[] peerId = new byte[20];
        is.readFully(peerId);
        if (Utils.bytesCompare(peerId, this.peer.getPeersManager().getTorrent().getPeerId())) {
            this.peer.getSocket().close();
            throw new Exception("Avoid self connections");
        }
        if (this.peer.getPeerId() != null) {
            if (!Utils.bytesCompare(this.peer.getPeerId(), peerId)) {
                this.peer.getSocket().close();
                throw new Exception("Wrong peer id");
            }
        } else {
            this.peer.setPeerId(peerId);
        }
        this.peer.getPeersManager().connected(this.peer);
        return false;
    }

    @Override
    public void interrupt() {
        try {
            this.peer.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void exceptionCought(Exception e) {
        if (e instanceof EOFException) {
            // empty if block
        }
        if (this.incomingPeerListener != null) {
            this.incomingPeerListener.removePeer(this.peer);
        }
        this.peer.interrupt();
    }
}

