/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.util.stream;

public class BandwidthLimiter {
    private static final int CHUNK_SIZE = 256;
    int bytesToChunk = 0;
    long lastChunkSent = System.nanoTime();
    int maximumRate = 24;
    long nanosToWait = 256000000000L / ((long)this.maximumRate * 1024L);

    public synchronized void setMaximumRate(int maximumRate) throws IllegalArgumentException {
        if (maximumRate < 1) {
            throw new IllegalArgumentException("maximumRate must be grater than 0");
        }
        this.maximumRate = maximumRate;
        this.nanosToWait = 256000000000L / ((long)maximumRate * 1024L);
    }

    public synchronized void limitNextByte() {
        this.limitNextBytes(1);
    }

    public synchronized void limitNextBytes(int len) {
        this.bytesToChunk += len;
        while (this.bytesToChunk > 256) {
            long now = System.nanoTime();
            long missingNanos = this.nanosToWait - (now - this.lastChunkSent);
            if (missingNanos > 0L) {
                try {
                    Thread.sleep(missingNanos / 1000000L, (int)missingNanos % 1000000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.bytesToChunk -= 256;
            this.lastChunkSent = now + (missingNanos > 0L ? missingNanos : 0L);
        }
    }
}

