/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer;

import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import org.bitlet.wetorrent.peer.IncomingPeerListener;
import org.bitlet.wetorrent.peer.Peer;
import org.bitlet.wetorrent.peer.PeersManager;
import org.bitlet.wetorrent.peer.message.Cancel;
import org.bitlet.wetorrent.peer.message.Message;
import org.bitlet.wetorrent.peer.message.Piece;
import org.bitlet.wetorrent.peer.message.Request;
import org.bitlet.wetorrent.peer.task.Handshake;
import org.bitlet.wetorrent.peer.task.MessageReceiver;
import org.bitlet.wetorrent.peer.task.MessageSender;
import org.bitlet.wetorrent.peer.task.SendBitfield;
import org.bitlet.wetorrent.peer.task.StartConnection;
import org.bitlet.wetorrent.peer.task.StartMessageReceiver;
import org.bitlet.wetorrent.util.Utils;
import org.bitlet.wetorrent.util.thread.InterruptableTasksThread;

public class TorrentPeer
implements Peer {
    private byte[] peerId;
    private String peerIdEncoded;
    private int port;
    private InetAddress ip;
    private byte[] bitfield;
    private Socket socket;
    boolean isChoked = true;
    boolean isInterested = false;
    boolean amChoked = true;
    boolean amInterested = false;
    private PeersManager peersManager;
    private InterruptableTasksThread receiverThread;
    private InterruptableTasksThread mainThread;
    private long downloaded;
    private MessageSender messageSender;
    private MessageReceiver messageReceiver;
    private List<Request> unfulfilledRequests = new LinkedList<Request>();

    public TorrentPeer(byte[] peerId, InetAddress ip, int port, PeersManager peersManager) {
        this.peersManager = peersManager;
        this.peerId = peerId;
        this.peerIdEncoded = Utils.byteArrayToURLString(peerId);
        this.port = port;
        this.ip = ip;
        this.bitfield = new byte[peersManager.getTorrent().getTorrentDisk().getBitfieldCopy().length];
        this.mainThread = new InterruptableTasksThread();
        this.mainThread.addTask(new StartConnection(this));
        this.mainThread.addTask(new Handshake(this));
        this.mainThread.addTask(new SendBitfield(this));
        this.receiverThread = new InterruptableTasksThread();
        this.messageReceiver = new MessageReceiver(this);
        this.receiverThread.addTask(this.messageReceiver);
        this.mainThread.addTask(new StartMessageReceiver(this));
        this.messageSender = new MessageSender(this);
        this.mainThread.addTask(this.messageSender);
    }

    public TorrentPeer(Socket socket, IncomingPeerListener incomingPeerListener) {
        this.socket = socket;
        this.port = socket.getPort();
        this.ip = socket.getInetAddress();
        this.mainThread = new InterruptableTasksThread();
        this.mainThread.addTask(new Handshake(this, incomingPeerListener));
        this.mainThread.addTask(new SendBitfield(this));
        this.receiverThread = new InterruptableTasksThread();
        this.messageReceiver = new MessageReceiver(this);
        this.receiverThread.addTask(this.messageReceiver);
        this.mainThread.addTask(new StartMessageReceiver(this));
        this.messageSender = new MessageSender(this);
        this.mainThread.addTask(this.messageSender);
    }

    public void start() {
        this.mainThread.start();
    }

    public void exceptionCought(Exception e) {
        this.receiverThread.interrupt();
        this.mainThread.interrupt();
    }

    public String getPeerIdEncoded() {
        return this.peerIdEncoded;
    }

    @Override
    public byte[] getPeerId() {
        return this.peerId;
    }

    public void setPeerId(byte[] peerId) {
        this.peerId = peerId;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public synchronized PeersManager getPeersManager() {
        return this.peersManager;
    }

    @Override
    public InetAddress getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public synchronized void setBitfield(byte[] bitfield) {
        this.bitfield = bitfield;
    }

    public void bitfield(byte[] bitfield) {
        this.setBitfield(bitfield);
        this.peersManager.getTorrent().bitfield(bitfield, this);
    }

    public void choke() {
        this.amChoked = true;
        this.peersManager.getTorrent().choke(this);
    }

    public void unchoke() {
        this.amChoked = false;
        this.messageSender.cancelAll();
        this.peersManager.getTorrent().unchoke(this);
    }

    public void interested() {
        this.isInterested = true;
        this.peersManager.getTorrent().interested(this);
    }

    public void notInterested() {
        this.isInterested = false;
        this.peersManager.getTorrent().notInterested(this);
    }

    public void have(int i) {
        this.setPiece(i);
        this.peersManager.getTorrent().have(i, this);
    }

    public void request(int index, int begin, int length) {
        if (!this.isChoked) {
            this.messageSender.addMessage(new Piece(index, begin, length, this.peersManager.getTorrent().getTorrentDisk()));
        }
    }

    public void piece(int index, int begin, byte[] block) {
        this.downloaded += (long)block.length;
        if (this.requestFulfilled(index, begin, block)) {
            this.peersManager.getTorrent().piece(index, begin, block, this);
        }
    }

    public void cancel(int index, int begin, int length) {
        this.messageSender.cancel(index, begin, length);
    }

    public InterruptableTasksThread getReceiverThread() {
        return this.receiverThread;
    }

    @Override
    public synchronized void sendMessage(Message message) {
        this.messageSender.addMessage(message);
        switch (message.getType()) {
            case 6: {
                this.addRequest((Request)message);
                break;
            }
            case 8: {
                Cancel cancel = (Cancel)message;
                this.requestCanceled(cancel.getIndex(), cancel.getBegin());
            }
        }
    }

    @Override
    public void interrupt() {
        this.mainThread.interrupt();
        this.receiverThread.interrupt();
        if (this.peersManager != null) {
            this.peersManager.interrupted(this);
        }
    }

    public synchronized byte[] getBitfieldCopy() {
        return (byte[])this.bitfield.clone();
    }

    @Override
    public synchronized boolean hasPiece(int index) {
        return (this.bitfield[index >> 3] & 128 >> (index & 7)) > 0;
    }

    public synchronized void setPiece(int index) {
        int n = index >> 3;
        this.bitfield[n] = (byte)(this.bitfield[n] | 128 >> (index & 7));
    }

    public void keepAlive() {
        long now = System.currentTimeMillis();
        if (now - this.messageSender.getLastSentMessageMillis() < 2000L) {
            this.sendMessage(new Message(-1, null));
        }
    }

    @Override
    public long getUploaded() {
        return this.messageSender.getUploaded();
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public void setAmInterested(boolean amInterested) {
        if (!this.amInterested && amInterested) {
            this.sendMessage(new Message(2, null));
        } else if (this.amInterested && !amInterested) {
            this.sendMessage(new Message(3, null));
        }
        this.amInterested = amInterested;
    }

    @Override
    public void setIsChoked(boolean isChoked) {
        if (!this.isChoked && isChoked) {
            this.sendMessage(new Message(0, null));
        } else if (this.isChoked && !isChoked) {
            this.sendMessage(new Message(1, null));
        }
        this.isChoked = isChoked;
    }

    public boolean isIsChoked() {
        return this.isChoked;
    }

    @Override
    public boolean isAmChoked() {
        return this.amChoked;
    }

    @Override
    public synchronized boolean isSeeder() {
        for (int i = 0; i < this.getPeersManager().getTorrent().getMetafile().getPieces().size(); ++i) {
            if (this.hasPiece(i)) continue;
            return false;
        }
        return true;
    }

    private synchronized void addRequest(Request request) {
        this.unfulfilledRequests.add(request);
    }

    @Override
    public synchronized int getUnfulfilledRequestNumber() {
        return this.unfulfilledRequests.size();
    }

    private synchronized boolean requestFulfilled(int index, int begin, byte[] block) {
        for (Request r : this.unfulfilledRequests) {
            if (r.getIndex() != index || r.getBegin() != begin || r.getLength() != block.length) continue;
            this.unfulfilledRequests.remove(r);
            return true;
        }
        return false;
    }

    private synchronized boolean requestCanceled(int index, int begin) {
        for (Request r : this.unfulfilledRequests) {
            if (r.getIndex() != index || r.getBegin() != begin) continue;
            this.unfulfilledRequests.remove(r);
            return true;
        }
        return false;
    }

    public synchronized Request getLastUnfulfilledRequest() {
        if (this.unfulfilledRequests.size() == 0) {
            return null;
        }
        Request last = this.unfulfilledRequests.get(this.unfulfilledRequests.size() - 1);
        return last;
    }

    @Override
    public long getLastReceivedMessageMillis() {
        return this.messageReceiver.getLastReceivedMessageMillis();
    }

    synchronized void setPeersManager(PeersManager peersManager) {
        this.peersManager = peersManager;
        this.bitfield = new byte[peersManager.getTorrent().getTorrentDisk().getBitfieldCopy().length];
    }
}

