/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.mongodb.driver;

import com.mongodb.BasicDBObject;
import com.mongodb.Block;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.gcube.content.storage.rest.utils.Utils;
import org.gcube.mongodb.driver.MongoClientInstance;
import org.gcube.mongodb.driver.MongoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoClientInstance {
    private static final HashMap<String, MongoClientInstance> instances = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(MongoClientInstance.class);
    private static final HashMap<String, MongoConfiguration> configuration = new HashMap();
    private static final HashMap<String, MongoClient> mongo = new HashMap();

    private MongoClientInstance(MongoConfiguration configuration) {
        MongoClientInstance.configuration.put(configuration.getDb(), configuration);
        logger.debug("Try to connect to " + configuration.getServers().get(0));
        if (configuration.getPwd() != null && configuration.getPwd().length() > 0 && configuration.getUser() != null && configuration.getUser().length() > 0) {
            logger.debug("Mongo configuration with authentication enabled for user: " + configuration.getUser());
            MongoCredential credential = MongoCredential.createCredential((String)configuration.getUser(), (String)configuration.getDb(), (char[])configuration.getPwd().toCharArray());
            logger.debug("Try to connect to " + configuration.getServers().get(0));
            if (configuration.getOptions() != null) {
                mongo.put(configuration.getDb(), new MongoClient(configuration.getServers(), Arrays.asList(credential), configuration.getOptions()));
            } else {
                mongo.put(configuration.getDb(), new MongoClient(configuration.getServers(), Arrays.asList(credential), MongoClientOptions.builder().connectionsPerHost(30).connectTimeout(30000).readPreference(ReadPreference.primaryPreferred()).build()));
            }
        } else {
            logger.debug("Mongo Coonfiguration without authentication");
            if (configuration.getOptions() != null) {
                mongo.put(configuration.getDb(), new MongoClient(configuration.getServers(), configuration.getOptions()));
            } else {
                mongo.put(configuration.getDb(), new MongoClient(configuration.getServers()));
            }
        }
        logger.debug("mongo instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MongoClientInstance getInstance(MongoConfiguration configuration) {
        MongoClientInstance instance = (MongoClientInstance)instances.get(configuration.getDb());
        if (instance != null) return instance;
        logger.debug("Going to create a new MongoInstance object");
        Class<MongoClientInstance> clazz = MongoClientInstance.class;
        synchronized (MongoClientInstance.class) {
            if (instance != null) return instance;
            instance = new MongoClientInstance(configuration);
            instances.put(configuration.getDb(), instance);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public static MongoConfiguration getConfiguration(String dbName) {
        return (MongoConfiguration)configuration.get(dbName);
    }

    public MongoDatabase getDB(String databaseName) {
        return this.getMongoClient(databaseName).getDatabase(databaseName);
    }

    public MongoCollection<Document> getCollection(String databaseName, String collectionName) {
        return ((MongoClient)mongo.get(databaseName)).getDatabase(databaseName).getCollection(collectionName);
    }

    public MongoClient getMongoClient(String db) {
        logger.debug("find mongo instance for db: " + db);
        MongoClient mongos = (MongoClient)mongo.get(db);
        if (mongos == null) {
            throw new RuntimeException("Mongo not istantiated correctly");
        }
        return (MongoClient)mongo.get(db);
    }

    public Document findOne(String db, String collection, String name, Object value) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)name, value);
        Document doc = (Document)this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)query).first();
        return doc;
    }

    public Document findOne(String db, String collection, Document doc) {
        Document docId = (Document)this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)doc).first();
        return docId;
    }

    public List<Document> find(String db, String collection, String name, Object value) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)name, value);
        MongoCursor cursor = this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)query).sort((Bson)new BasicDBObject("creationTime", (Object)1)).iterator();
        return this.fillist(cursor);
    }

    public void findPrint(String db, String collection, String name, Object value) {
        1 block = new /* Unavailable Anonymous Inner Class!! */;
        BasicDBObject query = new BasicDBObject();
        query.put((Object)name, value);
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)query).forEach((Block)block);
    }

    public List<Document> findValuesInRange(String db, String collection, long ts, int range) {
        logger.debug("find documents for the following collection: " + collection + " with ts: " + ts + " and range: " + range);
        long lowerBound = ts - (long)range;
        long upperBound = ts + (long)range;
        logger.debug("check record between " + lowerBound + " and " + upperBound);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"timestamp", (Object)new BasicDBObject("$gte", (Object)lowerBound).append("$lt", (Object)upperBound));
        Object list = null;
        MongoCursor cursor = this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)query).sort((Bson)new BasicDBObject("timestamp", (Object)1)).iterator();
        return this.fillist(cursor);
    }

    public List<Document> findAll(String db, String collection, Document execQuery) {
        MongoCursor cursor = this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)execQuery).iterator();
        return this.fillist(cursor);
    }

    private List<Document> fillist(MongoCursor<Document> cursor) {
        ArrayList<Document> list = new ArrayList<Document>();
        try {
            while (cursor.hasNext()) {
                list.add((Document)cursor.next());
            }
        }
        finally {
            cursor.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> find(String db, String collection, Document execQuery) {
        ArrayList<String> list = new ArrayList<String>();
        try (MongoCursor cursor = this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)execQuery).iterator();){
            while (cursor.hasNext()) {
                list.add(((Document)cursor.next()).toJson());
            }
        }
        return list;
    }

    public Document findById(String db, String collection, String id) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(id));
        Document doc = (Document)this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find((Bson)query).first();
        return doc;
    }

    public List<Document> find(String db, String collection) {
        logger.debug("find all documents for the following collection: " + collection);
        ArrayList<Document> list = null;
        Utils.printConfiguration((MongoConfiguration)((MongoConfiguration)configuration.get(db)));
        MongoCursor it = this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find().iterator();
        while (it.hasNext()) {
            if (list == null) {
                list = new ArrayList<Document>();
            }
            Document d = (Document)it.next();
            list.add(d);
        }
        return list;
    }

    public Iterator<Document> getIterator(String db, String collection) {
        logger.debug("find all documents for the following collection: " + collection);
        Object list = null;
        Utils.printConfiguration((MongoConfiguration)((MongoConfiguration)configuration.get(db)));
        MongoCursor it = this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).find().iterator();
        return it;
    }

    public void insertOne(String db, String collection, Document doc) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).insertOne((Object)doc);
    }

    public void insertOne(String db, String collection, String json) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).insertOne((Object)Document.parse((String)json));
    }

    public void insertMany(String db, String collection, List<Document> docs) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).insertMany(docs);
    }

    public void update(String db, String collection, String id, String json) {
        logger.debug("updating object with id " + id + " \n the new object is: " + json);
        BasicDBObject searchQuery = new BasicDBObject();
        searchQuery.append("_id", (Object)new ObjectId(id));
        Document update = Document.parse((String)json);
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).replaceOne((Bson)searchQuery, (Object)update);
    }

    public void update(String db, String collection, String id, Document json) {
        logger.debug("updating object with id " + id + " \n the new object is: " + json);
        Document filter = this.findById(db, collection, id);
        logger.debug("old document found is:" + filter.toString());
        logger.debug("new document is " + json);
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).replaceOne((Bson)filter, (Object)json);
    }

    public void deleteOne(String db, String collection, Document doc) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).deleteOne((Bson)doc);
    }

    public void deleteMany(String db, String collection, Document doc) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).deleteMany((Bson)doc);
    }

    public void deleteOne(String db, String collection, String json) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).deleteOne((Bson)Document.parse((String)json));
    }

    public void deleteById(String db, String collection, String id) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)new ObjectId(id));
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).deleteOne((Bson)query);
    }

    public void deleteMany(String db, String collection, String json) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).deleteMany((Bson)Document.parse((String)json));
    }

    public void deleteAll(String db, String collection) {
        this.getMongoClient(((MongoConfiguration)configuration.get(db)).getDb()).getDatabase(((MongoConfiguration)configuration.get(db)).getDb()).getCollection(collection).drop();
    }

    public List<Document> convertToDocuments(List<String> jsons) {
        ArrayList<Document> list = new ArrayList<Document>(jsons.size());
        for (String json : jsons) {
            list.add(Document.parse((String)json));
        }
        return list;
    }
}

